package Freenet.handshake;

import Freenet.*;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This is the superclass of all handshakes
 *
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 **/

public class Handshake extends Freenet.Handshake
{
  public String version;

  public Handshake(String ver)
    {
      version=ver;
    }

  public Handshake(RawMessage raw) throws InvalidMessageException
  {
    version=raw.readField("Version");
  }

  public RawMessage toRawMessage()
    {
      RawMessage r = new RawMessage("Handshake");
      r.setField("Version", version);
      r.trailingFieldName="EndMessage";
      return r;
    }

  public boolean check()
  {
    return version.equals(Node.versionString);
  }
}


