/*
 * $Id: DataInsert.java,v 1.21 2000/03/06 10:00:32 hobbex Exp $

   This code is part of the Java Adaptive Network Client by Ian Clarke. 
   It is distributed under the GNU Public Licence (GPL) version 2.  See
   http://www.gnu.org/ for further details of the GPL.

   Explanation of Code Versions: 
     0.0.0      = Initial Description
     0.0.1      = API Specified
     0.x (x>0)  = Partial Implementation
     x.0 (x>0)  = Operational
		
   Requires Classes: Node (1.0)
                     Address (1.0)
		     Message (1.0)

*/


/**
 * This is the DataInsert message
 *
 * @see Node
 * @see Address
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 **/

package Freenet.message;

import java.io.*;
import java.math.*;
import Freenet.*;
import Freenet.support.*;

public class DataInsert extends DataSend
{
    public boolean fixedsource=false;

    public DataInsert(long idnum, long htl,long depth)
    {
	super(idnum, htl, depth,null);
    }

    // sets the dataSource to a fixed value, so it won't be changed on send
    public DataInsert(long idnum, long htl,long depth, Address dsrc)
    {
	super(idnum, htl, depth, dsrc);
	fixedsource=true;
    }


    public DataInsert(RawMessage raw) throws InvalidMessageException
    {
	super(raw);
    }
    
    public RawMessage toRawMessage()
    {
	RawMessage raw=super.toRawMessage();
	raw.messageType="DataInsert";
	return raw;
    }
    
    public void sending(Node n, Address peer, Address myAddress) throws SendFailedException
    {
	if (myAddress.equals(peer))
	    throw new SendFailedException(peer); // don't send to yourself
	source = myAddress;
	if (!fixedsource)
	    dataSource = myAddress;
    }
}


/*
 * $Log: DataInsert.java,v $
 * Revision 1.21  2000/03/06 10:00:32  hobbex
 * Large change to the way Inserts are handled. The chain is now InsertRequest->InsertReply->DataInsert.
 *
 * Revision 1.20  2000/02/28 02:12:50  blanu
 * Now require a DataLength field.
 *
 * Revision 1.19  2000/02/15 17:40:30  hobbex
 * nother bugfix
 *
 * Revision 1.17  2000/02/13 14:06:27  sanity
 * Changed so that timeouts always start with a timeout of 256 to ensure that
 * they reach their destination.
 *
 * Revision 1.16  2000/02/13 12:11:58  sanity
 * Fixed numerous syntax errors.
 *
 * Revision 1.15  2000/02/12 14:54:35  hobbex
 * Request original data on Insert key collision
 *
 * Revision 1.14  2000/02/12 14:23:27  hobbex
 * had boolean for tunnel or not backwards (duh)
 *
 * Revision 1.13  2000/02/12 13:59:57  hobbex
 * fixed tunneling on inserts for large files. Britney never sounded so good!
 *
 * Revision 1.12  2000/02/11 20:23:46  hobbex
 * added SplitOutStream class needed for tunneling
 *
 * Revision 1.11  2000/02/11 19:11:26  blanu
 * Added InsertFailed message on key collision.
 *
 * Revision 1.10  2000/02/11 04:09:41  blanu
 * Modified tunneling code to tunnel or not tunnel based on Tunnel=YES or NO
 * in config. Modified Node to read Tunnel option. Fixed reading of
 * nodes.config to accept blank lines and lines with only whitespace.
 * Modified sample .freenetrc to include Tunnel option.
 *
 * Revision 1.9  2000/02/09 23:56:39  hobbex
 * Preliminary tunneling of DataReplies and DataInserts (for now)
 *
 * Revision 1.8  2000/01/28 21:07:32  hobbex
 * Added DataSource to Insert messages to fix the java insert client. Added Message.sending method.
 *
 * Revision 1.7  2000/01/27 00:52:34  hobbex
 * Added backtracking InsertFailed messages
 *
 * Revision 1.6  2000/01/19 15:12:21  hobbex
 * Fixed handeling of bad node addresses (SendFailedException)
 *
 * Revision 1.5  2000/01/11 06:32:05  blanu
 * fixed problem with hex uniqueid and name=value field format
 *
 * Revision 1.4  2000/01/11 01:01:46  hobbex
 * added Depth field to all messages for setting hopsToLive of replies
 *
 * Revision 1.3  2000/01/09 18:46:41  hobbex
 * Fixed setting of source field on multihomed nodes - I hope
 *
 * Revision 1.2  2000/01/06 01:04:50  hobbex
 * Don't forward Inserts and Reuqests to self or source, don't accept inserts if key is known, and added an Address.equals method
 *
 * Revision 1.1.1.1  1999/12/31 11:53:09  sanity
 * Initial import from OpenProjects
 *
 * Revision 1.3  1999/12/29 01:46:05  michael
 * removed unwanted comments (inserted by accident)
 *
 * Revision 1.2  1999/12/29 01:26:19  michael
 * Bugfix from Oskar Sandberg - DataInsert was not forwarded to the
 * correct Address
 *
 */ 
