package Freenet.message;
import java.io.*;
import java.math.*;
import Freenet.*;
import Freenet.support.*;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
		
  Requires Classes: Node (1.0)
                    Address (1.0)
		    Message (1.0)
 */

/**
 * This is the DataReply message
 *
 * @see Node
 * @see Address
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 **/

public class DataReply extends DataSend
{

  public DataReply(long idnum, long htl, long depth, Address dsrc)
    {
      super(idnum, htl, depth, dsrc);
    }

    public DataReply(long idnum, long htl, long depth, Address dsrc, Data data) throws IOException, DataNotReadyException{

	super(idnum, htl, depth, dsrc, data);
    }

  public DataReply(RawMessage raw) throws InvalidMessageException
  {
    super(raw);
  }

  public RawMessage toRawMessage()
  {
    RawMessage raw=super.toRawMessage();
    raw.messageType="DataReply";
    return raw;
  }

    public void sending(Node n, Address peer, Address myAddress) throws SendFailedException
    {
	if (myAddress.equals(peer))
	    throw new SendFailedException(peer); // don't send to yourself
	source = myAddress;

	// Set dataSource to my address if it is unknown, this message was never recieved, this message was recieved from a different network, or a random probability.
	if ( dataSource == null || receivedAt == null || !receivedAt.equals(myAddress) || ((new java.util.Random()).nextInt() % 30) == 0)
	    {
		this.dataSource = myAddress;
	    }
    }

      // Protected/Private Methods

    protected MessageMemory timeOut(Node n, MessageMemory sb)
    {
	try {
	    in.close(); // close data stream
	} catch(IOException e) {}
	if (sb == null || sb.depth <= 0) return null;

	TimedOut to=new TimedOut(id, sb.depth);
    
	try {
	    n.sendMessage(to,sb.origRec); // send to original sender, not source
	} catch(SendFailedException sfe) {
	    Logger.log("Message.java","Sending of timeout to Data Reply",Logger.NORMAL);
	}

	return null;
    }
}


