/*
 *$Id: DataRequest.java,v 1.21 2000/03/06 10:00:32 hobbex Exp $

  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
		
  Requires Classes: Node (1.0)
                    Address (1.0)
		    Message (1.0)
 */

/**
 * This is the DataRequest message
 *
 * @see Node
 * @see Address
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 **/

package Freenet.message;
import Freenet.*;
import Freenet.support.*;
import java.util.Random;

public class DataRequest extends Request
{

  public DataRequest(long idnum, long htl, long depth, Key key)
  {
      super(idnum, htl, depth, key);
  }

  public DataRequest(RawMessage raw) throws InvalidMessageException
  {
      super(raw);
  }

  public RawMessage toRawMessage()
  {
    RawMessage raw=super.toRawMessage();
    raw.messageType="DataRequest";
    return raw;
  }

    protected void refFound(Address ref, Node n) throws RequestAbortException {} // request don't do anything about found refs.

    protected void dataFound(Data data, Node n) throws RequestAbortException {
        Logger.log("message/DataRequest.java","Found " + searchKey + " replying",Logger.MINOR);
	Random r = new Random(); // used to create random starting depth, so it isn't obvious the reply was stored here
	DataReply drm=null;
	try {
	    drm=new DataReply(id, 
			      depth, 
			      (long)(Math.abs(r.nextInt() % 200)),
			      null,
			      data);
        } catch(Exception e) {
	    Logger.log("message/DataRequest.java","Error loading "+searchKey+" from DataStore: "+e,Logger.ERROR);
		return;
	}

	try {
	    n.sendMessage(drm, source);
	} catch(SendFailedException sfe) {
	    Logger.log("message/DataRequest.java","Error sending DataReply to " + sfe.peer,Logger.NORMAL) ;
	}
	throw new RequestAbortException(null); // My job is done. Abort and forget about this.
    }
}



/*
 *$Log: DataRequest.java,v $
 *Revision 1.21  2000/03/06 10:00:32  hobbex
 *Large change to the way Inserts are handled. The chain is now InsertRequest->InsertReply->DataInsert.
 *
 *Revision 1.20  2000/02/29 06:47:31  blanu
 *Fixed DataRequest not generating DataLength field in DataReply.
 *
 *Revision 1.19  2000/02/23 20:52:42  blanu
 *Fixed timeout in client.
 *
 *Revision 1.18  2000/02/20 03:22:39  blanu
 *Connections now timeout after connectTimeout milliseconds, as per the config file.
 *
 *Revision 1.17  2000/02/13 21:11:01  hobbex
 *removed searchKey field from DataReply
 *
 *Revision 1.16  2000/02/13 14:06:27  sanity
 *Changed so that timeouts always start with a timeout of 256 to ensure that
 *they reach their destination.
 *
 *Revision 1.15  2000/02/08 14:24:30  hobbex
 *Added timeout and restart on no reply functionality to requests
 *
 *Revision 1.14  2000/02/02 15:58:57  sanity
 *Changed Freenet client so that keys are now hashed!
 *
 *Revision 1.13  2000/01/31 13:22:50  hobbex
 *Changed the method for setting the DataSource in replies, and added a couple more get mthods to the connection
 *
 *Revision 1.12  2000/01/27 15:45:39  sanity
 *Some bug fixes, added localAddress field to Node.java which is used by
 *DataRequest and DataReply messages to set dataSource field.  Also removed
 *untidy debugging stuff from RawMessage.
 *
 *Revision 1.11  2000/01/27 10:01:11  sanity
 *Added "origin" field to DataReply which stores either the node where the
 *data originated, or a node closer to where the data originated.  This is
 *the functionality as described in the Freenet report.
 *
 *Revision 1.10  2000/01/27 00:52:34  hobbex
 *Added backtracking InsertFailed messages
 *
 *Revision 1.9  2000/01/19 15:12:21  hobbex
 *Fixed handeling of bad node addresses (SendFailedException)
 *
 *Revision 1.8  2000/01/11 01:01:46  hobbex
 *added Depth field to all messages for setting hopsToLive of replies
 *
 *Revision 1.7  2000/01/10 21:54:46  hobbex
 *Fixed timeout of Requests, all messages sent as a result of a Request now inherit the HTL of the original
 *
 *Revision 1.6  2000/01/09 18:46:41  hobbex
 *Fixed setting of source field on multihomed nodes - I hope
 *
 *Revision 1.5  2000/01/06 01:04:50  hobbex
 *Don't forward Inserts and Reuqests to self or source, don't accept inserts if key is known, and added an Address.equals method
 *
 *Revision 1.4  2000/01/03 10:20:48  hobbex
 *Removed deleting of MM on Loop and Failed Request
 *
 *Revision 1.3  2000/01/02 19:10:49  michaels
 *Reverted last change - has to be discussed first
 *
 *Revision 1.2  2000/01/02 14:30:04  michaels
 *On a loop pReceived returns sb not null - seems to work, don't know
 *about sideeffects
 *
 */




