package Freenet.message;

import Freenet.*;
import java.util.*;
import Freenet.support.Logger;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This is the superclass of all handshakes
 *
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 **/

public class HandshakeReply extends Handshake
{
  public String version;

  public HandshakeReply(long idnum)
    {
      super(idnum);
      version=Node.versionString;
    }

  public HandshakeReply(RawMessage raw) throws InvalidMessageException
  {
    super(raw);
    version=raw.readField("Version");
  }

  public RawMessage toRawMessage()
    {
      RawMessage r = super.toRawMessage();
      r.messageType="HandshakeReply";
      r.setField("Version", version);
      return r;
    }

  public boolean check()
  {
    return version.equals(Node.versionString);
  }

  public MessageMemory pReceived(Node n, MessageMemory sb)
  {
    if(check())
      Node.handshakes.put(source, new Date());
    else
      Logger.log("HandshakeReply.java","Bad handshake received",Logger.MINOR);
    return null;
  }
}


