/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This is the HandshakeRequest message
 *
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 **/

package Freenet.message;
import Freenet.*;
import java.util.*;
import Freenet.support.*;

public class HandshakeRequest extends Handshake
{
  public HandshakeRequest(long idnum) {super(idnum);}

  public HandshakeRequest(RawMessage raw) throws InvalidMessageException {super(raw);} 

  public MessageMemory pReceived(Node n, MessageMemory sb)
  {
        HandshakeReply shake = new HandshakeReply(id);
	try { n.sendMessage(shake, source); }
        catch(SendFailedException e) {Logger.log("HandshakeRequest.java","Could not send handshake reply",Logger.MINOR);}
	return null;
  }

  public RawMessage toRawMessage()
    {
      RawMessage r = super.toRawMessage();
      r.messageType="HandshakeRequest";
      return r;
    }
}
