package Freenet.message;
import Freenet.*;
import Freenet.support.Logger;
import java.io.*;

public class InsertReply extends Message {

    public InsertReply(long idnum, long htl) {
	super(idnum, htl, (long)0);
    }

    public InsertReply(RawMessage raw) throws InvalidMessageException {
	super(raw);
    }

    public RawMessage toRawMessage() {
	RawMessage raw=super.toRawMessage();
	raw.messageType="InsertReply";
	return raw;
    }

    public MessageMemory pReceived(Node n, MessageMemory sb) {
	if(sb==null || !(sb instanceof KeyedMM)) // No one requested this, or I forgot about it
	    return null;
	else { // Forward it to whoever requested insert.
	    KeyedMM kmm = (KeyedMM) sb;
	    Node.timer.cancel(id);

	    //data sent should now be sent back up the path of this message
	    kmm.dataref = source;

	    try {
		n.sendMessage(this, kmm.origRec);
	    } catch (SendFailedException sfe) {
		Logger.log("message/TimedOut.java","Send failed on return to " + sfe.peer,Logger.NORMAL);
		return null;
	    }

	    return kmm;
	}
    }
    
    protected MessageMemory timeOut(Node n, MessageMemory sb)
    {
	Logger.log("message/TimedOut.java","Errant InsertReply message died",Logger.NORMAL);
	return null;
    }
}
