
package Freenet.message;

import java.io.*;
import java.math.*;
import Freenet.*;
import Freenet.support.*;

public class InsertRequest extends Request {

  public InsertRequest(long idnum, long htl, long depth, Key key)
  {
      super(idnum, htl, depth, key);
  }

  public InsertRequest(RawMessage raw) throws InvalidMessageException
  {
      super(raw);
  }

  public RawMessage toRawMessage()
  {
    RawMessage raw=super.toRawMessage();
    raw.messageType="InsertRequest";
    return raw;
  }

    public static KeyedMM failedTimedOut(Node n, long id, KeyedMM kmm) {
	InsertReply ir = new InsertReply(id, kmm.depth);
	try {
	    n.sendMessage(ir,kmm.origRec);
	} catch(SendFailedException sfe) {
	    Logger.log("Message.java","Send of InsertReply message failed",Logger.NORMAL);
	}

	kmm.dataref=null; // messages stop here
	return kmm;
    }

    protected void refFound(Address ref, Node n) throws RequestAbortException {
	Logger.log("message/InsertRequest","Key collision, recieved InsertRequest for previously know key, requesting it's original data",Logger.MINOR);
	DataRequest dr = new DataRequest(id,hopsToLive,depth,searchKey);
	dr.source = source;
	throw new RequestAbortException(dr.pReceived(n,null)); // Handle this as request and return result
    }

    protected void dataFound(Data data, Node n) throws RequestAbortException {
	// do the same as ref (I could just return the data right here, but since situations like read failing are handled better by the DataRequest code anyways
	refFound(receivedAt, n);
    }

    protected MessageMemory timeOut(Node n, MessageMemory mm) {

	InsertReply ir = new InsertReply(id, depth);
	try {
	    n.sendMessage(ir,source);
	} catch(SendFailedException sfe) {
	    Logger.log("Message.java","Send of InsertReply message failed",Logger.NORMAL);
	}
	KeyedMM kmm;
	if (mm == null || !(mm instanceof KeyedMM))
	    kmm = new KeyedMM(source,depth,searchKey,null,this.getClass());
	else
	    kmm = (KeyedMM) mm;

	kmm.dataref=null; // messages stop here
	return kmm;
    }
}
