package Freenet.message;
import Freenet.*;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU General Public Licence (GPL) 
  version 2.  See http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This is the MessageMemory pertaining to messages that need to
 * remember the keys used.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public class KeyedMM extends MessageMemory
{
    // Public Fields
    Key searchKey, lastAttempt;  
    Class messageType;

    // this is the address that data is sent to, originally it is set back to the sender, but can be reset for Inserts for example
    Address dataref;
  
  // Constructor
  /**
   * @param origRec The address from which the DataRequest
   *                originated
   * @param searchKey The key being searched for
   * @param lastAttempt The key corresponding to the most
   *                    recent attempt to send a DataRequest
   *                    (used as a mask).
   **/
  public KeyedMM(Address origRec,
		   long depth,
		   Key searchKey,
		   Key lastAttempt,
		 Class messageType)
    {
      super(origRec,depth);
      this.dataref = origRec;
      this.searchKey = searchKey;
      this.lastAttempt = lastAttempt;
      this.messageType = messageType;
    }
}
