package Freenet.message;
import Freenet.*;
import Freenet.support.*;

public class QueryRestarted extends Message
{

    public QueryRestarted(RawMessage m) throws InvalidMessageException
    {
	super(m);
    }

    public QueryRestarted(long idnum, long htl)
    {
	super(idnum, htl, (long)0);
    }

    
    public RawMessage toRawMessage()
    {
	RawMessage raw=super.toRawMessage();
	raw.messageType="QueryRestarted";
	return raw;
    }


    public MessageMemory pReceived(Node n, MessageMemory sb)
    {
	if (sb==null) { // already lost mm
	    return null;
	} else {
	    Callback cb = Node.timer.cancel(id);
	    try {
		n.sendMessage(this, sb.origRec);

		if (!(cb instanceof RequestCB)) return sb; //WTF have you been shoving up my timer?!? :-)
		RequestCB rcb = (RequestCB) cb;
		Node.timer.add(id, rcb.hopsToLive * Node.timePerHop, rcb);

	    } catch (SendFailedException sfe) {
		Logger.log("message/QueryRestarted.java","Send failed on return to " + sfe.peer,Logger.NORMAL);
	    }
	    return sb;
	}
    }

    protected MessageMemory timeOut(Node n, MessageMemory sb)
    {
	Logger.log("message/QueryRestarted.java","Errant QueryRestarted message died",Logger.NORMAL);
	return null;
    }
}  
