
package Freenet.message;
import Freenet.*;
import Freenet.support.*;
import java.util.Random;

public abstract class Request extends Message {

  public Key searchKey;

  public Request(long idnum, long htl, long depth, Key key)
  {
    super(idnum, htl, depth);
    searchKey=key;
  }

  public Request(RawMessage raw) throws InvalidMessageException
  {
    super(raw);
    searchKey=new StringKey(raw.readField("SearchKey"));
    if(searchKey.toString()==null) throw new InvalidMessageException
			  ("Can't find SearchKey field");
  }

  public RawMessage toRawMessage()
  {
    RawMessage raw=super.toRawMessage();
    raw.setField("SearchKey", searchKey.toString());
    return raw;
  }

  /**
   * Called by a node after it receives this message
   * @param n The node that called this message.  This should be used
   *          to make any nescessary modifications to the DataStore etc.
   * @param sb Null unless this node has been seen before.  If non-null it
   *           is the Object returned by the received method of the
   *           last message seen with this ID.
   * @return The object to be passed to any messages received in the near
   *         future with the same ID as this one.  Null if no object should
   *         be passed.
   **/
  public MessageMemory pReceived(Node n, MessageMemory sb)
  {
    if(sb!=null) // Uh-oh! Must be a loop.
    {
        Logger.log("message/Request","loop - backtracking",Logger.MINOR);
	RequestFailed rf=new RequestFailed(id, hopsToLive);
	try {
	    n.sendMessage(rf, source);
	} catch(SendFailedException sfe) {
	    Logger.log("message/Request.java","Return to " + sfe.peer + " failed on loop",Logger.NORMAL);
	}
	return sb;
    }
    
    Data data;
    Address ref;

    if ((data=n.ds.searchData(searchKey))!=null) { // I have the data
	try {
	    dataFound(data, n);
	} catch (RequestAbortException rae) {
	    return rae.mm;
	}
    } else if ((ref=n.ds.searchRef(searchKey))!=null) { // Reference found
	try {
	    refFound(ref, n);
	} catch (RequestAbortException rae) {
	    return rae.mm;
	}
    }

  
    // Going on forward the query
    Logger.log("message/Request.java","Forwarding query for " + searchKey,Logger.MINOR);
    Address addr; boolean failed; 
    KeyedMM kmm=new KeyedMM(source, depth, searchKey, null, this.getClass());
    do { // until the send doesn't fail
	do { // until the reference isn't back
	    kmm.lastAttempt=n.ds.findClosestKey(searchKey,kmm.lastAttempt);
	    addr=n.ds.searchRef(kmm.lastAttempt);
	} while (addr != null && (addr.equals(source) || addr.equals(kmm.origRec)));

	if(kmm.lastAttempt==null) // Out of references
	    {
		Logger.log("message/Request.java","No more nodes to send " + id + " to, returning to " + kmm.origRec,Logger.MINOR);
		RequestFailed rf=new RequestFailed(id, hopsToLive);
		try {
		    n.sendMessage(rf, kmm.origRec);
		} catch(SendFailedException sfe) {
		    Logger.log("message/Request.java","Return to " + sfe.peer + " failed on no more references",Logger.NORMAL);
		}
		return kmm;
	    }

	failed = false;
	try {
	    Logger.log("message/Request.java","Forwarding query to " + addr,Logger.MINOR);
	    n.sendMessage(this, addr);
	} catch(SendFailedException sfe) {
	    failed = true;
	}
    } while (failed);

    // add a timer callback to time out on no reply
    Node.timer.add(id, hopsToLive * Node.timePerHop, new RequestCB(n, kmm, id, hopsToLive));

    return kmm;
  }

    /*
     * method should is called when RequestFailed times out. It should be 
     * overwritten to mirror the different timeout behaviour of
     * different requests
     */

    public static KeyedMM failedTimedOut(Node n, long id, KeyedMM kmm) {
	Logger.log("message/Request.java","right right right",Logger.DEBUGGING);
	TimedOut to=new TimedOut(id, kmm.depth);
    
	try {
	    n.sendMessage(to,kmm.origRec); // send to original sender, not source
	} catch(SendFailedException sfe) {
	    Logger.log("Request.java","Sending of timeout to Failed message failed",Logger.NORMAL);
	}
	return null;
    }

    //Private & Protected methods

    protected class RequestAbortException extends Exception {
	MessageMemory mm;
	public RequestAbortException(MessageMemory mm) {
	    this.mm = mm;
	}
    }


    /*
     * This method is called if a ref is found to the searchkey of the
     * the request. To abort the current request, throw a RequestAbortException
     * containing the MM to be returned.
     */
    protected abstract void refFound(Address ref, Node n) throws RequestAbortException;
    /*
     * This method is called if data is found to the searchkey of the
     * the request. To abort the current request, throw a RequestAbortException
     * containing the MM to be returned.
     */
    protected abstract void dataFound(Data data, Node n) throws RequestAbortException;
    
}

