package Freenet.message;
import Freenet.*;
import Freenet.support.*;

public class RequestCB implements Callback, Runnable
{
    protected Node n;
    protected long id;
    protected MessageMemory mm;
    protected long hopsToLive;

    public RequestCB(Node n, MessageMemory mm, long id, long hopsToLive)
    {
	this.n = n;
	this.mm = mm;
	this.id = id;
	this.hopsToLive = hopsToLive;
    }

    public void callback()
    {
	(new Thread(this)).start();
    }
    
    public void run()
    {
	// note that the if the send fails, the query won't be restarted, since if it can't send the notification, it probably won't be able to send the reply
	try {
	    Logger.log("message/RequestCB.java","Restarting message " + id + " on no reply.",Logger.DEBUGGING);
	    n.sendMessage(new QueryRestarted(id, mm.depth),mm.origRec);
	    n.timer.add(id, hopsToLive * Node.timePerHop, this); // HACK!, Failed needs to cancel a timer to reschedule it
	    RequestFailed rf = new RequestFailed(id, mm.depth);
	    n.mh.handle(rf); // handle like if a failed message were recieved
	} catch (SendFailedException sfe) {
	    Logger.log("message/RequestCB.java","Couldn't restart on timeout because send failed to " + sfe.peer, Logger.NORMAL);
	}

    }

}
