package Freenet.message;
import Freenet.*;
import Freenet.support.*;
import java.lang.reflect.*;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU General Public Licence (GPL) 
  version 2.  See http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This message is sent by a node which cannot locate a piece of data.
 * If received by a node, it should either forward it back to whichever
 * node sent the request to it, or should send another request to find
 * the data.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 * @author <A HREF="mailto:author2@email.addr">Author 2</A>
 **/

public class RequestFailed extends Message
{
  // Public Fields

  // Protected/Private Fields

  // Constructors

  public RequestFailed(RawMessage m) 
    throws InvalidMessageException
    {
      super(m);
    }

  public RequestFailed(long idnum, long htl)
    {
      super(idnum, htl, (long)0);
    }

  // Public Methods

  public RawMessage toRawMessage()
  {
    RawMessage raw=super.toRawMessage();
    raw.messageType="RequestFailed";
    return raw;
  }

  public MessageMemory pReceived(Node n, MessageMemory mm)
    {
      if (mm == null)
	{
	  // Ignore this message as we should never receive
	  // a RequestFailed that does not correspond
	  // to a DataRequest we previously forwarded.  We
	  // Must have forgotten the ID.
	  return null;
	}
      else if (!(mm instanceof KeyedMM))
	{
	    // Ignore this as this id clearly doesn't correspond
	    // to a DataRequest.
	    return null; // < Question: Would it be better to return
	               // the mm here?  I haven't as it may lead to
	               // an errant MM blocking loads of messages
	               // but being renued every time it did.
	}
      else
	  {
         KeyedMM kmm=(KeyedMM)mm;

	 // cancel any timer waiting for this message
	 Callback cb = Node.timer.cancel(id);
	 RequestCB rcb = null;
	 if (cb != null || cb instanceof RequestCB)
	     rcb = (RequestCB)cb;

	 // Construct the new message of the type of class stored in the MessageMemory
	 Request m = null;
	 try {
	     Class[] carr = {long.class,long.class,long.class,Key.class};
	     Constructor con = kmm.messageType.getConstructor(carr);
	     Object[] oarr = {new Long(id), new Long(hopsToLive), new Long(kmm.depth), kmm.searchKey};
	     Object o = con.newInstance(oarr);
	     if (!(o instanceof Request))
		 throw new Exception();
	     m = (Request) o;
	 } catch (Exception e) {
	     return null;
	 }
	 

	 Address addr; boolean failed;
	 do {
	     do {
		 kmm.lastAttempt=n.ds.findClosestKey(kmm.searchKey, kmm.lastAttempt);
		 addr = n.ds.searchRef(kmm.lastAttempt);
		 
	     } while (addr != null && (addr.equals(kmm.origRec)));


	     if(kmm.lastAttempt==null || m == null)
		 {
		     Logger.log("message/RequestFailed.java","Out of nodes or unable to consturct new message for " + id + ", returning Failed to " + mm.origRec,Logger.DEBUGGING);
		     try {
			 n.sendMessage(this, mm.origRec);
		     } catch(SendFailedException sfe) {
			 Logger.log("message/RequestFailed.java","Failed to return Failed message on out of references",Logger.NORMAL);
		     }

		     return kmm;
		 }

	     failed = false;
	     try {
		 n.sendMessage(m, addr);
	     } catch(SendFailedException sfe) {
		 failed = true;
	     }
	 } while (failed);
	 
	 if (rcb != null) {
	     Logger.log("message/RequestFailed.java","Re-scheduling the timeout",Logger.DEBUGGING);
	     rcb.hopsToLive = hopsToLive;
	     Node.timer.add(id, hopsToLive * Node.timePerHop, rcb);
	 }
	 return kmm;
       }
    }

  // Protected/Private Methods

    protected MessageMemory timeOut(Node n, MessageMemory sb)
    {
	if (sb == null || sb.depth <= 0 || !(sb instanceof KeyedMM))
	    return null;

	KeyedMM kmm = (KeyedMM) sb;
	try {
	    // This exectues the static "failedTimedOut" method of the kind of Request Message this responded to
	    Class[] carr = {Node.class,long.class,KeyedMM.class};
	    Method m = kmm.messageType.getMethod("failedTimedOut",carr);
	    Object[] oarr = {n,new Long(id),kmm};
	    Object o = m.invoke(null,oarr);
	    kmm = (KeyedMM) o;
	} catch (NoSuchMethodException e) {
	    Logger.log("RequestFailed.java","Error in Request message class " + kmm.messageType,Logger.ERROR); 
	} catch (ClassCastException e) {
	    Logger.log("RequestFailed.java","Error in Request message class " + kmm.messageType,Logger.ERROR); 
	} finally {
	    return kmm;
	}
    }
}


