package Freenet.message;
import Freenet.*;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU General Public Licence (GPL) 
  version 2.  See http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This is the MessageMemory pertaining to a DataRequest/DataReply/
 * RequestFailed series of messages.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public class RequestMM extends MessageMemory
{
  // Public Fields
  Key searchKey, lastAttempt;  
  
  // Constructor
  /**
   * @param origRec The address from which the DataRequest
   *                originated
   * @param searchKey The key being searched for
   * @param lastAttempt The key corresponding to the most
   *                    recent attempt to send a DataRequest
   *                    (used as a mask).
   **/
  public RequestMM(Address origRec,
		   long depth,
		   Key searchKey,
		   Key lastAttempt)
    {
      super(origRec,depth);
      this.searchKey = searchKey;
      this.lastAttempt = lastAttempt;
    }
}
