#!/bin/sh
# check for java version 1.1
if java -version 2>&1 | grep -q '1\.1'; then
    cat <<EOF
Note: Your Java 1.1 compiler will flag the PrintStream class in
support/Logger.java as deprecated.  Please ignore this warning -- the
class has been reinstated in Java 1.2.

EOF
fi

# do it
echo -n "Building Freenet server... "
export CLASSPATH=$CLASSPATH:$(pwd)/../..
cd ..
 (javac *.java support/*.java message/*.java crypt/*.java) && \
 echo "Done" && \
 echo -n "Building Freenet command-line client... " && \
 (javac client/InsertClient.java client/RequestClient.java) && \
 echo "Done"
