#!/bin/sh
#
# install.sh - install Freenet
#


# display banner intro
cat <<-EOF

	Freenet installation
	
	WARNING: You are about to install an 'Alpha' quality release of
	Freenet.  This means that we *know* there are many bugs in it but we
	need you to test Freenet to let us know what they are.  Freenet is
	being updated daily so it is recommended that you regularly download
	and install a new snapshot.  You should not be surprised if Freenet
	doesn't compile, or doesn't run -- but if this happens please email
	freenet-dev@lists.sourceforge.net to let the development team know
	that there is a problem.
	
	This script will install the Freenet server and Java client.
EOF


# check that Freenet was built already
echo -n "checking for compiled Node.class... "
if test ! -e ../Node.class; then
    echo "no"
    echo "Please run the ./build.sh script first."
    echo ""
    exit
fi
echo "yes"


# check for java runtime
echo -n "checking for java runtime... "
javaloc=`which java`
if test $? = 0; then
    echo "$javaloc"
else
    echo "no"
    echo "Please download a Java Development Kit (try http://java.sun.com)"
    echo ""
    exit
fi


# check java version
echo -n "checking java version is 1.1 or 1.2... "
if ! java -version 2>&1 | tee /dev/tty | grep -Eq '1\.1|1\.2'; then
    echo ""
    echo "Freenet requires java compatible with Sun's 1.1 or 1.2 API"
    echo -n "I can't tell if yours qualifies.  Continue anyway [y/N]? "
    read bsh
    if test "$bsh" != "y"; then
	echo "Please download Java 1.2 (try http://java.sun.com)"
	exit
    fi
fi
echo ""


# are we running as root?
if test "$(whoami)" != "root"; then
    root="no"
else
    root="yes"
fi


# get install path
if test "$root" = "yes"; then
    PREFIX="/usr/local"
else
    PREFIX="$HOME"
    echo "Make sure to specify a path where you have write permission."
fi
echo -n "Where do you want to install Freenet [$PREFIX/freenet]? "
read foo
if test -n "$foo"; then
    INSTALLDIR="$foo"
else
    INSTALLDIR="$PREFIX/freenet"
fi


# get local executable path and check permissions
echo -n "Should I make symbolic links to the Freenet scripts in $PREFIX/bin [Y/n]? "
read foo
if test "$foo" != "n"; then
    BINDIR="$PREFIX/bin"
    if test ! -w "$BINDIR"; then
	echo "$BINDIR is not writable!"
	exit
    fi
else
    BINDIR=""
    echo "ok, $INSTALLDIR/bin must be in the PATH environment variable"
    echo "of all users who will run the Freenet server"
fi


# Copy class files
echo "Creating $INSTALLDIR and copying files..."
install -d -m 0755 $INSTALLDIR
install -m 0644 sample.freenetrc $INSTALLDIR/.freenetrc
cd ..
echo "Creating $INSTALLDIR/Freenet"
install -d -m 0755 $INSTALLDIR/Freenet
install -m 0644 *.class $INSTALLDIR/Freenet
for dir in message support crypt client; do
    echo "Creating $INSTALLDIR/Freenet/$dir"
    install -d -m 0755 $INSTALLDIR/Freenet/$dir
    install -m 0644 $dir/*.class $INSTALLDIR/Freenet/$dir
done


# create server invocation script
echo "Creating $INSTALLDIR/bin"
install -d -m 0755 $INSTALLDIR/bin
echo "Creating $INSTALLDIR/bin/freenet_server executable"
cat <<-EOF > $INSTALLDIR/bin/freenet_server
	#!/bin/sh
	# freenet_server - wrapper for the Freenet server

	cd $INSTALLDIR
	echo "Starting Freenet server"
	export CLASSPATH="${INSTALLDIR}:\${CLASSPATH}"
	java Freenet.Node -logging error -logFile $INSTALLDIR/log.txt
	echo -n "Unregistering from inform.php... "
	if (echo "GET http://freenet.sourceforge.net/inform.php HTTP/1.0"; \\
echo ""; sleep 5) | telnet freenet.sourceforge.net 80 2>&1 | grep '^HTTP' | \\
tee /dev/tty | grep -q '^HTTP/.* 200'
	then
	    echo "done"
	else
	    echo "failed"
	fi
EOF
chmod 755 $INSTALLDIR/bin/freenet_server


# create client invocation script
echo "Creating $INSTALLDIR/bin/freenet_client executable"
cat <<-EOF > $INSTALLDIR/bin/freenet_client
	#!/bin/sh
	# freenet_client - wrapper for the Freenet java client

	# check arguments
	case "\$1" in
	insert)
	    CLASS="InsertClient"
	    ;;
	request)
	    CLASS="RequestClient"
	    ;;
	*)
	    echo "Usage: freenet_client [insert|request] args"
	    exit
	    ;;
	esac

	# do it
	shift
	export CLASSPATH="${INSTALLDIR}:\${CLASSPATH}"
	echo "java Freenet.client.\${CLASS} \$*"
	java Freenet.client.\${CLASS} \$*
EOF
chmod 755 $INSTALLDIR/bin/freenet_client


# make symlinks
if test -n "$BINDIR"; then
    echo "Making symlinks in $BINDIR"
    ln -sf $INSTALLDIR/bin/freenet_server $BINDIR/freenet_server
    ln -sf $INSTALLDIR/bin/freenet_client $BINDIR/freenet_client
fi


# done
cat <<-EOF

	Installation done.  Type 'freenet_server' to start the server, or
	'nohup freenet_server &' to start the server in the background.  Check
	log.txt in $INSTALLDIR for any error messages once the server is running.

EOF


