package Freenet.support;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
		
  Requires Classes: Class (version)
                    Class (version)
                    ...
 */

/**
 * This class represents a simple binary search tree.
 *
 * @version 1.0
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public class BinaryTree
{
  public String toString()
    {
      return tree.toString();
    }

  public Branch tree = null;
  protected int size = 0;

  public void put(long key, Object value)
    {
      size++;
      if (tree == null)
	{
	  tree = new Branch(key, value, null);
	}
      else
	{
	  tree.put(key, value);
	}
    }

  public void delete(long key)
    {
      Branch x,y,z;
      z=tree.get(key);
      if ((z.left == null) || (z.right == null))
	y=z;
      else
	y=z.successor();
      if (y.left != null)
	x = y.left;
      else
	x = y.right;
      if (x != null)
	x.parent = y.parent;
      if (y.parent == null)
	tree = x;
      else
	if (y == y.parent.left)
	  y.parent.left = x;
	else
	  y.parent.right = x;
      if (y != z)
	{
	  z.key = y.key;
	  z.value = y.value;
	}
    }
  
  public Object get(long key)
    {
      if (tree == null)
	return null;
      else
	{
	  Branch r = tree.get(key);
	  if (r == null)
	    return null;
	  else
	    return r.value;
	}
    }
}

class Branch
{
  public Branch left = null;
  public Branch right = null;
  public Branch parent;
  public long key;
  public Object value;

  public Branch(long key, Object value, Branch parent)
    {
      this.key = key;
      this.value = value;
      this.parent = parent;
    }

  public String toString()
    {
      return "(Key:"+key+" Left:"+left+" Right:"+right+")";
    }

  public void put (long key, Object value)
    {
      if (key<this.key)
	{
	  if (left == null)
	    {
	      left=new Branch(key,value,this);
	    }	 
	  else
	    left.put(key, value);
	}
      else
	{
	  if (right == null)
	    right=new Branch(key, value, this);
	  else
	    right.put(key, value);
	}
    }

  public Branch get(long key)
    {
      if (this.key == key)
	return this;
      else
	{
	  if (key < this.key)
	    {
	      if (left == null)
		return null;
	      else
		return left.get(key);
	    }
	  else
	    {
	      if (right == null)
		return null;
	      else
		return right.get(key);
	    }
	}
    }

  public Branch successor()
    {
      if (right != null)
	return right.minimum();
      else
	{
	  Branch y = this;
	  while((y != null) && (y.parent.left != this))
	    {
	      y = y.parent;
	    }
	  if (y == null)
	    return null;
	  else
	    return y.parent;
	}
    }

  public Branch minimum()
    {
      if (left == null)
	return this;
      else
	return left.minimum();
    }
}





