package Freenet.support;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
		
  Requires Classes: Class (version)
                    Class (version)
                    ...
 */

/**
 * This class represents a binary tree of limited size which uses integers
 * as keys.  If the tree is full and a new value is added, then the oldest
 * value is removed.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public class LimitedBinaryTree extends BinaryTree
{
  protected CyclicArray ca;

  public LimitedBinaryTree(int size)
    {
      super();
      ca = new CyclicArray(size);
    }

  public void put(long key, Object data)
    {
      Long prev = (Long) ca.put(new Long(key));
      if (prev != null)
	{
	  super.delete(prev.longValue());
	}   
      super.put(key, data);
    }

  public void delete(long key)
    {
      for(int x=0; x<ca.length(); x++)
	{
          Long l=(Long)ca.get(x);
          if(l!=null)
	    if (l.intValue() == key)
	    {
	      ca.remove(x);
	    }
	}
      super.delete(key);
    }
}

