package Freenet.support;
import java.io.*;
import java.util.*;
import java.text.*;

public class Logger
{
  /** The stream to which the log should be sent **/
    public static PrintStream Lout = System.err;
  /** The minimum priority message that will be printed to Lout, one
    * of Logger.ERROR, Logger.NORMAL, Logger.MINOR, or Logger.DEBUGGING **/
 
  /** This message indicates an error which prevents correct functionality **/
  public static int ERROR = 3;
  /** A normal level occurance **/
  public static int NORMAL = 2;
  /** A minor occurance that wouldn't normally be of interest **/
  public static int MINOR = 1;
  /** An occurance which would only be of interest during debugging **/
  public static int DEBUGGING = 0;
  public static int DEBUG = DEBUGGING;

  public static int threshold = DEBUGGING;
  public static int verbosity=5;
 
    private static DateFormat df = DateFormat.getDateTimeInstance();
  
  /**
   * Log a message
   * @param filename The name of the source file where this message was
   *                 generated
   * @param message A clear and verbose message describing the event
   * @param priority The priority of the mesage, one of Logger.ERROR,
   *                 Logger.NORMAL, Logger.MINOR, or Logger.DEBUGGING.
   **/
  public static void log(String filename, String message, int priority)
  { 
    // At a later date this could be enhanced with a hack employing
    // the exception traceback mechanism to give details of line number
    // and class automatically
      if (priority >= threshold)
	  {
	      String pri = "";
	      if (priority == ERROR)
		  pri = "Error";
	      if (priority == NORMAL)
		  pri = "Normal";
	      if (priority == MINOR)
		  pri = "Minor";
	      if (priority == DEBUGGING)
		  pri = "Debug";
              String str="";
              if(verbosity>2)
                str+=df.format(new Date())+":";
              if(verbosity>0)
                str+=filename+":";
              if(verbosity>1)
                str+=pri+":";
              str+=message;
	      Lout.println(str);
	  }
  }

    public static void logto(String filename) throws IOException {
	Lout = new PrintStream(new FileOutputStream(filename, true));
    }
}
