package Freenet.support;

import java.io.*;
import java.util.*;

public class SplitOutputStream extends OutputStream implements Callback
{
    private Vector outputs;

    public SplitOutputStream()
    {
	outputs = new Vector();
    }

    public void addOutput(OutputStream out)
    {
	addOutput(out, null);
    }

    public void addOutput(OutputStream out, Callback cb)
    {
	outputs.addElement(new StreamElement(out, cb));
    }

    public void write(int c)
    {
	int len, x;
	StreamElement current;
	Writer cw;
	
	len=outputs.size();
	x=0;
	while(x<len) {
	    current=(StreamElement)outputs.elementAt(x);
	    try {
		if (current.out!=null) 
		    current.out.write(c); 
		x++;
	    }
	    catch(IOException e) { 
		current.cb.callback();
		outputs.removeElementAt(x); 
		len--;
	    }
	}
    }


    public void close() 
    {
	for (Enumeration e = outputs.elements() ; e.hasMoreElements() ; ) {
	    ((StreamElement)e.nextElement()).close();
	}
	
	outputs.removeAllElements();

    }    

    /**
     * When callback is called, the connections are closed and their
     * respective callbacks are called.
     **/

    public void callback()
    {
	close();
    }
}

class StreamElement
{
    public OutputStream out;
    public Callback cb;
    
    public StreamElement(OutputStream out, Callback cb) {
	this.out = out;
	this.cb = cb;
    }

    public void close()
    {
	try {
	    if (out!=null) out.close();
	} catch (IOException e) {}
	if (cb!=null) cb.callback();
    }
}
