package Freenet.support;
import Freenet.*;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
		
  Requires Classes: Class (version)
                    Class (version)
                    ...
 */

/**
 * An implementation of the Key interface for Strings
 *
 * @version 1.0
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/


public class StringKey implements Key
{
  String value;
  public StringKey (String value)
    {
      this.value = value;
    }

  public int hashCode()
  {
    return value.hashCode();
  }

  public char charAt(int p)
  	{
		if (p<this.value.length())
			return this.value.charAt(p);
		else
			return (char) 0;
	}
  
  public boolean equals(Object t)
    {
		 if (t instanceof StringKey)
		  {
			  return ((StringKey) t).value.equals(this.value);
		  }
		 else
		 	return false;
    }

  public boolean compare(Key kk1, Key kk2) throws KeyException
    {
      if (!(kk1 instanceof StringKey) ||
	  !(kk2 instanceof StringKey))
	throw new KeyException("Trying to compare non-StringKey to StringKey");
      StringKey k1 = (StringKey) kk1;
      StringKey k2 = (StringKey) kk2;
		for (int x=0; true; x++)
		{
			if ((x>this.value.length()) &&
			    (x>k1.value.length()) &&
				 (x>k2.value.length()))
				 return false;
			int cc = charComp(this.charAt(x), k1.charAt(x),
										k2.charAt(x));
			if (cc == 1)
				return true;
			else if (cc == -1)
				return false;
		}
    }
  
  private int charComp(char c, char c1, char c2)
    {
      if ((Math.abs(Character.getNumericValue(c) - 
		    Character.getNumericValue(c1))) <
	  (Math.abs(Character.getNumericValue(c) - 
		    Character.getNumericValue(c2))))
	// If c1 is closer than c2 return 1 
	return 1;
      else if ((Math.abs(Character.getNumericValue(c) - 
			 Character.getNumericValue(c1))) ==
	       (Math.abs(Character.getNumericValue(c) - 
			 Character.getNumericValue(c2))))
	// If the distance is equal return 0
	return 0;
      else
	// else return -1
	return -1;
    }

  public String toString()
    {
      return value;
    }
}







