package Freenet.support;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU General Public Licence (GPL) 
  version 2.  See http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This class allows a callback to be called after a specified
 * amount of time.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public class Ticker extends Thread
{
  public static void main(String[] args)
    {
      Ticker t = new Ticker();
      t.start();
      for (int x=0; x<10; x++)
	{
	  t.add((long) x, (long) (x*1000+100), new testCB(x+" seconds"));
	}
    }
  
  // Protected/Private Fields
  TLL tll = null;
  long ticker;

  // Constructors
  public Ticker()
    {
      this((long) 100);
    }

  /**
   * @param ticker The time to wait (in milliseconds) between 
   *               testing whether a callback should be called.
   **/
  public Ticker(long ticker)
    {
      super();
      this.ticker = ticker;
    }

  // Public Methods

  /**
   * Adds a callback
   * @param id The ID to use if we want to cancel this callback
   * @param time The time to wait (in milliseconds) before calling
   *             this callback
   * @param cb The callback to call
   **/
  
  public void add(long id, long time, Callback cb)
    {
      if (!isAlive()) this.start();

      time += System.currentTimeMillis();

      if (tll == null)
	{
	  tll = new TLL(null, id, cb, time); 
	}
      else
	{
	  TLL t = tll;
	  while(true)
	    {
	      if ((t.next == null) || (t.next.time > time))
		{
		  TLL tmp = t.next;
		  t.next = new TLL(tmp, id, cb, time);
		  return;
		} else {
		    t = t.next;
		}
	    }
	}
    }

  /**
   * Cancels a callback
   * @param id The id of the callback to be cancelled
   * @return Returns the callback if a callback with the specified
   *         id was still pending, else null.
   **/
  public Callback cancel(long id)
    {
      if (tll == null) return null;
      if (tll.id == id)
	{
	  Callback cb = tll.cb;
	  tll = tll.next;
	  return cb;
	}
      else
	{
	  TLL t = tll;
	  while (t.next != null)
	    {
	      if (t.next.id == id)
		{
		  Callback cb = tll.next.cb;
		  t.next = t.next.next;
		  return cb;
		}
	      else {
		  t = t.next;
	      }
	    }
	  return null;
	}
    }

  public void run()
    {
      Logger.log("support/Ticker.java","Thread started",Logger.NORMAL);
      while(true)
	{
	  while (tll != null && tll.time < System.currentTimeMillis())
	    {
	      tll.cb.callback();
	      tll = tll.next;
	    }
	  try
	    {
	      sleep(ticker);
	    }
	  catch (InterruptedException e)
	    {
	    }
	}
    }

  // Protected/Private Methods
}

class testCB implements Callback
{
  String p;
  public testCB(String print)
    {
      p = print;
    }

  public void callback()
    {
      System.out.println(p);
    }
}

class TLL
{
  public TLL next;
  public long id;
  public Callback cb;
  public long time;
  public TLL(TLL next, long id, Callback cb, long time)
    {
      this.next = next;
      this.id = id;
      this.cb = cb;
      this.time = time;
    }
}
