package Freenet;

import java.net.*;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
                
  Requires Classes: ProtocolAddress

 */

/**
 * A class representing the address of an Adaptive Network client in the
 * network which uses the TCP/IP protocol.
 * @author <A HREF="mailto:blanu@uts.cc.utexas.edu">Brandon Wiley</A>
 **/

public class tcpAddress extends ProtocolAddress
{
  /** The IP address of the computer on which the client resides **/
  public InetAddress host;
  /** The port number that the client is listening to **/
  public int port;

  public tcpAddress(InetAddress i, int portnum)
    {
      host = i;
      port = portnum;
    }

  public tcpAddress(String ip, int portnum)
    throws UnknownHostException
    {
      host = InetAddress.getByName(ip);
      port = portnum;
    }

  /** Creates an address from a string in the format "a.b.c.d:p" **/
  public tcpAddress(String str) 
    throws IllegalArgumentException, UnknownHostException
    {
      int i=str.indexOf(':');
      if(i==-1) throw new IllegalArgumentException();
      host=InetAddress.getByName(str.substring(0,i));
      port=new Integer(str.substring(i+1)).intValue();
    }

    public ProtocolListeningAddress listenPart() 
    {
	return new tcpListeningAddress(port);
    }

  public String toString()
    {
      String str=host.getHostAddress();
      return str+":"+port;
    }

  public boolean equals(Object o)
    {
      return ((o instanceof tcpAddress) &&
              (((tcpAddress) o).host.equals(host)) &&
              (((tcpAddress) o).port == port));
    }
}
