package Freenet;

import java.io.*;
import java.net.*;

public class tcpConnection extends Connection
{
  protected Socket sock=null;

  private class ConnectThread extends Thread
  { 
    private tcpAddress tcpaddr;
    public ConnectThread(tcpAddress addr)
    {
      super();
      tcpaddr=addr;
    }

    public void run()
    { 
      try { sock=new Socket(tcpaddr.host, tcpaddr.port); }
      catch(IOException e) { sock = null; }
    }
  }

  public String toString()
  {
    return getMyAddress().toString();
  }

  private class WaitThread extends Thread
  { 
    public void run()
    { 
      try { sleep(Node.connectTimeout); } catch(InterruptedException e) {}
    } 
  }

  public tcpConnection(tcpAddress addr) throws UnknownHostException,
      IOException, ConnectTimedOutException
  {
      Thread st = new ConnectThread(addr); st.start();
      Thread wt = new WaitThread(); wt.start();
      while(st.isAlive() && wt.isAlive())
      { 
        try { Thread.currentThread().sleep(10); }
        catch(InterruptedException e) {}
      }
      if(sock==null) throw new ConnectTimedOutException();
      in=sock.getInputStream();
      out=sock.getOutputStream();
      wt.interrupt();
  }

  public tcpConnection(Socket sock) throws IOException
    {
      this.sock = sock;
      in=sock.getInputStream();
      out=sock.getOutputStream();
    }

  public void close()
  {
    try { 
      in.close();
      in=null;
      out.close();
      out=null;
      sock.close(); 
    }
    catch(Exception e) 
      {
	// It may have been closed remotely in which case
	// sock.close will throw an exception.  We really don't
	// care though.
      }
  }
    
    public Address getMyAddress(ListeningAddress lstaddr)
    {
	return (sock == null)? null : 
	    new Address("tcp",
			new tcpAddress(sock.getLocalAddress(),
				       ((tcpListeningAddress)lstaddr.address).port));
    }

    public Address getMyAddress()
    {
	return (sock == null)? null :
	    new Address("tcp",
			new tcpAddress(sock.getLocalAddress(),
				       (short)sock.getLocalPort()));
    }
    public Address getPeerAddress(ListeningAddress lstaddr)
    {
	return (sock == null)? null :
	    new Address("tcp",
			new tcpAddress(sock.getInetAddress(),
				       ((tcpListeningAddress)lstaddr.address).port));
    }
    public Address getPeerAddress()
    {
	return (sock == null)? null : 
	    new Address("tcp",
			new tcpAddress(sock.getInetAddress(),
				       (short)sock.getPort()));
    }
}
