<?php

function dbQ($sql, $err_file, $err_line)
{
	global $db_link;
	$result = mysqli_query($db_link, $sql);
	if (!$result)
	{
		sql_error($sql, $err_file, $err_line);
	}
	return($result);
}

function dbRow($result)
{
	if ($result)
	{
		return(mysqli_fetch_row($result));
	}
	else
	{
		return(false);
	}
}

function dbAssoc($result)
{
	if ($result)
	{
		return(mysqli_fetch_assoc($result));
	}
	else
	{
		return(false);
	}
}

function dbNumRows($result)
{
	if ($result)
	{
		return(mysqli_num_rows($result));
	}
	else
	{
		return(false);
	}
}

function dbInsertID()
{
	global $db_link;
	return(mysqli_insert_id($db_link));
}

function dbEsc($s)
{
	global $db_link;
	return(mysqli_real_escape_string($db_link, $s));
}

function dbUpd($table, $data, $id, $err_file = '', $err_line = '')
{
	if (sizeof($data) > 0)
	{
		$set_data = array();
		foreach ($data as $key => $value)
		{
			$set_data[] = '`'.dbEsc($key).'`='."'".dbEsc($value)."'";
		}
		$sql = "UPDATE ".$table." SET ".implode(', ', $set_data)." WHERE id=".intval($id)." LIMIT 1";
		dbQ($sql, $err_file, $err_line);
		return(true);
	}
	else
	{
		return(false);
	}
}

function dbUpdCond($table, $data, $cond, $err_file = '', $err_line = '')
{
	if (sizeof($data) > 0)
	{
		$set_data = array();
		foreach ($data as $key => $value)
		{
			$set_data[] = '`'.dbEsc($key).'`='."'".dbEsc($value)."'";
		}
		$sql = "UPDATE ".$table." SET ".implode(', ', $set_data)." WHERE ".$cond." LIMIT 1";
		dbQ($sql, $err_file, $err_line);
		return(true);
	}
	else
	{
		return(false);
	}
}

function dbInsert($table, $params, $err_file = '', $err_line = '')
{
	$keys_params = array();
	$vals_params = array();
	foreach ($params as $key => $val) {
		$keys_params[] = $key;
		$vals_params[] = "'".dbEsc($val)."'";
	}

	$sql = "INSERT INTO ".$table." (".implode(', ', $keys_params).") VALUES (".implode(', ', $vals_params).")"; 
	dbQ($sql, $err_file, $err_line);
	$id = dbInsertID();

	return($id);
}

function dbGetRow($table, $id, $err_file = '', $err_line = '')
{
	$sql = "SELECT * FROM ".$table." WHERE id=".intval($id)." LIMIT 1";
	return(dbAssoc(dbQ($sql, $err_file, $err_line)));
}

function dbGetRowCond($table, $cond, $err_file = '', $err_line = '')
{
	$sql = "SELECT * FROM ".$table." WHERE ".$cond." LIMIT 1";
	return(dbAssoc(dbQ($sql, $err_file, $err_line)));
}

function dbCount($table, $cond = '', $err_file = '', $err_line = '')
{
	if ($cond == '')
	{
		$sql = "SELECT COUNT(*) FROM ".$table;
	}
	else {
		$sql = "SELECT COUNT(*) FROM ".$table." WHERE ".$cond;		
	}
	$result = dbQ($sql, $err_file, $err_line);
	list($count) = dbRow($result);
	return($count);
}

function dbIsRow($table, $id, $err_file = '', $err_line = '')
{
	$sql = "SELECT id FROM ".$table." WHERE id=".intval($id)." LIMIT 1";
	$result = dbQ($sql, $err_file, $err_line);
	if (dbNumRows($result) > 0)
	{
		return(true);
	}
	else {
		return(false);
	}
}

function dbIsRowCond($table, $cond, $err_file = '', $err_line = '')
{
	$sql = "SELECT id FROM ".$table." WHERE ".$cond." LIMIT 1";
	$result = dbQ($sql, $err_file, $err_line);
	if (dbNumRows($result) > 0)
	{
		return(true);
	}
	else
	{
		return(false);
	}
}

function dbDel($table, $id, $err_file = '', $err_line = '')
{
	$sql = "DELETE FROM ".$table." WHERE id=".intval($id)." LIMIT 1";
	dbQ($sql, $err_file, $err_line);
}

function dbDelCond($table, $cond, $err_file = '', $err_line = '')
{
	$sql = "DELETE FROM ".$table." WHERE ".$cond;
	dbQ($sql, $err_file, $err_line);
}

function dbClose()
{
	global $db_link;
	mysqli_close($db_link);
}

?>