<?php

function error_handler($err_no, $err_str, $err_file, $err_line)
{
	if (DEBUG)
	{
		print '<br /><b>'.$err_str.'</b><br />'.$err_file.' ['.$err_line.']<br /><br />';
	}
	if (DEBUG_LOG)
	{
		$log = array();
		$log[] = date('H:i:s d.m.Y');
		$log[] = '['.$err_no.']';
		$log[] = $err_str;
		$log[] = $err_file;
		$log[] = '['.$err_line.']';
		$log[] = 'PHP '.PHP_VERSION.' ('.PHP_OS.')';
		$log[] = $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
		$log[] = $_SERVER['REMOTE_ADDR'];
		$err_str = implode(" ", $log)."\n\n";
		error_log($err_str, 3, ROOT_PATH.'logs/error.log');
	}
}


function sql_error($query, $err_file, $err_line)
{
	if (DEBUG || DEBUG_LOG)
	{
		global $db_link;
		$log_vals = array();
		$log_vals['ERROR'] = mysqli_error($db_link);
		$log_vals['CODE'] = mysqli_errno($db_link);
		$log_vals['QUERY'] = $query;
		$log_vals['FILE'] = $err_file;
		$log_vals['LINE'] = $err_line;
		$log_vals['TIME'] = date('H:i:s d.m.Y');
	}

	if (DEBUG_LOG)
	{
		$log = '';
		foreach($log_vals as $key=>$val)
		{
			$log .= $key.': '.$val."\n";
		}
		$log .= "\n";
		error_log($log, 3, ROOT_PATH.'logs/mysql.log');
	}
	
	if (DEBUG)
	{
		$debug_text = '';
		foreach($log_vals as $key=>$val)
		{
			$debug_text .= $key.': <b>'.$val.'</b><br />';
		}
		die($debug_text.'<br />');
	}
	else
	{
		die('<b>ERROR: database error!</b>');
	}
}

?>