#include "includes.h"

#ifndef _DEBUGOUT_FUNC
#define _DEBUGOUT_FUNC
#define DEBUG_MAX_BUFFER_SIZE	0x10000 // 40KB
#pragma warning(disable : 4024) // 'HeapValidate' : different types for formal and actual parameter 2
#pragma warning(disable : 4047) // 'function' : 'DWORD' differs in levels of indirection from 'void *'

void DebugOut(PCHAR szPrefix, PCHAR szFormat, ...)
{
	va_list args;
	
	//PCHAR szOutputString;
	//if ( !(szOutputString = (PCHAR)malloc(DEBUG_MAX_BUFFER_SIZE)) )
	//	return;
	//ZeroMemory(szOutputString, DEBUG_MAX_BUFFER_SIZE);
	CHAR szOutputString[DEBUG_MAX_BUFFER_SIZE] = {0};
	
	int nSizeTmp = 0;
	if (szPrefix && strlen(szPrefix)) { // !
		nSizeTmp += _snprintf(szOutputString, DEBUG_MAX_BUFFER_SIZE - 2, szPrefix, GetCurrentThreadId(), GetLastError());
	}

	va_start(args, szFormat);
	nSizeTmp += _vsnprintf(szOutputString + nSizeTmp, (DEBUG_MAX_BUFFER_SIZE - 2) - nSizeTmp, szFormat, args);
	strcpy(szOutputString + nSizeTmp, "\n");
	va_end(args);

	OutputDebugString(szOutputString);
	//free(szOutputString);
}

#endif