#include "includes.h"

#ifndef _DEBUGMEM_FUNC
#define _DEBUGMEM_FUNC

#ifndef NDEBUG

// 
// http://forum.antichat.ru/thread37379.html
// 

#define STATUS_ACCESS_VIOLATION          ((NTSTATUS)0xC0000005L)    // winnt

#define OVERFLOW_GUARD   1

#define BUFFER_GUARD OVERFLOW_GUARD

#define ALLOC_SIZE 10000

struct __allocation {
	void* mem;
	int len;
	char guard_type;
} __allocs [ALLOC_SIZE];

void DebugMessage(char* s, ...);

// exception handler
LONG __stdcall MyUnhandledExceptionFilter(EXCEPTION_POINTERS* ep)
{
	if( ep->ExceptionRecord->ExceptionCode == STATUS_ACCESS_VIOLATION )
	{
		for( int i=0; i<sizeof(__allocs)/sizeof(*__allocs); i++ )
		{
			long addr = ep->ExceptionRecord->ExceptionInformation[1];
			long dist;

			if( 
				(addr >= (long)__allocs[i].mem + __allocs[i].len) &&
				(addr <= (long)__allocs[i].mem + __allocs[i].len + 10) &&
				__allocs[i].guard_type == OVERFLOW_GUARD
				)
			{
				dist = addr - (long)__allocs[i].mem - __allocs[i].len + 1;
				DebugMessage(
					"Buffer overflow detected!\n"
					"Buffer starts at 0x%08x\n"
					"Buffer size is %d byte(s) [0x%x]\n"
					"Memory referenced: 0x%08x\n"
					"Distance between end of buffer: %d byte(s) [0x%x]\n"
					"%s"
					,
					__allocs[i].mem,
					__allocs[i].len,
					__allocs[i].len,
					addr,
					dist,
					dist,
					(dist==1) ?
						"\nDistance equals to one byte.\n"
						"It's very common case of overflow called one-byte buffer oveflow.\n"
						"Possible it is a result of string allocation error (maybe you've forgotten to allocate space for terminating NULL-character?)"
						: ""
					);
			}
		}
	}
	return EXCEPTION_CONTINUE_SEARCH;
		
}

// Show debug message
void DebugMessage(char* s, ...)
{
	char t[ 1024 ];
	va_list va;
	va_start( va, s );
	vsprintf( t, s, va );

	char msg[ 1024 ];
	sprintf(msg,
		"Memory Debugging Message:\n"
		"\n"
		"%s\n"
		"\n"
		"If you want to abort execution press 'Abort'\n"
		"If you want to debug application press 'Retry'\n"
		"If you want to continue execution press 'Ignore'\n"
		,
		t
		);

	OutputDebugString( msg );

	switch( MessageBox( NULL, msg, "Memory Debugging Message", MB_ABORTRETRYIGNORE|MB_ICONERROR ) )
	{
	case IDRETRY:
		__asm	int 3
		break;

	case IDABORT:
		ExitProcess(0);
		
	};
}

// new[] operator handler for the overflow-guard protection mode
// Allocates buffer at the end of the page, next page will be marked as invalid.
// Any access behind the end of the buffer will be failed
void* AllocateOverflowGuardedBuffer(int size)
{
	void* mem = VirtualAlloc( NULL, size + PAGE_SIZE, MEM_RESERVE, PAGE_NOACCESS );
	if( !mem )
	{
		DWORD dwSize = (DWORD)size;
		__asm	mov		eax, dwSize
		__INT3
		return NULL;
	}
	mem = VirtualAlloc( mem, size, MEM_COMMIT, PAGE_READWRITE );

	DWORD dwSmth = size % PAGE_SIZE ? size % PAGE_SIZE : PAGE_SIZE;
	DWORD ps = PAGE_SIZE - dwSmth;
	__asm
	{
		mov al, 0xfd
		mov ecx, ps
		mov edi, mem
		rep stosb
	}

	mem = (LPVOID)( (DWORD)mem + PAGE_SIZE - dwSmth );

	int i;
	for( i=0; i<sizeof(__allocs)/sizeof(*__allocs); i++ )
		if( !__allocs[i].mem )
		{
			__allocs[i].guard_type = OVERFLOW_GUARD;
			__allocs[i].len = size;
			return (__allocs[i].mem = mem);
		}
	
	DWORD dwWholeRegionSize = (size - dwSmth) + PAGE_SIZE;

	VirtualFree( mem, dwWholeRegionSize,  MEM_DECOMMIT );
	VirtualFree( mem, 0, MEM_RELEASE );

	OutputDebugString(__FUNCTION__" : [ERROR] : RESULT == NULL");

	return NULL;
}

// delete[] operator handler for the overflow-guard protection mode
void FreeOverflowGuardedBuffer(void* mem)
{
	if (!mem) return;

	SYSTEM_INFO si = {0};
	GetSystemInfo( &si );

	for( int i=0; i<sizeof(__allocs)/sizeof(*__allocs); i++ )
		if( __allocs[i].mem == mem )
		{
			if( __allocs[i].len == -1 )
			{
				DebugMessage(
					"Attempt to free already freed buffer 0x%08x.\n"
					"Possible it's a result of incorrect destructor call."
					,
					mem
					);
				return;
			}

			DWORD dwSmth = __allocs[i].len % PAGE_SIZE ? __allocs[i].len % PAGE_SIZE : PAGE_SIZE;
			long ps = PAGE_SIZE - dwSmth;
			LPVOID addr = (LPVOID)( (DWORD)mem + dwSmth - PAGE_SIZE );

			int j;
			for( j=0; j < ps; j++ )
				if( ((unsigned char*)addr)[j] != 0xfd )
					break;
			ps -= j;
			
			if( ps )
			{
				DebugMessage(
					"Buffer underflow detected while overflow-guard protection at address 0x%08x.\n"
					"It's highly recommended to test program in underflow-guard mode to detect faulting instruction."
					,
					mem
					);
			}

			DWORD dwWholeRegionSize = (__allocs[i].len - dwSmth) + PAGE_SIZE;

			VirtualFree( mem, dwWholeRegionSize,  MEM_DECOMMIT );
			VirtualFree( mem, dwWholeRegionSize + PAGE_SIZE, MEM_RELEASE );

			__allocs[i].len = -1;
			__allocs[i].mem = NULL;
			return;
		}

	__asm mov	eax, mem
	//__INT3
}

void* __cdecl dmalloc(size_t s)
{
	static bool except_handler_set = false;

	if( !except_handler_set )
	{
		except_handler_set = true;
		SetUnhandledExceptionFilter( MyUnhandledExceptionFilter );
	}
	
AFTER_PTRANSFER_BEGIN
	ZeroMemory(__allocs, sizeof(__allocs));
AFTER_PTRANSFER_END

#if BUFFER_GUARD == OVERFLOW_GUARD
	return AllocateOverflowGuardedBuffer( s );
#else
#	error Unknown BUFFER_GUARD value
#endif
}

void* __cdecl _dmalloc(size_t s)
{
	return dmalloc(s);
}

void __cdecl dfree(void* p)
{

#if BUFFER_GUARD == OVERFLOW_GUARD
	FreeOverflowGuardedBuffer( p );
#else
#	error Unknown BUFFER_GUARD value
#endif
}

void* __cdecl drealloc(void* p, size_t s)
{
	int nSizeToSave = 0;
	void* pres = NULL;
	if (p) {
		// Getting length of current allocated block
		int i=0;
		for( ;i<sizeof(__allocs)/sizeof(*__allocs); i++ ) {
			if( __allocs[i].mem == p )
			{
				nSizeToSave = __allocs[i].len;
				break;
			}
		}
		if (!nSizeToSave) {
			// Cannot find mem block to get size ?
			__asm mov	eax, p
			__INT3
			return pres;
		}
		// Getting size of count of bytes to save them into bck buffer
		nSizeToSave = min(nSizeToSave, (int)s);
		// Saving smth data to bck buffer
		void* pbck = dmalloc(nSizeToSave);
		if (!pbck) {
			__INT3
			return NULL;
		}
		CopyMemory(pbck, p, nSizeToSave);
		dfree(p);
		// Creating new buffer and recover data into it
		pres = dmalloc(s);
		if (!pres) {
			__INT3
			free(pbck);
			return NULL;
		}
		CopyMemory(pres, pbck, nSizeToSave);
		// Free bck buffer
		free(pbck);
	}
	else {
		pres = dmalloc(s);
	}
	return pres;
}

#endif

#endif