#include "includes.h"

//     str  mask
// ,  str="kill death and live your life!"  mask="kill*death*life*",
//    TRUE
//  str="just die, man!"  mask="*life*"
//    FALSE
// 
BOOL strcmpmask(PCHAR str_, PCHAR mask_)
{
	//   
	DWORD ln_str = (DWORD)strlen(str_);
	if (!ln_str)
		return FALSE;
	DWORD ln_mask = (DWORD)strlen(mask_);
	PCHAR str = (PCHAR)malloc(ln_str + 1);
	if (!str)
		return FALSE;
	strcpy(str, str_);
	PCHAR mask = (PCHAR)malloc(ln_mask + 1);
	if (!mask) {
		free(str);
		return FALSE;
	}
	strcpy(mask, mask_);
	str = _strlwr(str);
	mask = _strlwr(mask);

	// mcnt -   ,    mask
	INT mcnt = 1;
	INT mln = (INT)strlen(mask);
	INT i;
	for (i = 0; i < mln; i++)
		if (mask[i] == '*') mcnt++;

	//   mstrs   mask

	//    
	PCHAR * mstrs = (PCHAR *)malloc(mcnt * sizeof(LPVOID));
	if (!mstrs) {
		free(str);
		free(mask);
		return FALSE;
	}
	for(i = 0; i < mcnt; i++)
	{
		mstrs[i] = (PCHAR)malloc(MAX_PATH);
		if (!mstrs[i]) {
			for ( i--; i >= 0; i--)
				free(mstrs[i]);
			free(mstrs);
			free(str);
			free(mask);
			return FALSE;
		}
		mstrs[i][0] = '\0';
	}
	
	//    mstrs
	INT j = 0, k = 0;
	for (i = 0; i < mln; i++)
	{
		if (mask[i] == '*')
		{
			j++;
			k = 0;
		}
		else
		{
			mstrs[j][k] = mask[i];
			mstrs[j][++k] = '\0';
		}
	}

	//    str  mask
	BOOL RESULT = TRUE;

	PCHAR strpos = NULL;
	PCHAR strpos_bck = NULL;
	for (i = 0; i < mcnt; i++)
	{
		//    ,  
		if (mstrs[i][0] == '\0') continue;

		//   i-    str
		strpos = strstr(str, mstrs[i]);

		//    ,  FALSE
		if (!strpos)
		{
			RESULT = FALSE;
			break;
		}

		//    >= ,  FALSE
		if (strpos_bck && strpos_bck >= strpos)
		{
			RESULT = FALSE;
			break;
		}

		//            str,  FALSE
		if (!i && strpos != str)
		{
			RESULT = FALSE;
			break;
		}

		//            str,  FALSE
		if (i == mcnt - 1 && strpos + strlen(mstrs[i]) != str + strlen(str))
		{
			RESULT = FALSE;
			break;
		}

		//        str
		strpos_bck = strpos;
	}
	
	//  ,    
	for (i = 0; i < mcnt; i++)
		free(mstrs[i]);
	free(mstrs);
	free(str);
	free(mask);
	
	return RESULT;
}

#ifdef BSTR
BOOL strcmpmaskW(BSTR str, BSTR mask)
{
	if (!str || !mask)
		return FALSE;

	DWORD ln = SysStringLen(str);
	PWCHAR str_ = (PWCHAR)malloc((ln + 1) * sizeof(WCHAR));
	if (!str_)
		return FALSE;
	memcpy(str_, str, (ln + 1) * sizeof(WCHAR));
	UNICODEtoANSI(str_, ln);

	ln = SysStringLen(mask);
	PWCHAR mask_ = (PWCHAR)malloc((ln + 1) * sizeof(WCHAR));
	if (!mask_) {
		free(str_);
		return FALSE;
	}
	memcpy(mask_, mask, (ln + 1) * sizeof(WCHAR) );
	UNICODEtoANSI(mask_, ln);

	BOOL res = strcmpmask((PCHAR)str_, (PCHAR)mask_);

	free(str_);
	free(mask_);

	return res;
}
#endif