        ;*****************************************************
	;
        ;         Fast DES routines
	;	- Copyright 1991, Christian Beaumont
	;
	;
	;   This program is free software; you can
	;   redistribute it and/or modify it as you see fit.
	;
	;   This program is distributed in the hope that it
	;   will be useful, but WITHOUT ANY WARRANTY; without
	;   even the implied warranty of MERCHANTABILITY or
	;   FITNESS FOR A PARTICULAR PURPOSE.
	;
	;*****************************************************

                Locals

		.Model	Small,C

		.Data

		Public	FP
		
		;******************************************
		;			   -1
		; Final Permutation FP = IP
		;
FP		db	39, 7,47,15,55,23,63,31
		db	38, 6,46,14,54,22,62,30
		db	37, 5,45,13,53,21,61,29
		db	36, 4,44,12,52,20,60,28
		db	35, 3,43,11,51,19,59,27
		db	34, 2,42,10,50,18,58,26
		db	33, 1,41, 9,49,17,57,25
		db	32, 0,40, 8,48,16,56,24
		;
		;******************************************


		Public	PC1_C,PC1_D

		;******************************************
		;
		; Permuted choice 1 from key bits
		; to yield C and D.
		; Parity check bits left out
		;
PC1_C		db	57,49,41,33,25,17, 9
		db	 1,58,50,42,34,26,18
		db	10, 2,59,51,43,35,27
		db	19,11, 3,60,52,44,36
		;
PC1_D		db	63,55,47,39,31,23,15
		db	 7,62,54,46,38,30,22
		db	14, 6,61,53,45,37,29
		db	21,13, 5,28,20,12, 4
		;
		;******************************************


		Public	PC2_C,PC2_D

		;******************************************
		;
		; Permuted choice 2, to pick out the bits
		; from the CD array that generates the key
		;
PC2_C		db	14,17,11,24, 1, 5
		db	 3,28,15, 6,21,10
		db	23,19,12, 4,26, 8
		db	16, 7,27,20,13, 2
		;
PC2_D		db	41,52,31,37,47,55
		db	30,40,51,45,33,48
		db	44,49,39,56,34,53
		db	46,42,50,36,29,32
		;
		;******************************************


		Public	E

		;******************************************
		;
		; The E bit-selection table
		;
E		db	32, 1, 2, 3, 4, 5
		db	 4, 5, 6, 7, 8, 9
		db	 8, 9,10,11,12,13
		db	12,13,14,15,16,17
		db	16,17,18,19,20,21
		db	20,21,22,23,24,25
		db	24,25,26,27,28,29
		db	28,29,30,31,32, 1
		;
		;******************************************


		Public	P

		;******************************************
		;
		; P is a permutation on the selected
		; combination of the current L and key
		;
P		db	16, 7,20,21
		db	29,12,28,17
		db	 1,15,23,26
		db	 5,18,31,10
		db	 2, 8,24,14
		db	32,27, 3, 9
		db	19,13,30, 6
		db	22,11, 4,25
		;
		;******************************************


		Public	S

		;******************************************
		;
		; The 8 selection functions
		;
S		db	14, 4,13, 1, 2,15,11, 8, 3,10, 6,12, 5, 9, 0, 7
		db	 0,15, 7, 4,14, 2,13, 1,10, 6,12,11, 9, 5, 3, 8
		db	 4, 1,14, 8,13, 6, 2,11,15,12, 9, 7, 3,10, 5, 0
		db	15,12, 8, 2, 4, 9, 1, 7, 5,11, 3,14,10, 0, 6,13
		;
		db	15, 1, 8,14, 6,11, 3, 4, 9, 7, 2,13,12, 0, 5,10
		db	 3,13, 4, 7,15, 2, 8,14,12, 0, 1,10, 6, 9,11, 5
		db	 0,14, 7,11,10, 4,13, 1, 5, 8,12, 6, 9, 3, 2,15
		db	13, 8,10, 1, 3,15, 4, 2,11, 6, 7,12, 0, 5,14, 9
		;
		db	10, 0, 9,14, 6, 3,15, 5, 1,13,12, 7,11, 4, 2, 8
		db	13, 7, 0, 9, 3, 4, 6,10, 2, 8, 5,14,12,11,15, 1
		db	13, 6, 4, 9, 8,15, 3, 0,11, 1, 2,12, 5,10,14, 7
		db	 1,10,13, 0, 6, 9, 8, 7, 4,15,14, 3,11, 5, 2,12
		;
		db	 7,13,14, 3, 0, 6, 9,10, 1, 2, 8, 5,11,12, 4,15
		db	13, 8,11, 5, 6,15, 0, 3, 4, 7, 2,12, 1,10,14, 9
		db	10, 6, 9, 0,12,11, 7,13,15, 1, 3,14, 5, 2, 8, 4
		db	 3,15, 0, 6,10, 1,13, 8, 9, 4, 5,11,12, 7, 2,14
		;
		db	 2,12, 4, 1, 7,10,11, 6, 8, 5, 3,15,13, 0,14, 9
		db	14,11, 2,12, 4, 7,13, 1, 5, 0,15,10, 3, 9, 8, 6
		db	 4, 2, 1,11,10,13, 7, 8,15, 9,12, 5, 6, 3, 0,14
		db	11, 8,12, 7, 1,14, 2,13, 6,15, 0, 9,10, 4, 5, 3
		;
		db	12, 1,10,15, 9, 2, 6, 8, 0,13, 3, 4,14, 7, 5,11
		db	10,15, 4, 2, 7,12, 9, 5, 6, 1,13,14, 0,11, 3, 8
		db	 9,14,15, 5, 2, 8,12, 3, 7, 0, 4,10, 1,13,11, 6
		db	 4, 3, 2,12, 9, 5,15,10,11,14, 1, 7, 6, 0, 8,13
		;
		db	 4,11, 2,14,15, 0, 8,13, 3,12, 9, 7, 5,10, 6, 1
		db	13, 0,11, 7, 4, 9, 1,10,14, 3, 5,12, 2,15, 8, 6
		db	 1, 4,11,13,12, 3, 7,14,10,15, 6, 8, 0, 5, 9, 2
		db	 6,11,13, 8, 1, 4,10, 7, 9, 5, 0,15,14, 2, 3,12
		;
		db	13, 2, 8, 4, 6,15,11, 1,10, 9, 3,14, 5, 0,12, 7
		db	 1,15,13, 8,10, 3, 7, 4,12, 5, 6,11, 0,14, 9, 2
		db	 7,11, 4, 1, 9,12,14, 2, 0, 6,10,13,15, 3, 5, 8
		db	 2, 1,14, 7, 4,10, 8,13,15,12, 9, 0, 3, 5, 6,11
		;
		;******************************************


		Public	shifts

		;******************************************
		;
		; Sequence shifts used for the key schedule
		;
shifts		db	1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1
		;
		;******************************************


		Public	C C,D

		;******************************************
		;
		; The C and D arrays used to calculate the
		; key schedule
		;
C		db	28 dup(?)
D		db	28 dup(?)
		;
		;******************************************


		Public	KSL,KSH

		;******************************************
		;
		; Left and right 24 bits of keys
		;
KSL		dd	16 dup(?)
KSH		dd	16 dup(?)
		;
		;******************************************


		Public	LR,L,R

		;******************************************
		;
		; The current clock divided into two halfs
		;
LR		label	byte
L		db	32 dup(?)
R		db	32 dup(?)
		;
		;******************************************


		Public	S0L,S1L,S2L,S3L,S4L,S5L,S6L,S7L
		Public	S0H,S1H,S2H,S3H,S4H,S5H,S6H,S7H

		;******************************************
		;
		; Tables that combine S and P operations
		;
S0L		dd	64 dup(?)
S1L		dd	64 dup(?)
S2L		dd	64 dup(?)
S3L		dd	64 dup(?)
S4L		dd	64 dup(?)
S5L		dd	64 dup(?)
S6L		dd	64 dup(?)
S7L		dd	64 dup(?)
		;
S0H		dd	64 dup(?)
S1H		dd	64 dup(?)
S2H		dd	64 dup(?)
S3H		dd	64 dup(?)
S4H		dd	64 dup(?)
S5H		dd	64 dup(?)
S6H		dd	64 dup(?)
S7H		dd	64 dup(?)
		;
		;******************************************

onebits48	dw	?
tmpE		db	48 dup(?)

stt		dw	S0L, S0H
		dw	S1L, S1H
		dw	S2L, S2H
		dw	S3L, S3H
		dw	S4L, S4H
		dw	S5L, S5H
		dw	S6L, S6H
		dw	S7L, S7H
		;
Ll		dd	?
Lh		dd	?
Rl		dd	?
Rh		dd	?
_Dl		dd	?
_Dh		dd	?
spstore		dw	?
bpstore		dw	?
saltme		dd	?

		public	baseptr
baseptr		dd	?

		Ends

DummySeg	Segment	Para Use16
_aa		dd	64*64 dup(?)
_ab		dd	64*64 dup(?)
_ac		dd	64*64 dup(?)
_ad		dd	64*64 dup(?)
DummySeg	Ends

BigSeg1		Segment Para Use16
S0LS1L		dd	64*64 dup(?)
S0HS1H		dd	64*64 dup(?)
S2LS3L		dd	64*64 dup(?)
S2HS3H		dd	64*64 dup(?)
BigSeg1		Ends

BigSeg2		Segment	Para Use16
S4LS5L		dd	64*64 dup(?)
S4HS5H		dd	64*64 dup(?)
S6LS7L		dd	64*64 dup(?)
S6HS7H		dd	64*64 dup(?)
BigSeg2		Ends



		.Code

		.386

		ASSUME	FS:BigSeg1,GS:BigSeg2

		Public	sixbitTOtf
	    	Public	Fperm
	     	Public	undoe
	       	Public	toBA64
		Public	xform
		Public	Combiner
		Public	DoSelfMod
		Public	shortcrypt
		Public	fsetkey

COMB		Macro	Row,Col
		local	Loop0,Loop1
		lea	si,Row
		lea	bx,Col
		mov	bp,si
		mov	cx,64
Loop1:
		push	cx
		mov	si,bp
		mov	edx,[bx]

		rol	edx,16
		shl	dl,2
		rol	edx,16
		shl	dl,2

		add	ebx,4
		mov	cx,64
Loop0:
		lodsd

		rol	eax,16
		shl	al,2
		rol	eax,16
		shl	al,2

		xor	eax,edx
		stosd
		loop	Loop0
		pop	cx
		loop	Loop1
		Endm



Combiner	Proc	C Near
		push	si
		push	di
		push	bp
		push	es
		mov	ax,BigSeg1
		mov	es,ax
		sub	di,di
		COMB	S0L,S1L
		COMB	S0H,S1H
		COMB	S2L,S3L
		COMB	S2H,S3H
		mov	ax,BigSeg2
		mov	es,ax
		sub	di,di
		COMB	S4L,S5L
		COMB	S4H,S5H
		COMB	S6L,S7L
		COMB	S6H,S7H
		;
		mov	bx,BigSeg1
		mov	fs,bx
		mov	bx,BigSeg2
		mov	gs,bx
		;
		pop	es
		pop	bp
		pop	di
		pop	si
		ret
Combiner	Endp



		;******************************************
		;
		; Convert unsl in six bits per byte format
		; to twenty-four bit contiguous format.
		; Return result
		;
sixbitTOtf	Proc	C Near
		ARG	sb:DWORD
		mov	eax,DWord Ptr sb
		shl	al,2
		shl	ax,2
		rol	eax,16
		shl	al,2
		shr	ax,2
		ror	eax,4
		mov	dx,ax
		ror	eax,16
		ret
sixbitTOtf	Endp
		;
		;******************************************



		;******************************************
		;
		; Final Permutation
		;
Fperm		Proc	C Near block
		push	si
		push	di
		cld
		mov	ax,ds
		mov	es,ax
		lea	si,FP
		mov	di,Word Ptr block
		lea	bx,L
@@Loop:
		lodsb
		xlat
		stosb
		cmp	si,Offset FP+64
		jne	@@Loop
		pop	di
		pop	si
		ret
Fperm		Endp
		;		          
		;******************************************



		;******************************************
		;
		; Inverse of E permutation
		;
undoe		Proc	C Near
		ARG	fromarr:WORD,toarr:WORD
		push	si
		push	di
		mov	si,Word Ptr fromarr
		mov	di,Word Ptr toarr
		sub	cx,cx
@@Loop:
		mov	bx,cx
		shr	bx,2 
		shl	bx,1
		mov	ax,bx
		shl	bx,1
		add	bx,ax
		mov	ax,cx
		and	ax,3
		add	bx,ax
		mov	al,[bx + si + 1]
		mov	bx,cx
		mov	[bx + di],al
		inc	cx
		cmp	cx,32
		jne	@@Loop
		pop	di
		pop	si
		ret
undoe		Endp
		;******************************************



		;******************************************
		;
		;
toBA64		Proc	C Near
		ARG	quarters:WORD,onebits64:WORD

		push	si

		mov	bx,ds
		mov	es,bx
		cld

		;
		mov	si,Word Ptr quarters ; get first quarter
		mov	eax,[si]
		push	eax
		call	sixbitTOtf
		add	sp,2


Looper		= 	0
		rept	24
		 ror	eax,1
		 setc	[tmpE+Looper]
Looper		=	Looper +1
		endm

		mov	eax,[si+4]
		push	eax
		call	sixbitTOtf
		add	sp,2

		rept	24
		 ror	eax,1
		 setc	[tmpE+Looper]
Looper		=	Looper +1
		endm

		lea	ax,L
		push	ax
		lea	ax,tmpE
		push	ax
		call	undoe
		add	sp,4

		mov	eax,[si+8]
		push	eax
		call	sixbitTOtf
		add	sp,2

Looper		=	0
		rept	24
		 ror	eax,1
		 setc	[tmpE+Looper]
Looper		=	Looper +1
		endm

		mov	eax,[si+12]
		push	eax
		call	sixbitTOtf
		add	sp,2

		rept	24
		 ror	eax,1
		 setc	[tmpE+Looper]
Looper		=	Looper +1
		endm

		lea	ax,R
		push	ax
		lea	ax,tmpE
		push	ax
		call	undoe
		add	sp,4
		;
		mov	ax,Word Ptr onebits64
		push	ax
		call	Fperm
		pop	ax
		;
		pop	si
		ret
toBA64		Endp
		;******************************************




		;******************************************
BigMac1		Macro	Inner
		Local	ModLow,ModHigh
		mov	ebp,esi
		xor	ebp,edi
		and	ebp,eax

		mov	ebx,ebp
		xor	ebx,esi
ModLow:		xor	ebx,12345678h ;KSL+Inner*4

		xor	ecx,S0LS1L[bx]
		xor	edx,S0HS1H[bx]
		shr	ebx,16
		xor	ecx,S2LS3L[bx]
		xor	edx,S2HS3H[bx]

		xor	ebp,edi
ModHigh:	xor	ebp,12345678h ;KSH+Inner*4

		xor	ecx,S4LS5L[bp]
		xor	edx,S4HS5H[bp]
		shr	ebp,16
		xor	ecx,S6LS7L[bp]
		xor	edx,S6HS7H[bp]
		
		.Data
 		dw	ModLow+3,ModHigh+3
  		.Code

		Endm
		;******************************************



		;******************************************
BigMac2		Macro	Inner
		Local	ModLow,ModHigh
		mov	ebp,ecx
		xor	ebp,edx
		and	ebp,eax

		mov	ebx,ebp
		xor	ebx,ecx
ModLow:		xor	ebx,12345678h ;KSL+Inner*4

		xor	esi,S0LS1L[bx]
		xor	edi,S0HS1H[bx]
		shr	ebx,16
		xor	esi,S2LS3L[bx]
		xor	edi,S2HS3H[bx]
                      
		xor	ebp,edx
ModHigh:	xor	ebp,12345678h ;KSH+Inner*4

		xor	esi,S4LS5L[bp]
		xor	edi,S4HS5H[bp]
		shr	ebp,16
		xor	esi,S6LS7L[bp]
		xor	edi,S6HS7H[bp]

   		.Data
    		dw	ModLow+3,ModHigh+3
     		.Code

		Endm
		;******************************************


		.Data
SelfModTab	Label	Word
		.Code

		;******************************************
		;
                ; Encrypt that block.
		;
		;
xform		Proc	C Near
		;ARG	quarters:WORD,saltvalue:DWORD
		cli
		push	si
		push	di

		mov	spstore,sp
		mov	bpstore,bp

		;mov	eax,saltvalue    ;not needed without the arg

	   	;rol	eax,16
	   	;shl	al,2
	   	;rol	eax,16
	   	;shl	al,2

		sub	ecx,ecx
		sub	edx,edx
		sub	esi,esi
		sub	edi,edi
		sub	sp,sp
@@Loop:
		BigMac1	0
	       	BigMac2	1
	       	BigMac1	2
	       	BigMac2	3
	       	BigMac1	4
	       	BigMac2	5
	       	BigMac1	6
	       	BigMac2	7
	       	BigMac1	8
	       	BigMac2	9
	       	BigMac1	10
	       	BigMac2	11
	       	BigMac1	12
	       	BigMac2	13
	       	BigMac1	14
	       	BigMac2	15

		xchg	ecx,esi
		xchg	edx,edi

		inc	sp
		cmp	sp,25
	       	je	@@Quit
	       	jmp	@@Loop
@@Quit:
		mov	baseptr,ebp
		mov	bp,bpstore
		mov	sp,spstore

		mov	eax,ecx
		mov	ebx,edx
		mov	ecx,esi
		mov	edx,edi

	  	;rol	eax,16
	   	;shr	al,2
	   	;rol	eax,16
	   	;shr	al,2
	   
	   	;rol	ebx,16
	   	;shr	bl,2
	   	;rol	ebx,16
	   	;shr	bl,2

	   	;rol	ecx,16
	   	;shr	cl,2
	   	;rol	ecx,16
	   	;shr	cl,2

	   	;rol	edx,16
	  	;shr	dl,2
	   	;rol	edx,16
	   	;shr	dl,2

	   	;mov	si,Word Ptr quarters
	        ;mov	[si],eax
	   	;mov	[si+4],ebx
	   	;mov	[si+8],ecx
	   	;mov	[si+12],edx

		pop	di
		pop	si
		sti
		ret
xform		Endp
		;
		;******************************************


		;******************************************
		;
		; Self modify the transform to use new
		; Key schedule
		;
DoSelfMod	Proc	Near
		push	si
Inner		=	0
		rept	16
		mov	eax,KSL+Inner*4
		mov	ebx,KSH+Inner*4
		mov	si,SelfModTab+Inner*4
		mov	cs:[si],eax
		mov	si,SelfModTab+Inner*4+2
		mov	cs:[si],ebx
Inner		=	Inner + 1
		endm
		pop	si
		ret
DoSelfMod	Endp
		;
		;******************************************


		.DATA
_out96		dd	4 dup(?)
		.CODE

		;******************************************
		;
shortcrypt	Proc	C Near
		ARG	out96:WORD,saltvalue:DWORD
		push	si
		mov	eax,saltvalue
		;push	eax
		;lea	ax,_out96
		;push	ax
		call	xform
		;add	sp,6

		mov	si,out96
		and	eax,1e781e78h
		cmp	eax,[si]
		jne	@@NoGood

		and	ebx,1e781e78h
		cmp	ebx,[si+4]
		jne	@@NoGood

		and	ecx,1e781e78h
		cmp	ecx,[si+8]
		jne	@@NoGood

		and	edx,1e781e78h
		cmp	edx,[si+12]
		jne	@@NoGood

		mov	ax,1
		pop	si
		ret
@@NoGood:
		mov	ax,0
		pop	si
		ret
shortcrypt	Endp
		;
		;******************************************

fsetkey		Proc	C Near
		ARG	key:WORD
		push	si
		push	di
		mov	ax,ds
		mov	es,ax
		cld
		sub	si,si
		mov	bx,key
		dec	bx
		mov	cx,28
@@Loop:
		mov	al,PC1_C[si]
		xlat
		mov	C[si],al
		mov	al,PC1_D[si]
		xlat
		mov	D[si],al
		inc	si
		loop	@@Loop
		;
		sub	dx,dx
		sub	bx,bx
@@Loop1:

		movzx	cx,shifts[bx]
@@Loop2:
		push	cx
		;
		mov	al,C[0]
		mov	cx,27
		lea	di,C
		lea	si,C+1
		rep	movsb
		mov	C[27],al
		;
		mov	al,D[0]
		mov	cx,27
		lea	di,D
		lea	si,D+1
		rep	movsb
		mov	D[27],al
		;
		pop	cx
		loop	@@Loop2

		shl	bx,2
		sub	eax,eax
		sub	si,si
		mov	cx,24
@@Loop3:
		mov	dl,PC2_C[si]
 		mov	di,dx
		or	al,C[di-1]
		ror	eax,1
		inc	si
		loop	@@Loop3

		ror	eax,8
		shl	eax,4
		shr	ax,2
		rol	eax,16
		rol	ax,2
		rol	eax,16
		mov	KSL[bx],eax

		sub	eax,eax
		sub	si,si
		mov	cx,24
@@Loop4:
		mov	dl,PC2_D[si]
		mov	di,dx
		or	al,D[di-28-1]
		ror	eax,1
		inc	si
		loop	@@Loop4

		ror	eax,8
		shl	eax,4
		shr	ax,2
		rol	eax,16
		rol	ax,2
		rol	eax,16
		mov	KSH[bx],eax

		shr	bx,2
		inc	bx
		cmp	bx,16
		je	@@Quit
		jmp	@@Loop1
@@Quit:
		pop	di
		pop	si
		ret
fsetkey		Endp

		End




