#include	"fdes.h"

extern unsb		FP[];
extern unsb		PC1_C[];
extern unsb		PC1_D[];
extern unsb		PC2_C[];
extern unsb		PC2_D[];
extern unsb		E[];
extern unsb		P[];
extern fbpb4R	S[8][64];
extern unsb		shifts[];
extern obpb1	C[28];
extern obpb1	D[28];
extern sbpb24	KSL[16], KSH[16];
extern obpb1	L[32], R[32];
extern sbpb24	S0L[64], S1L[64], S2L[64], S3L[64],
					S4L[64], S5L[64], S6L[64], S7L[64];
extern sbpb24	S0H[64], S1H[64], S2H[64], S3H[64],
					S4H[64], S5H[64], S6H[64], S7H[64];


void		fsetkey(obpb1 *key);
void		init(unsl tableno, sbpb24 *lowptr,sbpb24 *highptr);
fbpb4		lookupS(unsl tableno, sbpb6R t6bits);
void		init_des(void);
ebpb24      sixbitTOtf(sbpb24 sb);
sbpb24      tfTOsixbit(ebpb24 tf);
void		Combiner(void);

/* Convert unsl in twenty-four bit contiguous format
 * to six bits per byte format.  Return result.
 */
sbpb24 tfTOsixbit(ebpb24 tf)
{
	sbpb24	res;

	res = 0;
	res |= (tf >> 0) & 077;
	res |= ((tf >> 6) & 077) << 8;
	res |= ((tf >> 12) & 077) << 16;
	res |= ((tf >> 18) & 077) << 24;
	return(res);
}


/* Convert unsl in six bits per byte format
 * to twenty-four bit contiguous format.  Return result.
 */
 /*
ebpb24	sixbitTOtf(sbpb24 sb)
{
	ebpb24	res;

	res = 0;
	res |= (sb >> 0) & 077;
	res |= ((sb >> 8) & 077) << 6;
	res |= ((sb >> 16) & 077) << 12;
	res |= ((sb >> 24) & 077) << 18;
	return(res);
}
*/


/*
 * Lookup an S-box entry.
 */
fbpb4	lookupS(unsl tableno, sbpb6R t6bits)
{
	sbpb6	fixed6bits;
	fbpb4R	r;
	fbpb4	fixedr;

	fixed6bits = (((t6bits >> 0) &01) << 5)+
	             (((t6bits >> 1) &01) << 3)+
                     (((t6bits >> 2) &01) << 2)+
                     (((t6bits >> 3) &01) << 1)+
                     (((t6bits >> 4) &01) << 0)+
                     (((t6bits >> 5) &01) << 4);

	r = S[tableno][fixed6bits];

	fixedr = (((r >> 3)&01) << 0)+
	         (((r >> 2)&01) << 1)+
		 (((r >> 1)&01) << 2)+
		 (((r >> 0)&01) << 3);

	return(fixedr);
}



void	init_des(void)
{
	init(0, S0L, S0H);
	init(1, S1L, S1H);
	init(2, S2L, S2H);
	init(3, S3L, S3H);
	init(4, S4L, S4H);
	init(5, S5L, S5H);
	init(6, S6L, S6H);
	init(7, S7L, S7H);
	Combiner();
}



void	init(unsl tableno, sbpb24 *lowptr,sbpb24 *highptr)
{
	static	obpb1	tmp32[32];
	static	obpb1	tmpP32[32];
	static	obpb1	tmpE[32];
	int	j, k, i;

	for (j = 0 ; j < 64 ; j++)  {
		k = lookupS(tableno, j);
		for (i = 0 ; i < 32 ; i++)
			tmp32[i] = 0;
		for (i = 0 ; i < 4 ; i++)
			tmp32[4 * tableno + i] = (k >> i) & 01;
		for (i = 0 ; i < 32 ; i++)
			tmpP32[i] = tmp32[P[i] - 1];
		for (i = 0 ; i < 48 ; i++)
			tmpE[i] = tmpP32[E[i] - 1];
		lowptr[j] = 0;
		highptr[j] = 0;
		for (i = 0 ; i < 24 ; i++)
			lowptr[j] |= ((unsigned long)tmpE[i]) << i;
		for (k = 0, i = 24 ; i < 48 ; i++, k++)
			highptr[j] |= ((unsigned long)tmpE[i]) << k;
		lowptr[j] = tfTOsixbit(lowptr[j]);
		highptr[j] = tfTOsixbit(highptr[j]);
	}
}
