#define TITLESIZE 26

class designation
{
public:
	unsigned short prio;
	/*void __far  *operator new( size_t size ) {
	}
	void operator delete( void __far *ptr ) {
	} */
	unsigned short getPrio(){return prio ? prio : (seekNew ? 0 : 49);}
	unsigned long code;
	unsigned short color;
	time_t lastNoted;
	char title[TITLESIZE+1]; 
	designation(unsigned short cd) :
		code(cd),
		color(WHITE),
		prio(0)
	{
		title[0] = '?';
		title[1] = '\0';
		title[sizeof(title)-1] = '\0';
		lastNoted = now;
	}
	designation& operator=(const char *t) {
		title[sizeof(title)-1] = '\0';
		strncpy(title,t,sizeof(title)-1);
		return *this;
	}
	designation(unsigned long cd, unsigned short ic,unsigned short ip,
		const char *it,time_t itm):
		code(cd), color(ic), prio(ip),lastNoted(itm)
	{
		*this = it;
	}
	static designation *import(FILE *f)
	{
		static unsigned long cd;
		static unsigned short ic;
		static unsigned short ip;
		static time_t itm;
		register designation *nd;
		int z;
		static char tt[150];
		itm = 0;
		z = fscanf(f,"%4x,%hu,%hu,\"%[^\"]\",%lx,%*u",&cd,&ic,&ip,tt,&itm);
		if( z >= 4) {
			nd = new  designation(cd,ic,ip,tt,itm);
			if( !nd ) {
				printf("error allocating designations!");
				exit(1);
			}
			return nd;
		}
		return 0;		
	}
	BOOL 
	export(FILE *f)
	{
		return (fprintf(f,"%04hx,%hd,%hd,\"%s\",%lx,%hu\n",(WORD)code,color,prio,title,lastNoted,(WORD)code) == 6);
	}
};

	
class desigList : public CMapWordToOb {
public: 
	const char *fn;
	desigList(const char *ifn):CMapWordToOb(100),fn(strdup(ifn))
	{
		register FILE *fp = fopen(fn,"rt");
		register designation *d;
		if(fp) {
		        while( (d = designation::import(fp)) != 0) {
		        	SetAt((WORD)(d->code),(CObject*)d);
		        }
			fclose(fp);
		}
	}
	virtual ~desigList() {
		register designation   *d;
		CObject *pa;
		POSITION pos;
		WORD key;
		for( pos = GetStartPosition(); pos != NULL; ) 
		
		{
			GetNextAssoc( pos, key, pa );
			d = (designation *)pa;
			delete d;
		}		
		free((void*) fn);
		RemoveAll();
 	}
	desigList():CMapWordToOb(100),fn(0){}
	virtual void doSave(const char *tfn)
	{
		if(GetCount() > 0) {
			(void) unlink(tfn);
			register FILE *fp = fopen(tfn,"wt");
			if( fp ) {
				register designation *d;
				CObject *pa;
				POSITION pos;
				WORD key;
				for( pos = GetStartPosition(); pos != NULL; )
				{
					GetNextAssoc( pos, key, pa );
					d = (designation *)pa;
					if( !(d->title[0] == '?' && d->title[1] == '\0' &&
					 (d->getPrio() == 0 || d->getPrio() == 49)))
						d->export(fp);
				}
				fclose(fp);
			}
		} 
	}
	designation *get(WORD want)
	{
		CObject *co;
		if( Lookup(want,co)) {
			((designation *)co)->lastNoted = now;
			return (designation *)co;
		} else {
			register  designation  *d = new designation(want);
			if( !d ) {
				printf("error allocating blank designation");
				exit(1);
			}
		        SetAt((WORD)(d->code),(CObject *)d);
		        return d;
			        
		}	
	}
};

/*	Class GroupDesigList is a minor variant of DesigList that adds the GROUP bit
	to the code attribute so this list's entries can be known as groups instead of
	radio ids. Another way to do this would be to have two sub-classes of designations,
	groupDesig and radioDesig, and have different virtual functions that return 'type'..
	
	by rights, this function should overload the GET method, but for now I'm handling the
	GROUP bit by application logic for new objects.
*/

class GroupDesigList : public desigList {
public:
	char *sysType;
	int blkcounts[8][2];
	char blktypes[9];
	GroupDesigList(const char *ifn):desigList()
	
	{
		fn=strdup(ifn);
		register FILE *fp = fopen(fn,"rt");
		register designation *d;
		register int i;
		int tot;

		sysType="unknown";
		memset((void*)&blkcounts,'\0',sizeof(blkcounts));
		strcpy(blktypes,"????????");
		if(fp) {
	        while( (d = designation::import(fp)) != 0) {
	        	++blkcounts[(d->code>>13)&7][d->code&0x0f ? 0 : 1];
	        	d->code |= GROUPBIT;
	        	SetAt((WORD)(d->code),(CObject*)d);
	        }
			fclose(fp);
		}
		for(i=0;i<8; ++i) {
			tot = blkcounts[i][0] + blkcounts[i][1];
			if( tot > 10 ) {
				if( ((blkcounts[i][1]*100)/tot) >= 95) {
					blktypes[i] = '2';
				} else {
					blktypes[i] = '1';
				}
			}/* else {
				blktypes[i] = 'x';
			}*/	
		}
		sysType = blktypes;/*
		if( strchr(blktypes,'1') && strchr(blktypes,'2') );
		else if(strchr(blktypes,'1')) sysType = "Type 1";
		else if(strchr(blktypes,'2')) sysType = "Type 2";
		else sysType = "unknown";*/
		
	}
	virtual void doSave(const char *tfn)
	{
		register designation *d;
		CObject *pa;
		POSITION pos;
		WORD key;

		if(GetCount() > 0) {
			(void) unlink(tfn);
			register FILE *fp = fopen(tfn,"wt");
			if( fp ) {
				for( pos = GetStartPosition(); pos != NULL; )
				{
					GetNextAssoc( pos, key, pa );
					d = (designation *)pa;
					if( !(d->title[0] == '?' && d->title[1] == '\0' && d->prio == 0)) {
						d->export(fp);
					}
				}
				fclose(fp);
			}
		} 
	}
};
	
