#include <conio.h>
#include <dos.h>
#include <graph.h>
#include <afxcoll.h>
#include "colors.h"
#include "osw.h"
#include "designat.h"
#include "freqasg.h"
#include "trunksys.h" 

static enum 
{
	CMDMODE,
	IDMODE,
	TITLEMODE,
	RADIOMODE
}
keymode = CMDMODE;

static enum
{
	MENU1,
	MENU2
}
menuSelect = MENU1;

static enum
{
	RADIO_VOLUME,
	RADIO_SQUELCH
}
radioCmd = RADIO_VOLUME;

static int begCol, curCount, maxCount, gtype;
static unsigned short theId;
static char theTitle [100];
static char theInBuf [100];
static char tempArea [200];

extern Scanner *myScanner;

void debugSystem (void);

void showIprompt (int theType)
{
	_settextposition (PROMPTROW, 1);
	_settextcolor (GREEN);
	if(theType == 'g' || theType == 'G') 
	{
		sprintf (tempArea, "Group ID: 0x____ Title: __________________________%40s",
			"");
		_outtext (tempArea);
		gtype = 1;
	} 
	else 
	{
		sprintf (tempArea, "Radio ID: 0x____ Title: __________________________%40s",
			"");
		_outtext (tempArea);
		gtype = 0;
	}
	begCol = 13;
	curCount = 0;
	maxCount = 4;
	theId = 0;
	theInBuf [0] = '\0';
	theTitle [0] = '\0';
}

void showTprompt()
{
	begCol = 25;
	curCount = 0;
	maxCount = TITLESIZE;
	theTitle[0] = '\0';
} 

void
showRprompt ()
{
	sprintf (tempArea,
		"%c=Volume (%d), %c=Squelch (%d), +=Increment, -=Decrement, Q=Exit to main%40s",
		radioCmd == RADIO_VOLUME ? 'V' : 'v', myScanner->volume,
		radioCmd == RADIO_SQUELCH ? 'S' : 's', myScanner->squelch,
		"");
	tempArea [81] = 0;
	QuickOut (PROMPTROW, 1, GREEN, tempArea);
}

void 
showPrompt ()
{
	if (menuSelect == MENU1)
		sprintf (tempArea,
			"%c=Delay %c=Frame Indicator I,G=Annotate %c=Verbose %c=SeekNew space=More%40s",
			theDelay == DELAY_ON ? 'D':'d',
			showFrameSync ? 'F':'f',
			Verbose ? 'V':'v',
			seekNew ? 'N' : 'n',
			"");
	else
		sprintf (tempArea,
			"R=Radio menu, S=Save files, Q=Save+Quit, ESC=Quit (no save) space=More%40s",
			"");
			
	tempArea [81] = 0;
	QuickOut (PROMPTROW, 1, GREEN, tempArea);
}																						   

void
doKeyEvt()
{
	register int inchar = _getch();
	if( inchar == 0 || inchar == 0x0e)
		inchar = _getch();
	switch(keymode)
	{
	case CMDMODE:
		switch(inchar)
		{
		case '\033':
			if(mySys)
				mySys->unsafe(); 
		// INTENTIONAL drop-through
		case 'Q':	  // qQescape: quit
		case 'q':
			exit (0);

#if 01
		case 'Z' :
		case 'z' :
			debugSystem ();
			break;
#endif

		case 'n':
		case 'N':
			seekNew = !seekNew;
			showPrompt();
			break;

		case 'v':
		case 'V':
			Verbose = !Verbose;
			showPrompt();
			break;

		case 'D':
		case 'd':
			if(theDelay)
				theDelay = DELAY_OFF;
			else
				theDelay = DELAY_ON;
			showPrompt();
			break;

		case 'f':	// fF: toggle frame status updates
		case 'F':
			if( showFrameSync ) {
				showFrameSync = FALSE;
				gotoxy(52,STATROW);
				_settextcolor(WHITE);
				_outtext(" ");
			} else {
				showFrameSync = TRUE;
			}
			showPrompt();
			break; 

		case 's':
		case 'S':	// sS: save
			if(mySys)
				mySys->doSave();
			break;

		case 'g':
		case 'G':
		case 'i':
		case 'I':
			// enter annotation mode:
			if(mySys) {
				showIprompt(inchar); // should set cursors, too
				keymode = IDMODE;
			}
			break;

		case 'r':
		case 'R':
			showRprompt ();
			radioCmd = RADIO_VOLUME;
			keymode = RADIOMODE;
			break;

		case ' ' :
			if (menuSelect == MENU1)
				menuSelect = MENU2;
			else
				menuSelect = MENU1;
			showPrompt ();
			break;

		default:
			break;
		}
		break;

	case RADIOMODE :
		switch (inchar)
		{
			case 'v' :
			case 'V' :
				radioCmd = RADIO_VOLUME;
				showRprompt ();
				break;

			case 's' :
			case 'S' :
				radioCmd = RADIO_SQUELCH;
				showRprompt ();
				break;

			case '+' :
				if (radioCmd == RADIO_VOLUME)
				{
					myScanner->volume = min (myScanner->volume + 5, 255);
					myScanner->setVolume (myScanner->volume);
				}
				else if (radioCmd == RADIO_SQUELCH)
				{
					myScanner->squelch = min (myScanner->squelch + 5, 255);
					myScanner->setSquelch (myScanner->squelch);
				}
				showRprompt ();
				break;

			case '-' :
				if (radioCmd == RADIO_VOLUME)
				{
					myScanner->volume = max (myScanner->volume - 5, 0);
					myScanner->setVolume (myScanner->volume);
				}
				else if (radioCmd == RADIO_SQUELCH)
				{
					myScanner->squelch = max (myScanner->squelch - 5, 0);
					myScanner->setSquelch (myScanner->squelch);
				}
				showRprompt ();
				break;

			case 'q' :
			case 'Q' :
				showPrompt ();
				keymode = CMDMODE;
				break;

			default :
				break;
		}
		break;

	case IDMODE:
		switch(inchar)
		{
		case '\033': // abort annotation
			showPrompt();
			keymode = CMDMODE;
			break;

		case '\b':
			if( curCount > 0 ) {
				--curCount;
				theInBuf[curCount] = 0;
				_settextposition(PROMPTROW,begCol+curCount);
				_settextcolor(WHITE);
				_outtext("_");						
			}
			break; 

		case '\t':
		case '\r':
		case '\n':
			if(curCount && sscanf(theInBuf,"%hx",&theId) == 1) {
				showTprompt(); // should set cursors too
				keymode = TITLEMODE;
						
			} else {
				showPrompt();
				keymode = CMDMODE;
			}
			break;

		default:
			if((inchar >= '0' && inchar <= '9')
			   || (inchar >= 'a' && inchar <= 'f')
			   || (inchar >= 'A' && inchar <= 'F')
			) {
				theInBuf[curCount] = inchar;
				theInBuf[curCount+1] = '\0';
				_settextposition(PROMPTROW,begCol+curCount); 
				_settextcolor(WHITE);
				_outtext(&theInBuf[curCount]);
				if( ++curCount >= maxCount	) {
					if(sscanf(theInBuf,"%hx",&theId) == 1) {
						showTprompt(); // should set cursors too
						keymode = TITLEMODE;
								
					} else {
						showPrompt();
						keymode = CMDMODE;
					}
				}						
			}
		}
		break;

	case TITLEMODE:
		switch(inchar)
		{
		case '\033': // abort annotation
			showPrompt();
			keymode = CMDMODE;
			break;
		case '\b':
			if( curCount > 0 ) {
				--curCount;
				theTitle[curCount] = 0;
				_settextposition(PROMPTROW,begCol+curCount);
				_settextcolor(WHITE);
				_outtext("_");						
			}
			break; 

		case '\t':
		case '\r':
		case '\n':
			if(mySys) {
				if(gtype) {
					mySys->editGroup(theId,theTitle);
					sprintf(tempArea,"Group %.4hx Title %-30.30s",
						(WORD)theId,theTitle);
				} else {
					mySys->editId(theId,theTitle);
					sprintf(tempArea,"Radio %.4hx Title %-30.30s",
						(WORD)theId,theTitle);
				}
			} else {
				sprintf(tempArea,"%-47.47s","no system object!");
			}
			_settextposition(FBROW,1);
			_settextcolor(WHITE);
			_outtext(tempArea);
			showPrompt(); // should set cursors too
			keymode = CMDMODE;
			break;

		default:
			if((inchar >= '0' && inchar <= '9')
			   || (inchar >= 'a' && inchar <= 'z')
			   || (inchar >= 'A' && inchar <= 'Z')
			   || strchr(" !@#$%^&*()_-+={}|\\;'<>./?`",inchar)
			) {
				// append to title buffer if room
				theTitle[curCount] = inchar;
				theTitle[curCount+1] = '\0';
				_settextposition(PROMPTROW,begCol+curCount);
				_settextcolor(WHITE);
				_outtext(&theTitle[curCount]);
				if( ++curCount >= maxCount	) {
					_settextposition(FBROW,1);
					if(mySys) {
						if(gtype) {
							mySys->editGroup(theId,theTitle);
							sprintf(tempArea,"Group %.4hx Title %-30.30s",
								(WORD)theId,theTitle);
						} else { 
							mySys->editId(theId,theTitle);
							sprintf(tempArea,"Radio %.4hx Title %-30.30s",
								(WORD)theId,theTitle);
						}
					} else {
						sprintf(tempArea,"%-47.47s","no system object!");
					}
					_outtext(tempArea);
					showPrompt(); // should set cursors too
					keymode = CMDMODE;
				}						
			}
			break;
		}
		break;
	}
}

