#define SCANCMDLEN 50
#define FREQDISPLEN 13
#define NOTSEENDELAY 45

class frequencyAssignment
{
private:
	static double actualFreq;
	unsigned short prty;

public:
	static void doInitialize ();
	static void doFinalize ();
	designation *callingDes;
	designation *destDes;
	enum {	
		FREQEMPTY,
		FREQDATA,
		FREQCW,
		FREQCALL,
		FREQHOLD
	} fState;
	BOOL visited;
	BOOL dirty;
	time_t refreshFine;
	int x, y;
	unsigned short freqNum;
	BOOL selected;
	int scancmdlen;
	char scancmd [SCANCMDLEN];
	char freqdisp [FREQDISPLEN];
	unsigned short getPrio () {return prty;}
	void setPrio (short p) { prty = p; }

	void freshen () 
	{
		if (fState == FREQHOLD) 
		{
			dirty = TRUE;
			fState = FREQCALL;
		}

		if (fState == FREQCALL)
			refreshFine = nowFine;		
	}

   void noteInactive ()
   {
   	if (fState == FREQCALL) 
		{
    		if ((nowFine - refreshFine) > NOTSEENDELAY) 
			{
	    		if (theDelay) 
				{ 
	    			fState = FREQHOLD;
	    			dirty = TRUE;
	    			refreshFine = nowFine;
	    		}
				else 		 
				{
	    			unassign ();
	    		}
	    	}
    	}
		else if (fState == FREQHOLD) 
		{
    		if ((nowFine - refreshFine) > theDelay)
			{
    			unassign();
    		}
   	}
   }

	frequencyAssignment ()
	{
		//
		//  Unless this is set to a non-zero value, set frequency strings
		//  will be sent as 0-terminated strings.  If non-zero, they'll
		//  be treated as a counted string (the R7000 was the first scanner
		//  that caused this to be required).
		//
		scancmdlen = 0;
	}

	void create(int idx, int f, const char *actual = 0);
	void assign(designation *,designation*);
	void assignCW(BOOL);
	void assignD();
	void unassign();
	void show();
};
