#include <conio.h>
#include <graph.h>
#include <afxcoll.h>
#include "colors.h"
#include "osw.h"
#include "designat.h"
#include "freqasg.h"

static char tempArea [160];
double frequencyAssignment::actualFreq;
static char lineChars [] = "-----------------------------------------------";

void 
frequencyAssignment::create (register int idx, int f, const char *narrative)
{
	freqNum = f;
	if( narrative ) {
		sprintf(freqdisp,"   %-8.8s",narrative);
	} else {
		sprintf(freqdisp,"   %-8.8s",mapCodeToF(f));
	}
	x = 1;
	y = FREQROW+3 + idx;
	fState = FREQEMPTY;
	visited = TRUE;
	dirty = TRUE;
	refreshFine = 0;
	callingDes = 0;
	destDes = 0;
} 

void 
frequencyAssignment::show()
{
	BOOL stale = FALSE;
		       
	switch(fState)
	{
	case FREQHOLD:
		stale = TRUE;
		// drop thru
	case FREQCALL:
		QuickOut(y,x,stale ? GREEN : YELLOW,freqdisp);
		_settextposition(y,x+PRTYSTART);
		sprintf(tempArea,"%.2d",prty > 99 ? 99 : prty);
		_outtext(tempArea);			
		_settextposition(y,x+DETSTART);
		if(!stale && prty <= 50) {
			_settextcolor(destDes->color);
		} else if( prty > 50) {
			_settextcolor(DARKGRAY);
		}
		sprintf(tempArea,"%*.*s %.4hx",TITLESIZE,TITLESIZE,destDes->title,(WORD)destDes->code);
		_outtext(tempArea);
		_outtext(destDes->code&GROUPBIT ? " G ": " I ");
		if( callingDes ) {
			if( !stale && prty <= 50 ) {
				_settextcolor(callingDes->color); 
			}
			sprintf(tempArea,"%.4hx %-*.*s",(WORD)(callingDes->code),TITLESIZE,TITLESIZE,callingDes->title);
		} else {
			if(!stale && prty <= 50 ) {
				_settextcolor(WHITE);
			}
			sprintf(tempArea,"---- %-*.*s",TITLESIZE,TITLESIZE,"");
		}
		_outtext(tempArea);
		break;
	case FREQDATA: 
		QuickOut(y,x,DARKGRAY,freqdisp)
		_settextposition(y,x+PRTYSTART);
		sprintf(tempArea,"%-*.*s",ROWAREA-(x+PRTYSTART-1),ROWAREA-(x+PRTYSTART-1),"");
		_outtext(tempArea);
		break;
  	case FREQEMPTY:
		QuickOut(y,x,GREEN,freqdisp)
		_settextposition(y,x+PRTYSTART);
		sprintf(tempArea,"%-*.*s",ROWAREA-(x+PRTYSTART-1),ROWAREA-(x+PRTYSTART-1),
			"");
		_outtext(tempArea);
		break;
	case FREQCW:
		QuickOut(y,x,GREEN,freqdisp)
		_settextposition(y,x+PRTYSTART);
		sprintf(tempArea,"%-*.*s",ROWAREA-(x+PRTYSTART-1),ROWAREA-(x+PRTYSTART-1),
			"   CW Id");
		_outtext(tempArea);
		break;
	
	}
	dirty = FALSE;
}  

void
frequencyAssignment::unassign()
{
	if( fState != FREQEMPTY ) {
		fState = FREQEMPTY;
		destDes = 0;
		callingDes = 0;
		dirty = TRUE;
		selected = FALSE;
	}
	visited = TRUE;
}

void
frequencyAssignment::assignCW(BOOL tf)
{
	if( freqdisp[0] != 'c' ) {
		freqdisp[0] = 'c';
		dirty = TRUE;
		selected = FALSE;
	}
	if( fState == FREQDATA || fState == FREQCALL || fState == FREQHOLD || (fState == FREQCW && !tf) ) { 
		unassign();
	}
	if( tf ) {
		dirty = TRUE;
		fState = FREQCW; 
	}
	visited = TRUE;
        
}

void
frequencyAssignment::assignD()
{
	if( fState == FREQDATA) {
		visited = TRUE;
		return;
	}
	if( fState != FREQEMPTY ) {
		unassign();
	}
	// nothing to data channel
	freqdisp[1] = 'd';
	fState = FREQDATA;
	visited = TRUE;
	dirty = TRUE;
	selected = FALSE;
}
void 

frequencyAssignment::assign(designation *dest, designation *src)
{
	visited = TRUE;
	refreshFine = nowFine;
	if( fState == FREQHOLD ) {
		fState = FREQCALL;
		dirty = TRUE;
	}
	if( fState == FREQCALL && dest == destDes) {       
	
		// same group or target individual as before but possibly new caller
	
		if( src && callingDes != src ) {
			dirty = TRUE;
			callingDes = src;
		}
	} else if( fState == FREQCALL && src && src == destDes) { 
	
		// probably I-call and switched sides
		
		dirty = TRUE;
		callingDes = src;
		destDes = dest;
					
	} else {
		callingDes = src;
		destDes = dest; 
		freqdisp[2] = 'v';
		dirty = TRUE;
		fState = FREQCALL;
		selected = FALSE;
	}
	if( dirty ) {
		prty = 1000;
		if( destDes->getPrio() < prty) 
			prty = destDes->getPrio();
		if( callingDes && callingDes->getPrio() < prty )
			prty = callingDes->getPrio();
	}	
}

void drawBar(int rowNum, const char *lab)
{
	int lenT, lenL, lenR;
	lenT = strlen(lab);
	if( lenT >= 80 ) {
		sprintf(tempArea,"%-*.*s",80,80,lab);
	} else {
		lenL = (80 - lenT) / 2;
		lenR = 80 - (lenT + lenL);
		sprintf(tempArea,"%-*.*s%s%-*.*s",lenL,lenL,lineChars,lab,lenR,lenR,lineChars);
	}
	QuickOut(rowNum,1,GREEN,tempArea);
}

