#include <conio.h>
#include <dos.h>
#include <graph.h>
#include <afxcoll.h>
#include "colors.h"
#include "osw.h"
#include "designat.h"
#include "freqasg.h"
#include "trunksys.h"

unsigned long goodcount = 0;
unsigned long badcount = 0; 
unsigned short bitsAtZero;
unsigned short bitsAtOne;
volatile unsigned int cpstn = 0;	// current position in buffer
unsigned short fdata [BufLen + 1];	// warning don't make volatile!

extern ComPort *mySlicerPort;
extern Scanner *myScanner;

void docleanup()
{
	myScanner->shutDown ();
	delete mySlicerPort;
	delete myScanner;
	delete mySys;
	_setvideomode(_DEFAULTMODE);
}

//
// 					this is serial com port interrupt 
// we assume here that it only gets called when one of the status
// lines on the serial port changes (that's all you have hooked up).
// All this handler does is read the system timer (which increments
// every 840 nanoseconds) and stores it in the fdata array. The MSB
// is set to indicate whether the status line is zero. In this way
// the fdata array is continuously updated with the appropriate the
// length and polarity of each data pulse for further processing by
// the main program.
//
void far interrupt com1int (void)
{
  	static unsigned short ltick = 0;
  	unsigned short d1, d2,d3, tick, dtick;
 	static unsigned short lastbit = 0;

	//
  	// the system timer is a 16 bit counter whose value counts down
  	// from 65535 to zero and repeats ad nauseum. For those who really
  	// care, every time the count reaches zero the system timer
  	// interrupt is called (remember that thing that gets called every
  	// 55 milliseconds and does housekeeping such as checking the
  	// keyboard.
	//
  
	d3 = mySlicerPort->getMSR (); // get modem interrupt status

   bitsAtOne |= d3;
   bitsAtZero |= ~d3;

	//
 	// only compute data if CTS changed! other interrupts may be used some day.
	// get difference between current, last counter reading
	//
 	if ((lastbit & 0x10) != (d3 & 0x10)) // filter out impulse noise
 	{
		//
 		// by filtering out spurious CTS interrupts, we significantly improve the
 		// noise floor.  If the bit appears unchanged because it took a long time
 		// to handle the interrupt, the missed bit will be detected by error checks.
		//
		outportb (0x43, 0x00);       // latch counter until we read it
		d1 = inportb (0x40);         // get low count
		d2 = inportb (0x40);         // get high count
 		
		tick  = (d2 << 8) + d1;
		dtick = ltick - tick;
		ltick = tick;
		
		if (d3 & 0x10)	// read current value
			dtick = dtick & 0x7fff;	 
		else
			dtick = dtick | 0x8000; 
		
		//
		// put freq in fdata array
		//
		fdata [cpstn++] = dtick;

		//
		// make sure cpstn doesnt leave array 
		//
		if (cpstn > BufLen) 
			cpstn = 0;

		lastbit = d3;
	} 

	//
	//  Clear status bits in UART
	//
	d1 = mySlicerPort->getIIR ();	// clear IIR
	d1 = mySlicerPort->getLSR ();	// clear LSR
  	d1 = mySlicerPort->getMSR ();	// clear MSR
	
  	if (d1 & 0x01) 
  		d1 = mySlicerPort->getRBR ();	// clear RX - someday may process data

	//
	//  This sends non-specific End-Of-Interrupt to PIC
	//
  	outportb (0x20, 0x20);
}

//
//  set up the 8253 timer chip.  NOTE: ctr zero, the one we are using is 
//  incremented every 840nSec, is main system time keeper for dos set ctr 
//  0 to mode 2, binary this gives us the max count 
//
void 
set8253 ()                
{                              
  outportb (0x43, 0x34);      
  outportb (0x40, 0x00);       
  outportb (0x40, 0x00);
}

void
hardwareInit ()
{
  	atexit (docleanup);
	set8253 ();
}
