#include "comport.h"

class frequencyAssignment;

class Scanner 
{
	frequencyAssignment *lp;
	ComPort *myPort;

public:
	int volume;
	int squelch;

	Scanner ();

	ComPort *getComPort (void) {return (myPort);}
	void setComPort (ComPort *comport, double baudrate = 9600.0);
	void topIs (frequencyAssignment* fp);

	void putStringN (const int len, const char *cp)
	{
		int i;

		if (myPort && len)
			for (i = 0; i < len; i++)
				myPort->txChar (*cp++);
	}

	void putString (const char *cp)
	{
		volatile long i;

		if (myPort)
			while (*cp) 
				myPort->txChar (*cp++);

		for (i = 0; i < 0x10000; i++)
			myPort->rxStatus ();
	}

	virtual void setFreqString (frequencyAssignment *) = 0;
	virtual void setVolume (int volume) {}
	virtual void setSquelch (int squelch) {}
	virtual void shutDown (void) {}
};

class PCR1000 : public Scanner 
{
public: 
	PCR1000 (ComPort *comport, double baudrate = 38400.0);
	void setFreqString (frequencyAssignment *f);
	void setVolume (int volume);
	void setSquelch (int squelch);
	void shutDown (void);
};

class R10 : public Scanner 
{
public: 
	R10 (ComPort *comport, double baudrate = 9600.0);
	void setFreqString (frequencyAssignment *f);
};

class R8500 : public Scanner 
{
public: 
	R8500 (ComPort *comport, double baudrate = 9600.0);
	void setFreqString (frequencyAssignment *f);
};

class R7100 : public Scanner 
{
public: 
	R7100 (ComPort *comport, double baudrate = 9600.0);
	void setFreqString (frequencyAssignment *f);
};

class R7000 : public Scanner 
{
public: 
	R7000 (ComPort *comport, double baudrate = 9600.0);
	void setFreqString (frequencyAssignment *f);
};

class AR8000: public Scanner 
{
public: 
	AR8000 (ComPort *comport, double baudrate = 9600.0);
	void setFreqString (frequencyAssignment *f);
};

class AR3000 : public Scanner 
{
public: 
	AR3000 (ComPort *comport, double baudrate = 4800.0);
	void setFreqString (frequencyAssignment *f);
};

class AR3000A : public Scanner 
{
public: 
	AR3000A (ComPort *comport, double baudrate = 9600.0);
	void setFreqString (frequencyAssignment *f);
};

class AR2700 : public Scanner 
{
public: 
	AR2700 (ComPort *comport, double baudrate = 4800.0);
	void setFreqString (frequencyAssignment *f);
};

class Kenwood : public Scanner 
{
public: 
	Kenwood (ComPort *comport, double baudrate = 4800.00);
	void setFreqString (frequencyAssignment *f);
};

class BC895 : public Scanner 
{
public: 
	BC895 (ComPort *comport, double baudrate = 9600.0);
	virtual void setFreqString (frequencyAssignment *f);
};

class NOSCANNER : public Scanner 
{
public:
	NOSCANNER ();
	void setFreqString (frequencyAssignment *f);
};
