#include <conio.h>
#include <string.h>
#include <dos.h>
#include <graph.h>
#include <afxcoll.h>
#include "colors.h"
#include "osw.h"
#include "designat.h"
#include "freqasg.h"
#include "comport.h"
#include "trunksys.h"

char *sysType = "unknown";
TrunkSys *mySys = 0;
int mySite = -1;
time_t now, nowFine;
char tempArea [512];
unsigned short nsysId = 0, sysId = 0, cwFreq = 0;
long theDelay = DELAY_ON;
BOOL Verbose = TRUE;
BOOL seekNew = FALSE;
BOOL inSync = FALSE;
BOOL showFrameSync = FALSE; 
unsigned long stackOverFlows = 0L;
unsigned long wrapArounds = 0L;
Scanner *myScanner = 0;
ComPort *mySlicerPort = 0;
BOOL slicerInverting = FALSE;
extern void far interrupt com1int (void);

//
//	 Items read from environment variables
//
char scanTypeEnv [64];
char scanBaudEnv [64];
char scanPortEnv [64];
char slicerPortEnv [64];
char slicerModeEnv [64];

unsigned short actualRows;
unsigned short numIdles;

/* NOTE: this program started from an 'anonymous' post to a usenet group of some source code
	for displaying information about trunked Motorola radio systems. It has been converted to
	Visual C++ for version 1.52C, and significantly evolved. The original comments are maintained
	in the next comment block for historical purposes.
				anon
*/
/*--------------------------------------------------------------------*/
/*																	   */
/*	  This programs displays some of the most important data sent over */
/*	  a Motorola trunked radio system control channel.				   */
/*	  Right now it expects an interface described in the above text	   */
/*	  to sit at COM1												   */
/*	  If you want improvements you have to do them yourself.		   */
/*																	   */
/*	  This is not be used by anyone for any monetary gain. If you do   */
/*	  we hope Motorola's lawyers will crush the life out of you.	   */
/*																	   */
/*	  Complaints? Remember - you get what you paid for. And you didn't */
/*	  pay a cent for this program.									   */
/*																	   */
/*	  Still got Complaints? Well here are our canned responses:		   */
/*																	   */
/*		  - The code is the comment									   */
/*		  - What do you expect? I work for Microsoft				   */
/*		  - Cheesiest is easiest									   */
/*		  - I'll put the comments in later							   */
/*		  - If it was hard to write it should be hard to read		   */
/*		  - Go ahead and try to find me								   */
/*		  - Rember - you always have a fiend in Jesus				   */
/*																	   */
/*--------------------------------------------------------------------*/
/*																	   */
/* port info  :  COM1								  if dlab bit =1   */
/*		 0x3f8 : receive/transmit data					   baud0	   */
/*		 0x3f9 : interrupt enable register	   - IER	   baud1	   */
/*		 0x3fa : interrupt identifier register - IIR				   */
/*		 0x3fb : line control register		   - LCR				   */
/*		 0x3fc : modem control register		   - MCR				   */
/*		 0x3fd : line status register		   - LSR				   */
/*		 0x3fe : modem status register		   - MSR				   */
/*																	   */
/*--------------------------------------------------------------------*/
/*																	   */
/* PORT INFO  : 8259 INTERRUPT CONTROLLER							   */
/*		 0X021 : A CORRESPONDING LOW BIT ENABLES A SPECIFIC INTERRUPT  */
/*				 COM1 IS IRQ4, AND THEREFORE CONTROLLED BY BIT 0X10	   */
/*		 0X020 : WHENEVER AN INTERRUPT IS RESOLVED, A 0X20 SHOULD BE   */
/*				 PORTED OUT HERE TO GENERATE AN END OF INTERRUPT	   */
/*				 SIGNAL.											   */
/*																	   */
/*--------------------------------------------------------------------*/

/* global variables */

//
// output buffer for packet before being sent to screen 
//
char ob [100];

struct osw_stru
{
  unsigned short cmd;
  unsigned short id;
  char grp;
};

volatile BOOL InSync = FALSE;

static enum 
{
	Identifying,
	GettingOldId,
	OperNewer,
	OperOlder
} osw_state = Identifying;

static Filter filterCmd (4);
static Filter filterSysId (3);
static struct osw_stru stack [5];
static int numStacked = 0;
static int numConsumed = 0;
static numOKinRow = 0;

static void
noteOlderType ()
{
	if( mySys ) {
		mySys->unsafe();
		delete mySys;
		mySys = 0;
	}
	sysType = "Single Site (Old)";
	mySite = -1;
	osw_state = GettingOldId;
}

inline void 
noteIdentifier (unsigned short possibleId, BOOL isOld)
{
	if(filterSysId.filter(possibleId) == possibleId) {
		if( possibleId != sysId && mySys) {
			mySys->unsafe();
			delete mySys;
			mySys = 0;
			sysType = "unknown";
			mySite = -1;
		}
		if(mySys) {
			mySys->endScan(); // take opportunity to age assignments
		} else {
			sysId = possibleId;
			mySys = new TrunkSys(sysId, myScanner);
			if( !mySys ) {
				printf("cannot alloc TrunkSys objects\n");
				exit(1);
			}
			osw_state = isOld ? OperOlder : OperNewer;
		}
	}
}

void inline
show_bad_osw ()
{
	//	
	// clear out work in progress...
	//	
	numStacked = 0;
	numConsumed = 0;
	numOKinRow = 0;
	filterCmd.filter (0);
}

void inline
show_good_osw (register struct osw_stru* Inposw)
{
	unsigned short fcmd;

	//
	// fine grain counter = #osw's = 90hz
	//
	++nowFine;				

	//
	// about 6x/sec + at scan marker
	//
	if (mySys && !(nowFine & 15)) 
		mySys->endScan();

	++numOKinRow;
	 
	// maintain a sliding stack of 5 OSWs. If previous iteration used more than one,
	// don't touch stack until all used ones have slid past.
	 
	switch (numStacked)
	{
		case 5 :
		case 4 :
			stack [4] = stack [3];
		case 3 :
			stack [3] = stack [2];
		case 2 :
			stack [2] = stack [1];
		case 1 :
			stack [1] = stack [0];
	 	case 0 :
			stack [0] = *Inposw;
	}

	if (numStacked < 5)
		++numStacked;

	if (numConsumed > 0) 
		--numConsumed;

	//
	// at least need a window of 3 and 5 is better.
	//
	if (numConsumed || numStacked < 3)
		return; 
		
	fcmd = filterCmd.filter(stack[2].cmd);
	 
	//
	// look for some larger patterns first... parts of the sequences could be
	// mis-interpreted if taken out of context.
	//
	if (stack [2].cmd == 0x308) 
	{
		//
		// long stream of non-identity data, assume un-numbered...
		//
		if (numOKinRow > 60 && (osw_state == Identifying || osw_state == OperNewer)) 
			noteOlderType();

		if (stack [1].cmd == 0x30b)
		{
			//
			// one of two possible identity sequences...
			//
			if (isFrequency (stack [0].cmd))
			{
				// non-smartzone identity:
				//		<sysid>				 x	 308
				//		<001010><ffffffffff> x	 30b
				//		1Fxx				 x	 <freq>
				// 
				if (((stack[0].id & 0xff00) == 0x1F00) && ((stack[1].id & 0xfc00) == 0x2800)) 
				{
					numOKinRow = 0;
					noteIdentifier (stack [2].id, FALSE);
					if (mySys)
						mySys->noteDataChan(stack[0].cmd);
				}
				numConsumed = 3; // we used up all 3
				return;
			}
			else if ((stack[1].id & 0xfc00) == 0x2800)	 
			{
				// smartzone identity:
				//		<sysid>				 x	 308
				//		<001010><ffffffffff> x	 30b
				// 
				numOKinRow = 0;
				noteIdentifier (stack [2].id, FALSE);
				if (mySys)
					mySys->noteDataChan (stack [1].id & 0x03ff);
			} 
			else 
			{
				//
				// evidence of smartzone, but can't use this pair for id
				//
				if (mySys)
					sysType = "Networkable";
			}
			numConsumed = 2;
			return; 
		}

		if (stack [1].cmd == 0x320 && stack [0].cmd == 0x30b)
		{
			//
			// definitely smart-zone
			//
			if (mySys)
				sysType = "Networkable";
			numConsumed = 3;
			return;		
		}

		if (mySys)
		{
			if (stack [1].cmd == 0x0310) 
				mySys->note_affiliation (stack [2].id, stack [1].id);
			else if (stack [1].cmd == 0x0319)
				mySys->note_page (stack [2].id, stack [1].id);
			else if (isFrequency (stack [1].cmd)) 
			{
				// handle type II call
				mySys->note_freq_assignment (stack [1].cmd,
					stack [1].grp,
					stack [1].id,
					stack [2].id);
			}  // otherwise 'busy', others...
		}
		numConsumed = 2;
		return;
	}

	//
	// another configuration seen in London, U.K. in 4-500mhz range
	//
	if (stack [1].cmd == 0x0320 && stack [0].cmd == 0x030b && isFrequency (stack [2].cmd)) 
	{
		numOKinRow = 0;
		noteIdentifier (stack [2].id, FALSE);
		if (osw_state == OperNewer)
			sysType = "Networkable";
		numConsumed = 3;
		return;		
	}	 

	switch (stack[2].cmd)
	{		
		//
		// system status.  not an old type one if get these
		//
		case 0x3c0 : 
		case 0x3bf :
			numOKinRow = 0;
			break;
	  
		//		
		// scan marker
		//
		case 0x32b : 
			numOKinRow = 0;
			noteIdentifier (stack [2].id, FALSE);
			if (osw_state == OperNewer)
			{
				sysType = "Single or Multicast";
				mySite = -1;
			}
			break;

		//
		// idle word - normally ignore but may indicate transition into
		// un-numbered system or out of numbered system
		//
		case 0x2f8 : 
			if (fcmd == 0x2f8)
				if (osw_state == Identifying || osw_state == OperNewer)
					noteOlderType();
			break;

		//
		// diagnostic: cw On, Off
		//
		case 0x3a0 : 
			if (mySys)
			{
				cwFreq = stack [2].id & 0x3ff;
				mySys->noteCwId (cwFreq, stack[2].id & 0x1000);
			}
			break;

		default :
			//
			// long stream of non-identity data, assume un-numbered...
			//
			if (numOKinRow > 60 && (osw_state == Identifying || osw_state == OperNewer)) 
				noteOlderType();
			else 
			{
				if (mySys)
				{
					//
					// this is the most frequent case that actually touches things....
					//
					if (isFrequency (stack [2].cmd) && numStacked > 3)
					{
						//
						// bare assignment.  this is still a little iffy...
						//
						if ((stack [2].id & 0xff00) == 0x1f00) 
						{
							if (osw_state == OperOlder) 
							{
								noteIdentifier(stack[2].id,TRUE);
								if (mySys) 
									mySys->noteDataChan (stack [2].cmd);
							}	
						} 
						else
						{
							mySys->note_freq_assignment (stack [2].cmd,
								stack[2].grp,
								stack[2].id,
								0);
						}
					}
					else if (stack [2].cmd >= 0x360 && stack [2].cmd <= 0x394)
					{
						//
						// Site ID
						//
						mySite = stack [2].cmd - 0x360;
						mySys->note_site (mySite);
					}
				}
				else if (osw_state == GettingOldId)
				{
					if (isFrequency (stack [2].cmd) && ((stack [2].id & 0xff00) == 0x1f00))
					{ 
						noteIdentifier (stack [2].id,TRUE);
						noteIdentifier (stack [2].id,TRUE);
					}
				}
			}
			break;
	}

	numConsumed = 1;
	return;
}

//
// process de-interleaved incoming data stream 
// inputs: -1 resets this routine in prepartion for a new OSW		 
//			0 zero bit												 
//	        1 one bit												
// once an OSW is received it will be placed into the buffer bosw[] 
// bosw[0] is the most recent entry					
//
void 
inline proc_osw (int sl)
{
	register int l;
	int sr, sax, f1, f2, iid, cmd, neb;
  	static int ct;
  	static char osw [50], gob [100];
  	static struct osw_stru bosw;

  	if (sl == -1) 
		ct = 0;
  	else
  	{
	 	gob [ct] = sl;
	 	ct++;

	   	if (ct == 76)
	   	{
			sr = 0x036E;
			sax = 0x0393;
			neb = 0;

			//
			// run through convolutional error correction routine 
			// Reference : US PATENT # 4055832			  
			//
			for (l = 0; l < 76; l += 2)
			{
	  			osw [l >> 1] = gob [l];	// osw gets the DATA bits

	  			if (gob [l])		// gob becomes the syndrome 
				{
					gob [l]     ^= 0x01;
					gob [l + 1] ^= 0x01;
					gob [l + 3] ^= 0x01;
	  			}
			}

			//
			//  Now correct errors
			//
			for (l = 0; l < 76; l += 2)	
			{
	  			if ((gob [l + 1]) && (gob [l + 3]))
	  			{
					osw [l >> 1] ^= 0x01;
					gob [l + 1]  ^= 0x01;
					gob [l + 3]  ^= 0x01;
	  			}
			}

			//
			//  Run through error detection routine 
			//
			for (l = 0; l < 27; l++)
			{
	  			if (sr & 0x01) 
					sr = (sr >> 1) ^ 0x0225; 
				else 
					sr = sr >> 1;

	  			if (osw [l]) 
					sax = sax ^ sr;
			}

			for (l = 0; l < 10; l++)
			{
				f1 = (osw [36 - l]) ? 0 : 1;
				f2 = sax & 0x01;

	  			sax = sax >> 1;

				//
				// neb counts # of wrong bits
				//
	  			if (f1 != f2) 
					neb++;
			}


			//
			// if no errors - OSW received properly; process it 
			//
			if (neb == 0)
			{
	  			for (iid = 0, l = 0; l < 16; l++)
	  			{
					iid = iid << 1;

					if (!osw [l]) 
						iid++;
	  			}

	  			bosw.id = iid ^ 0x33c7;
				bosw.grp = osw [16] ^ 0x01;

	  			for (cmd = 0, l = 17; l < 27; l++)
	  			{
					cmd = cmd << 1;

					if (!osw [l]) 
						cmd++;
	  			}

	  			bosw.cmd = cmd ^ 0x032a;
		   		++goodcount;

	  			show_good_osw (&bosw);
			}
			else 
			{   
				++badcount;
				show_bad_osw ();
			}
		}
	}
}

//
// de-interleave OSW stored in array ob[] and process 
//
void inline 
pigout (int skipover)	
{
	register int i1, i2;

	proc_osw (-1);

	for (i1 = 0; i1 < 19; i1++)
		for (i2 = 0; i2 < 4; i2++)
			proc_osw ((int) ob [((i2 * 19) + i1) + skipover]);
}

//
//	 this routine looks for the frame sync and splits off the 76 bit
// data frame and sends it on for further processing				
//
void inline 
frame_sync (char gin)
{
  	static int sr = 0;
	static int fs = 0xac;
	static int bs = 0;

	//
  	// keep up 8 bit sliding register for sync checking purposes
	//
  	sr = (sr << 1) & 0xff;

  	if (gin) 
		sr = sr | 0x01;

  	ob [bs - 1] = gin;

	//
  	//  If sync seq and enough bits are found - data block
	//
	if ((sr == fs) && (bs > 83))
	{
		//
		//  The original code didn't handle excess bits at beginning.  Not
		//  sure it will make much difference, but I send the last 84 bits
		//  out, not the first 84 bits.  The latest frame is stored in array 
		//  ob [].
		//
		pigout (bs - 84);  
		bs = 0;
		InSync = TRUE;
	}

	if (bs < 98)
	{
		//
		//  After lots of garbage, this will show up as a error frame, but
		//  future ones will be 'in sync'
		//
		++bs;
	}
	else
	{
		//
		//  High-precision receiver status
		//
		InSync = FALSE; 
	}
}

//
//	 Tell the user how the command line works
//
void 
syntax ()
{
	printf ("\n");
	printf ("TRUNK.EXE has no arguments.  All parameters are passed via environment\n");
	printf ("\tvariables.\n\n");
	printf ("Set TRACKSCAN to:\n");
	printf ("\tPCR1000\t\t38400 bps\n");
	printf ("\tR10\t\t9600 bps\n");
	printf ("\tR7000\t\t9600 bps\n");
	printf ("\tR7100\t\t9600 bps\n");
	printf ("\tR8500\t\t9600 bps\n");
	printf ("\tAR8000\t\t9600 bps CR mode\n");
	printf ("\tAR2700\t\t4800 bps\n");
	printf ("\tAR3000\t\t4800 bps\n");
	printf ("\tAR3000A\t\t9600 bps\n");
	printf ("\tKENWOOD\t\t4800 bps\n");
	printf ("\tKENWOOD9600\t9600 bps\n");
	printf ("\tBC895\t\t9600 bps\n");
	printf ("\tNONE\n");
	printf ("\n");
	printf ("Set TRACKSCANPORT to:\n");
	printf ("\tCOM1\t(port 0x3f8, IRQ 4)\n");
	printf ("\tCOM2\t(port 0x2f8, IRQ 3)\n");
	printf ("\tCOM3\t(port 0x3e8, IRQ 4)\n");
	printf ("\tCOM4\t(port 0x2e8, IRQ 3)\n");
	printf ("\n");
	printf ("Set TRACKSCANBAUD to:\n");
	printf ("\t300\n");
	printf ("\t1200\n");
	printf ("\t2400\n");
	printf ("\t4800\n");
	printf ("\t9600\n");
	printf ("\t19200\n");
	printf ("\t38400\n");
	printf ("\t57600\n");
	printf ("\t115200\n");
	printf ("\n");
	printf ("Set TRACKSLICERPORT to:\n");
	printf ("\tCOM1\t(port 0x3f8, IRQ 4)\n");
	printf ("\tCOM2\t(port 0x2f8, IRQ 3)\n");
	printf ("\tCOM3\t(port 0x3e8, IRQ 4)\n");
	printf ("\tCOM4\t(port 0x2e8, IRQ 3)\n");
	printf ("\n");
	printf ("Set TRACKSLICERMODE to:\n");
	printf ("\tNORMAL\tInverting not required\n");
	printf ("\tINVERT\tInverting required\n");
	printf ("\n");
	printf ("Set TRACKSCANBAUD only if you need/want to override the default baud rate.\n");
	printf ("Some scanners support only one baud rate, while others (such as the R7000)\n");
	printf ("can be set via switches.  Other scanners, such as the PCR-1000 can be run\n");
	printf ("at different baud rates via serial commands\n");
	printf ("\n");
	printf ("Depending on the scanner and slicer combination, you may or may not be\n");
	printf ("able to use the same COM port for both.  The largest determining factor\n");
	printf ("will be DTR requirements.  The slicer requires DTR low, while scanners\n");
	printf ("like the PCR1000 require DTR high.\n");
	printf ("\nhit return to exit");

	getchar ();
	exit (1);
}

//
//	 Initialize the video to 43 line mode, set flags
//
void 
vidInit ()
{
	actualRows = _setvideomoderows (_DEFAULTMODE,43);

	if (actualRows == 0) 
	{
		printf ("Failed to set video modes.\n");
		exit (1);
	}

	if (actualRows != 43) 
	{
		printf ("need 43 row mode!\n");
		exit (2);
	}

	_settextcursor ((short) 0x2000);
	_wrapon (_GWRAPOFF);
}

//
//	 Read the environment variables to configure the scanner type and 
//	 COM port
//
void 
scanInit ()
{
	long baudRate;
	const char *scannerPortEnvPtr;
	const char *scannerBaudEnvPtr;
	const char *scannerTypeEnvPtr;
	ComPort *myScannerPort = 0;

	//
	//	Figure out what COM port the scanner is attached to.  If the
	//	TRACKSCANPORT variable isn't set, default to COM1
	//
	scannerPortEnvPtr = getenv ("TRACKSCANPORT");

	if (scannerPortEnvPtr && *scannerPortEnvPtr)
	{
		strcpy (scanPortEnv, scannerPortEnvPtr);
		strupr (scanPortEnv);

		//
		//	If user used COMx: instead of COMx, perform a colonectomy
		//
		if (strchr (scanPortEnv, ':'))
			*strchr (scanPortEnv, ':') = '\0';

		if (!strcmp (scanPortEnv, "COM1"))
			myScannerPort = new ComPort (COM1);
		else if (!strcmp (scanPortEnv, "COM2"))
			myScannerPort = new ComPort (COM2);
		else if (!strcmp (scanPortEnv, "COM3"))
			myScannerPort = new ComPort (COM3);
		else if (!strcmp (scanPortEnv, "COM4"))
			myScannerPort = new ComPort (COM4);
		else
		{
			strcpy (scanPortEnv, "None");
			myScannerPort = new ComPort (NONE);
		}
	}
	else
	{
		strcpy (scanPortEnv, "COM1");
		myScannerPort = new ComPort (COM1);
	}

	//
	//  See if the user overrode the default baud rate.  We only accept valid
	//  baud rates.
	//
	scannerBaudEnvPtr = getenv ("TRACKSCANBAUD");

	if (scannerBaudEnvPtr && *scannerBaudEnvPtr)
	{
		baudRate = atol (scannerBaudEnvPtr);

		switch (baudRate)
		{
			case 300 :
			case 1200 :
			case 2400 : 
			case 4800 : 
			case 9600 : 
			case 19200 : 
			case 38400 : 
			case 57600 :
			case 115200 :
				sprintf (scanBaudEnv, "%l", baudRate);
				break;

			default :
				baudRate = 0;
				strcpy (scanBaudEnv, "Default");
				break;
		}
	}
	else
		baudRate = 0;

	//
	//	Now figure out what kind of scanner we have.  (We cheat for the R7100,
	//  since it's just a newer R7000).
	//
	scannerTypeEnvPtr = getenv ("TRACKSCAN");

	if (scannerTypeEnvPtr && *scannerTypeEnvPtr)
	{
		strcpy (scanTypeEnv, scannerTypeEnvPtr);
		strupr (scanTypeEnv);

		if (!strcmp (scanTypeEnv, "PCR1000"))
		{
			if (!baudRate)
				myScanner = new PCR1000 (myScannerPort);
			else
				myScanner = new PCR1000 (myScannerPort, (double) baudRate);
		}
		else if (!strcmp(scanTypeEnv, "R10"))
		{
			if (!baudRate)
				myScanner = new R10 (myScannerPort);
			else
				myScanner = new R10 (myScannerPort, (double) baudRate);
		}
		else if (!strcmp(scanTypeEnv, "R8500"))
		{
			if (!baudRate)
				myScanner = new R8500 (myScannerPort);
			else
				myScanner = new R8500 (myScannerPort, (double) baudRate);
		}
		else if (!strcmp(scanTypeEnv, "R7100"))
		{
			if (!baudRate)
				myScanner = new R7100 (myScannerPort);
			else
				myScanner = new R7100 (myScannerPort, (double) baudRate);
		}
		else if (!strcmp(scanTypeEnv, "R7000"))
		{
			if (!baudRate)
				myScanner = new R7000 (myScannerPort);
			else
				myScanner = new R7000 (myScannerPort, (double) baudRate);
		}
		else if (!strcmp(scanTypeEnv, "AR8000"))
		{
			if (!baudRate)
				myScanner = new AR8000 (myScannerPort);
			else
				myScanner = new AR8000 (myScannerPort, (double) baudRate);
		}
		else if (!strcmp(scanTypeEnv, "AR2700") )
		{
			if (!baudRate)
				myScanner = new AR2700 (myScannerPort);
			else
				myScanner = new AR2700 (myScannerPort, (double) baudRate);
		}
		else if (!strcmp(scanTypeEnv, "AR3000A"))
		{
			if (!baudRate)
				myScanner = new AR3000A (myScannerPort);
			else
				myScanner = new AR3000A (myScannerPort, (double) baudRate);
		}
		else if (!strcmp(scanTypeEnv, "AR3000"))
		{
			if (!baudRate)
				myScanner = new AR3000 (myScannerPort);
			else
				myScanner = new AR3000 (myScannerPort, (double) baudRate);
		}
		else if (!strcmp(scanTypeEnv, "KENWOOD"))
		{
			if (!baudRate)
				myScanner = new Kenwood (myScannerPort);
			else
				myScanner = new Kenwood (myScannerPort, (double) baudRate);
		}
		else if (!strcmp(scanTypeEnv, "KENWOOD9600"))
		{
			if (!baudRate)
				myScanner = new Kenwood (myScannerPort, 9600.00);
			else
				myScanner = new Kenwood (myScannerPort, (double) baudRate);
		}
		else if (!strcmp(scanTypeEnv, "BC895"))
		{
			if (!baudRate)
				myScanner = new BC895 (myScannerPort);
			else
				myScanner = new BC895 (myScannerPort, (double) baudRate);
		}
		else if (!strcmp(scanTypeEnv, "NONE"))
		{
			strcpy (scanTypeEnv, "None");
			myScanner = new NOSCANNER;
		} else 
			strcpy (scanTypeEnv, "Unknown");
	}

	//
	//	Default to AR8000 if no TRACKSCAN variable, or it's unrecognized
	//
	if (!myScanner) 
	{
		strcpy (scanTypeEnv, "AR8000");
		if (!baudRate)
			myScanner = new AR8000 (myScannerPort);
		else
			myScanner = new AR8000 (myScannerPort, (double) baudRate);
	}

	//
	//	Panic if we can't create objects
	//
	if (!myScanner) 
	{
		printf ("Could not create scanner object");
		exit (1);
	}

	if (!myScannerPort)
	{
		printf ("Could not create comport object");
		exit (1);
	}
}

//
//	 Read the TRACKSLICERPORT and TRACKSLICERMODE variables
//
void
slicerInit ()
{
	const char *slicerPortEnvPtr;
	const char *slicerModeEnvPtr;

	//
	//	Figure out what COM port the slicer is attached to.	 If the
	//	TRACKSLICERPORT variable isn't set, default to COM1
	//
	slicerModeEnvPtr = getenv ("TRACKSLICERPORT");

	if (slicerModeEnvPtr && *slicerModeEnvPtr)
	{
		strcpy (slicerPortEnv, slicerModeEnvPtr);
		strupr (slicerPortEnv);

		//
		//	If user used COMx: instead of COMx, perform a colonectomy
		//
		if (strchr (slicerPortEnv, ':'))
			*strchr (slicerPortEnv, ':') = '\0';

		if (!strcmp (slicerPortEnv, "COM1"))
			mySlicerPort = new ComPort (COM1);
		else if (!strcmp (slicerPortEnv, "COM2"))
			mySlicerPort = new ComPort (COM2);
		else if (!strcmp (slicerPortEnv, "COM3"))
			mySlicerPort = new ComPort (COM3);
		else if (!strcmp (slicerPortEnv, "COM4"))
			mySlicerPort = new ComPort (COM4);
		else
		{
			strcpy (slicerPortEnv, "None");
			mySlicerPort = new ComPort (NONE);
		}
	}
	else
	{
		strcpy (slicerPortEnv, "COM1");
		mySlicerPort = new ComPort (COM1);
	}

	//
	//	Now figure out slicer runs in normal or inverting mode
	//
	slicerModeEnvPtr = getenv ("TRACKSLICERMODE");

	if (slicerModeEnvPtr && *slicerModeEnvPtr)
	{
		strcpy (slicerModeEnv, slicerModeEnvPtr);
		strupr (slicerModeEnv);

		if (!strcmp (slicerModeEnv, "NORMAL"))
			slicerInverting = FALSE;
		else if (!strcmp(slicerModeEnv, "INVERT"))
			slicerInverting = TRUE;
		else
		{
			strcpy (slicerModeEnv, "FALSE");
			slicerInverting = FALSE;
		}
	}
	else
	{
		strcpy (slicerModeEnv, "FALSE");
		slicerInverting = FALSE;
	}

	//
	//	Panic if we can't create objects
	//
	if (!mySlicerPort)
	{
		printf ("Could not create slicer object");
		exit (1);
	}

	if (mySlicerPort->getPort () != NONE)
	{
		mySlicerPort->setHandler (com1int);
		mySlicerPort->setDTR (DTR_LOW);
		mySlicerPort->setRTS (RTS_HIGH);
		mySlicerPort->setInterrupts (IER_EDSSI);
		mySlicerPort->setInterruptsGlobal (INT_ENABLED);
	}
}

void
periodic ()
{
	static int winCtr = 0;

	if (mySys) 
	{
		if (++winCtr >= 5)
		{
			mySys->flushFreqs (); 
			winCtr = 0;
		}
		_settextcolor (WHITE);
		_settextposition (STATROW + 1, 19);
		_outtext (mySys->sysType ());
	}
	stats (scanTypeEnv);
}

int
main (int argc, char **argv)
{
	char dataBit;
	unsigned short passCounter = 0;
	unsigned int overflowCounter;
	unsigned int i = 0;
	const double ticksPerBit = 1.0 / (3600.0 * 838.8e-9);
	const double ticksPerBitOver2 = (1.0 / (3600.0 * 838.8e-9)) * 0.5;
	double exc = 0.0;
	double accumulatedClock = 0.0;
	double fastBoundaryCompare;

	if (argc > 1) 
	{
		syntax ();
	}

	vidInit ();																				
	scanInit ();
	slicerInit ();
	showPrompt ();

	//
	//	Create the TrunkSys object, default to system ID of 1234 until we
	//	figure out what we're really listening to.
	//
	mySys = new TrunkSys (0x1234, myScanner);

	//
	//	Setup timer mode, and the exit cleanup function.
	//
	hardwareInit ();	

	//
	//	Core loop that makes this thing work
	//
	for (;;)
	{
		time (&now);	// per-event time

		for (overflowCounter = BufLen; i != cpstn; --overflowCounter)
		{
			//
			//  We never caught up to the input side during loop, drop around 
			//  and note that we are in trouble.
			//
			if (overflowCounter == 0) 
			{
				++wrapArounds;
				break;
			}		

			//
			//  dataBit becomes the data bit, being either 0 or 1.
			//
			if (!slicerInverting)
				dataBit = (fdata [i] & 0x8000) ? 0 : 1;
			else
				dataBit = (fdata [i] & 0x8000) ? 1 : 0;

			//
			//	Add in new number of cycles to clock  
			//
			accumulatedClock += (fdata [i] & 0x7fff);

			//
			//  Send raw bit stream to first processing routine.  Since we're
			//  in a while loop, wer assigned the math to a temporary variable,
			//  so we're not recalculating everytime.
			//
			fastBoundaryCompare = exc + ticksPerBitOver2;

			while (accumulatedClock >= fastBoundaryCompare)
			{
				frame_sync (dataBit);	  
				accumulatedClock -= ticksPerBit;
			}

			//
			//  PHASE LOCK LOOP ALGORITHM!
			//
			//  accumulatedClock now holds new boundary position. update exc slowly...
			//  0.005 sucks; 0.02 better; 0.06 mayber even better; 0.05 seems pretty good
			//
			exc += (0.025 * (accumulatedClock - exc));
			
			if (++i > BufLen) 
				i = 0;
		}

		//
		//	Every 32768 times?
		//
		if ((passCounter++ << 1) == 0) 
		{
			periodic ();
		}

		//
		//	Every eighth time
		//
		if (showFrameSync && !(passCounter & 0x007)) 
		{ 
			static BOOL syncState = FALSE;

			if (InSync != syncState) 
			{
				if (syncState)
					syncState = FALSE;
				else
					syncState = TRUE;

				gotoxy (52, STATROW);
				_settextcolor (WHITE);
				_outtext (syncState ? "@" : "_");
			}
		}		

		//
		//	If user typed any keys, process them
		//
		if (kbhit ()) 
		{
			doKeyEvt ();
		}
	}

	return (0);
}

void
debugSystem (void)
{
	_setvideomode(_DEFAULTMODE);

	printf ("scanTypeEnv = %s\n", scanTypeEnv);
	printf ("scanPortEnv = %s\n", scanPortEnv);
	printf ("slicerPortEnv = %s\n", slicerPortEnv);
	printf ("slicerModeEnv = %s\n", slicerModeEnv);
	mySlicerPort->dump ("Slicer Port");
	myScanner->getComPort ()->dump ("Scanner Port");
	getchar ();
}
