#include <conio.h>
#include <dos.h>
#include <graph.h>
#include <afxcoll.h>
#include "colors.h"
#include "osw.h"
#include "designat.h"
#include "freqasg.h"
#include "trunksys.h"
#include "bios.h"

static char tempArea[500];

freqList::freqList(const char * fn, int& naid, const char *tl ) :
	sysName(0)
{
	if( tl )
		sysName = strdup(tl);
	aid = new frequencyAssignment[MAXFREQS+2]; // allocate a block of frequency structures
	if( !aid ) {
		printf("cannot alloc assignment objects\n");
		exit(1);
	}
	naid = 0;
	savenaid = &naid; 		
	register FILE *fp = fopen(fn,"rt");
	if( fp ) {
		if(fgets(tempArea,sizeof(tempArea),fp)) {  // gets
			register frequencyAssignment *f = aid;
			register char *sep;
			sep = strchr(tempArea,'\n');
			if(sep)
				*sep = '\0'; // null out newline if there...
			sep = strchr(tempArea,'\r');
			if(sep)
				*sep = '\0'; // null out return if there...
			if(tempArea[0]) {
				if(sysName)
					free(sysName);
				sysName = strdup(tempArea);
			} 
			unsigned short ifnum;
			while( fgets(tempArea,sizeof(tempArea),fp) ) {
				sep = strchr(tempArea,',');
				if(!sep)
					continue;
				if( sscanf(sep+1,"%4hx",&ifnum)!=1)
					continue;
				f->create(naid,ifnum,&tempArea[3]);
				strncpy(&f->freqdisp[0], tempArea,3); //copy tags c,d,v
				f->show();
				++naid; ++f;
			}
		}
		fclose(fp);
	}
	if(!sysName) {
		sysName = strdup("UnNamed System");
	}
}

void
freqList::doSave(const char *tfn)
{
	if(*savenaid > 0) {
		(void) unlink(tfn);
		register FILE *fp = fopen(tfn,"wt");
		if( fp ) {
			register frequencyAssignment *f;
			register int i;
			fprintf(fp,"%s\n",sysName);
			for(i = 0, f = aid; i < *savenaid; ++i, ++f) {
				if( f->freqdisp[0] != ' ' ||
				    f->freqdisp[1] != ' ' ||
				    f->freqdisp[2] != ' ' ) {
					fprintf(fp,"%s,%hx\n",
						f->freqdisp,f->freqNum);
				}
			}
			fclose(fp);
		}
	} 
}

freqList::~freqList() {
	register int i;
	delete [] aid;
	free((void*)sysName);
	_settextcolor(WHITE);
	sprintf(tempArea,"%-*.*s",80,80,"");
	for( i = 0; i < MAXFREQS; ++i) {
		_settextposition(FREQROW+3+i,1);		
		_outtext(tempArea);
	}
}

TrunkSys::TrunkSys(unsigned short nid, Scanner *sp) :
	 cw(0),doAuto(TRUE),myScanner(sp),siteId(-1), fSite(3)
{
	sprintf(sysPrefix,"%.4hx",nid);
	this->init();
}

TrunkSys::TrunkSys(const char *str, Scanner *sp) :
	 cw(0),doAuto(TRUE),myScanner(sp),siteId(-1), fSite(3)
{
	sysPrefix[sizeof(sysPrefix)-1] = 0;
	strncpy(sysPrefix,str,sizeof(sysPrefix)-1);
	this->init();
}

void
TrunkSys::initF(const char *sn)
{
	fList = new freqList(sysFn, naid,sn);
	if( !fList ) {
		printf("cannot alloc list objects\n");
		exit(1);
	}
	aid = fList->getList();
	register int i;
	register frequencyAssignment *raid = aid;
	for(i = 0; i < naid; ++i, ++raid){
		if(!cw && raid->freqdisp[0] == 'c')
			cw = raid;
		myScanner->setFreqString(raid);
	}
}

void TrunkSys::init()
{
	// static char instanceCount = 0;
	static char lineChars[] = 
	"-----------------------------------------------";
	
	//++instanceCount;
	
	_settextcolor(GREEN);
	_settextposition(FREQROW,1);
	sprintf(tempArea,"   Output   Pr %-*.*s             %*.*s",
		TITLESIZE,TITLESIZE,"",TITLESIZE,TITLESIZE,"Trunker 3.5.2");
	_outtext(tempArea);                                               
	_settextposition(FREQROW+1,1);
	sprintf(tempArea,"  Frequency ty %-*.*s  ID  T  ID  %-*.*s",
		TITLESIZE,TITLESIZE,"Destination Title",TITLESIZE,TITLESIZE,"Caller Title");
	_outtext(tempArea);
	_settextposition(FREQROW+2,1);
	sprintf(tempArea,"cdv-------- -- %*.*s ---- - ---- %-*.*s",
		TITLESIZE,TITLESIZE,lineChars,TITLESIZE,TITLESIZE,lineChars);
	_outtext(tempArea);
	_settextposition(STATROW+1,1);
	_outtext("SysId: ____ Type: ________ Title:                                        ");
  	sprintf(tempArea,"%-*.*s",sizeof(sysPrefix)-1,sizeof(sysPrefix)-1,sysPrefix);
  	QuickOut(STATROW+1,8,WHITE,tempArea);
	sprintf(sysFn,"%sSys.txt",sysPrefix);
	sprintf(idsFn,"%sIds.txt",sysPrefix);
	sprintf(grpFn,"%sGrp.txt",sysPrefix);
	sprintf(pageFn,"%sPage.txt",sysPrefix);
	groupList = new GroupDesigList(grpFn);
	idList = new desigList(idsFn);
	if( !groupList || !idList) {
		printf("cannot alloc list objects\n");
		exit(1);
	}
	initF();
	pageLog = fopen(pageFn,"at"); // append, text
	aid = fList->getList();
	_settextcolor(WHITE);
	sprintf(tmp,"%-*.*s",80-35,80-35,fList->getSysName());
	_settextposition(STATROW+1,35);
	_outtext(tmp);
	_settextposition(STATROW+1,19);
	_outtext(groupList->sysType);
	drawBar(PAGELOGBAR," Paging Log ");
	//sprintf(tmp,"%hd",(WORD)instanceCount);
	//QuickOut(PAGELOGBAR,1,GREEN,tmp);                         
	drawBar(PROMPTBAR," Command / Response Area "); 
	strcpy(types,groupList->sysType); // will amend later
}

void TrunkSys::note_site(unsigned short newSite)
{
	if( newSite != siteId && (fSite.filter(newSite) == newSite)) {
		// transition - never save for now! avoid garbage!
		//if( doAuto ) {
		//	fList->doSave(sysFn);
		//}
		char *saveOldText = strdup(fList->getSysName());
		delete fList;
		sprintf(sysFn,"%sR%hd.txt",sysPrefix,(WORD)newSite);
		initF(saveOldText);
		siteId = newSite;
	}
}

TrunkSys::~TrunkSys(){
	if(doAuto) {
		doSave();
	}
	delete groupList;
	delete idList;
	delete fList;
	if( pageLog ) fclose(pageLog);
	_settextcolor(GREEN);
	_settextposition(STATROW+1,1);
	_outtext("SysId: ____ Type: ________ Title:                                        ");
  	sprintf(tempArea,"%-*.*s",sizeof(sysPrefix)-1,sizeof(sysPrefix)-1,"");
  	QuickOut(STATROW+1,8,WHITE,tempArea);
	sprintf(tmp,"%-*.*s",31,31,"");
	_settextposition (STATROW + 1,35);
	_outtext(tmp);
	_settextposition (STATROW + 1,19);
	_outtext("        ");
	myScanner->topIs (0);
}

void
TrunkSys::doSave(){
	groupList->doSave(grpFn);
	idList->doSave(idsFn);
	fList->doSave(sysFn);
}

void
TrunkSys::unsafe() {
	if(doAuto) {
		doAuto = FALSE;
		_settextposition(STATROW+1,12);
		_settextcolor(WHITE);
		_outtext("u");

	}
}

void
TrunkSys::editGroup(unsigned short theId, const char *theTitle)
{
	register designation *theDes = groupList->get(theId);
	*theDes = theTitle;
}

void
TrunkSys::editId(unsigned short theId, const char *theTitle)
{
	register designation *theDes = idList->get(theId);
	*theDes = theTitle;
}

void
TrunkSys::note_page(unsigned short fromId, unsigned short toId)
{      
	static int firstR = PAGELOGTOP;
	static int lastR = PAGELOGBOTTOM;
	static int atR = firstR-1;
	static unsigned short lastPfrom = 0;
	static unsigned short lastPto = 0;
	static time_t prevTime = 0;

	// if duplicate page occurrence (normally all OSWs are repeated several
	// times for redundancy against errors...) suppress;
	if( lastPfrom == fromId && lastPto == toId && ((now-prevTime) < 30))
		return;
	lastPfrom = fromId;
	lastPto = toId;
	prevTime = now;
	
	if( ++atR > lastR )
		atR = firstR;
	strcpy(tempArea,ctime(&now));
	char *t = &tempArea[0];
	char *t2;
	t = strchr(tempArea,' ');
	if( t ) ++t; else t = tempArea;
	t2 = strrchr(t,' ');
	if( t2 ) *(t2+1) = '\0';
	designation *fromD = idList->get(fromId);
	designation *toD = idList->get(toId);
	sprintf(tempArea,"%s%s %.4hx Paging %.4hx %s",t,fromD->title, fromId, toId, toD->title);
	if( pageLog != NULL) { 
		fputs(tempArea,pageLog);
		fputc('\n',pageLog);
	}
	if( strlen(tempArea) > 80) {
		tempArea[80] = 0;
	} else {
		while(strlen(tempArea)<80) {
			strcat(tempArea," ");
		}
	}
	QuickOut(atR,1,WHITE,tempArea);
}                      

void
TrunkSys::expandFreqs(unsigned short freqnumber, int thresh)
{
	// assign new frequency in sorted order

	register int i;	// iterator for known frequencies
	register frequencyAssignment *raid;	// for optimization, points to each object in turn

	WORD numTimes;
	if( newFreqs.Lookup((void*)freqnumber,numTimes) ) {
		if(++numTimes >= (WORD)thresh) {
			newFreqs.RemoveKey((void*)freqnumber);
			for (i=0,raid = aid; i< naid; ++raid, ++i) // one pass over ALL objects
			{
				if(raid->freqNum > freqnumber) {
					// working backwords, boost later ones
					register int j;
					register frequencyAssignment *prev;
					for( raid = aid+naid,j = naid, prev = raid - 1;
					     j > i; --j,--raid,--prev) {
						*raid = *prev;
						++(raid->y);
						raid->show();
						prev->unassign();
					}
					break;
				}
							
			}  	
			raid->create(i,freqnumber); // assign screen position & freq,auto-displays
			myScanner->setFreqString(raid);
			// next pass will assign
			if (naid<(MAXFREQS - 1))
				++naid;
		} else {
			newFreqs.SetAt((void*)freqnumber,numTimes);
		}
	} else {
		newFreqs.SetAt((void*)freqnumber,1);
	}
}

void
TrunkSys::note_affiliation(unsigned short radioId, unsigned short groupId)
{
	register designation *toDes = groupList->get(groupId);
	register designation *fromDes = idList->get(radioId);
	fixNew(fromDes,toDes); 
}
