#include <stdio.h>
#include <windows.h>
#include <conio.h>

/* local defines */

#define STX 0x02
#define ETX 0x03
#define EOT 0x04
#define ACK 0x06
#define CR  0x0D
#define NAK 0x15
#define ESC 0x1B

HANDLE port;


int rx_get(int timeout)
{
   COMMTIMEOUTS CommTimeOuts;
   char buffer[2];
   unsigned long bytes_read;

   CommTimeOuts.ReadIntervalTimeout = 0xFFFFFFFF;
   CommTimeOuts.ReadTotalTimeoutMultiplier = timeout * 1000;
   CommTimeOuts.ReadTotalTimeoutConstant = 1000;
   CommTimeOuts.WriteTotalTimeoutMultiplier = 0;
   CommTimeOuts.WriteTotalTimeoutConstant = 1000;

   SetCommTimeouts(port, &CommTimeOuts);

   ReadFile(port, buffer, 1, &bytes_read, NULL);
   if (bytes_read == 0)
      return (-1);

   return (buffer[0]);
}


void tx_put(unsigned char ch)
{
   unsigned long bytes_written;

   WriteFile(port, &ch, 1, &bytes_written, NULL);
}


void tx_put_string(char *s)
{
   while (*s)
      tx_put(*s++);
}

int wait_connect(char *phone_number)
{
   int c, index;
   char input_buffer[40];
   int connected;
   int count;

   printf("\nCalling...");
   tx_put_string("ATDT ");
   tx_put_string(phone_number); tx_put(CR);

   index=0;
   c=rx_get(180);                            /* wait 180 sec for a response */
   if (c == -1) return(1);

   input_buffer[index++]=c;                 /* if response then store char */
   while ( (c=rx_get(1)) != -1 )            /* get input chars until idle */
      input_buffer[index++]=c;
   input_buffer[index] = 0;

   if ( strstr(input_buffer, "CONNECT") != 0 )
   {
      connected = 0;
      count = 0;
      while ( (! connected) && (count < 10) )
      {
         count++;
         tx_put(CR);
         c = rx_get(2);
         if (c != -1)
         {
            index = 0;
            input_buffer[index++] = c;
            while ((c = rx_get(1)) != -1)
               input_buffer[index++] = c;
               input_buffer[index] = 0;

            if ( strcmp(input_buffer, "ID=") == 0 )
            {
               tx_put(ESC); tx_put_string("PG1Veter");
               tx_put(CR);

               c = rx_get(10);
               if ( c != -1 )
               {
                  index = 0;
                  input_buffer[index++] = c;
                  while ( (c = rx_get(1)) != -1)
                     input_buffer[index++] = c;
                  input_buffer[index] = 0;

                  if ( (input_buffer[0] == CR) &&
                       (input_buffer[1] == ACK) &&
                       (input_buffer[2] == CR) )
                     if ( (input_buffer[3] == ESC) &&
                          (input_buffer[4] == '[') &&
                          (input_buffer[5] == 'p') &&
                          (input_buffer[6] == CR))
                        return(0);
                     else
                     {
                        c = rx_get(10);
                        if ( c != -1 )
                        {
                           index = 0;
                           input_buffer[index++] = c;
                           while ( (c = rx_get(1)) != -1)
                              input_buffer[index++] = c;
                           input_buffer[index] = 0;

                           if ( (input_buffer[0] == ESC) &&
                                (input_buffer[1] == '[') &&
                                (input_buffer[2] == 'p') &&
                                (input_buffer[3] == CR))
                              return(0);
                        }
                     }
               }

               return(1);
            }
         }
      }
   }

   return(1);
}


int ixo_send(char *pin, char *message)
{
   int c;
   char input_buffer[10];
   char output_buffer[1009];
   int index;
   int checksum;

   output_buffer[0] = STX;
   output_buffer[1] = 0;
   strcat( output_buffer, pin );
   strcat( output_buffer, "\r" );
   strcat( output_buffer, message );
   strcat( output_buffer, "\r" );
   index = strlen( output_buffer );
   output_buffer[index++] = ETX;
   output_buffer[index++] = 0;

   checksum = 0;
   for ( index=0; output_buffer[index]; index++ )
      checksum = (checksum + output_buffer[index]) & 0xFFF;

   output_buffer[index++] = (checksum >> 8) + '0';
   output_buffer[index++] = ((checksum & 0xFF) >> 4) + '0';
   output_buffer[index++] = (checksum & 0x0F) + '0';
   output_buffer[index++] = CR;
   output_buffer[index] = 0;

   tx_put_string(output_buffer);

   c = rx_get(10);
   if ( c != -1 )
   {
      index = 0;
      input_buffer[index++] = c;
      while ( (c = rx_get(1)) != -1)
         input_buffer[index++] = c;
      input_buffer[index] = 0;

      if ( (input_buffer[0] == CR) &&
           (input_buffer[1] == ACK) &&
           (input_buffer[2] == CR) )
         return(0);
   }

   return(1);
}


int main (int argc, char *argv[])
{
   COMMTIMEOUTS CommTimeOuts;
   DCB          dcb;
   int c, index, modem, status;
   char input_buffer[256];
   char *pin;
   char *message;
   char *phone_number;
   
   if (argc < 4)
   {
      printf("\nUsage: TAPP <COMx> <phone number> <PIN> <message>\n");
      return (0);
   }

   if ((port = CreateFile(argv[1], GENERIC_READ | GENERIC_WRITE,
                     0,                    // exclusive access
                     NULL,                 // no security attrs
                     OPEN_EXISTING,
                     FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE)
   {
      printf("\nError opening port: %s\n", argv[1]);
      return (0);
   }

   SetupComm(port, 4096, 4096);  // setup device buffers

   // purge any information in the buffer

   PurgeComm(port, PURGE_TXABORT | PURGE_RXABORT |
                   PURGE_TXCLEAR | PURGE_RXCLEAR);

   CommTimeOuts.ReadIntervalTimeout = 0xFFFFFFFF;
   CommTimeOuts.ReadTotalTimeoutMultiplier = 1000;
   CommTimeOuts.ReadTotalTimeoutConstant = 1000;
   CommTimeOuts.WriteTotalTimeoutMultiplier = 0;
   CommTimeOuts.WriteTotalTimeoutConstant = 1000;

   SetCommTimeouts(port, &CommTimeOuts);

   dcb.BaudRate     = CBR_1200;
   dcb.ByteSize     = 7;
   dcb.Parity       = EVENPARITY;
   dcb.StopBits     = ONESTOPBIT;
   dcb.fOutxDsrFlow = 0;
   dcb.fDtrControl  = DTR_CONTROL_ENABLE;
	dcb.fOutxCtsFlow = 0;
   dcb.fRtsControl  = RTS_CONTROL_ENABLE;
   dcb.fInX         = 0;
   dcb.fOutX        = 0;
   dcb.XonChar      = 0;
   dcb.XoffChar     = 0;
   dcb.XonLim       = 100;
   dcb.XoffLim      = 100;
   dcb.fBinary      = 1;
   dcb.fParity      = 1;

   SetCommState(port, &dcb);

   printf("\nAttempting to connect to modem...");

   tx_put(CR);
   tx_put_string("AT"); tx_put(CR);
   while ( (c=rx_get(2)) != -1 );

   tx_put_string("ATE0Q0V1"); tx_put(CR);
   while ( (c=rx_get(1)) != -1 );              /* flush rx characters */

   tx_put_string("AT"); tx_put(CR);

   index = 0;
   while ( (c = rx_get(3)) != -1 )            /* wait for response */
      input_buffer[index++] = c;
   input_buffer[index] = 0;

   index = 0;
   modem = 0;
   while ( (input_buffer[index]) && (! modem) )
   {
      toupper(input_buffer[index]);
      toupper(input_buffer[index+1]);
      if ( (input_buffer[index]=='O') && (input_buffer[index+1]=='K') )
         modem = 1;
      else
         index++;
   }

   if (! modem)
   {
      printf("\nCould not contact modem on %s\n", argv[1]);
      return (0);
   }

   phone_number = argv[2];
   pin = argv[3];
   message = argv[4];

   status = wait_connect(phone_number);
   if (status != 0)
      printf("\nNot able to connect to paging system!\n");
   else
   {
      printf("\nSending message \"%s\" to PIN %s...", argv[4], argv[3]);

      status = ixo_send(pin, message);
      if (status != 0)
         printf("\nMessage REJECTED!\n");
      else
         printf("\nMessage accepted!\n");
   }

   CloseHandle(port);

   if (status != 0)
      return (0);  // bad status
   else
      return (1);  // good status
}

