/*
		Basic Linux Networking Header Information. v1.0

   		   c. daemon9, Guild Corporation 1996

Includes:

	tap
	in_cksum
	nameResolve
	hostLookup	
	shadow
	reaper

	This is beta.  Expect it to expand greatly the next time around ...
	Sources from all over the map.

		code from:
			route
			halflife
*/

#include <string.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <linux/socket.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/if_ether.h>
#include <linux/if.h>

#define DEVICE 		"eth0"
#define BUFSIZE 	256
#define ETHHDR 		14
#define TCPHDR 		20
#define IPHDR  		20
#define ICMPHDR 	8


/*
 *      IP address into network byte order
 */
                 
unsigned nameResolve(char *hostname){
        
        struct in_addr addr;
        struct hostent *hostEnt; 
   
        if((addr.s_addr=inet_addr(hostname))==-1){
                if(!(hostEnt=gethostbyname(hostname))){
                        fprintf(stderr,"Name lookup failure: `%s`\n",hostname);
                        exit(0);
                }
                bcopy(hostEnt->h_addr,(char *)&addr.s_addr,hostEnt->h_length);
        }
        return addr.s_addr;
}
 
/*
 *      IP Family checksum routine
 */

unsigned short in_cksum(unsigned short *ptr,int nbytes){
                        
        register long           sum;            /* assumes long == 32 bits */
        u_short                 oddbyte;
        register u_short        answer;         /* assumes u_short == 16 bits */
                        
        /*
         * Our algorithm is simple, using a 32-bit accumulator (sum),
         * we add sequential 16-bit words to it, and at the end, fold back 
         * all the carry bits from the top 16 bits into the lower 16 bits. 
         */
        
        sum = 0;
        while (nbytes > 1)  {
                sum += *ptr++;
                nbytes -= 2;    
        }
                        
                                /* mop up an odd byte, if necessary */
        if (nbytes == 1) {
                oddbyte = 0;            /* make sure top half is zero */
                *((u_char *) &oddbyte) = *(u_char *)ptr;   /* one byte only */
                sum += oddbyte;
        }               
  
        /*
         * Add back carry outs from top 16 bits to low 16 bits.
         */
         
        sum  = (sum >> 16) + (sum & 0xffff);    /* add high-16 to low-16 */
        sum += (sum >> 16);                     /* add carry */
        answer = ~sum;          /* ones-complement, then truncate to 16 bits */
        return(answer);
}


/*
 *	Creates a low level raw-packet socket and puts the device into promiscuous mode.
 */

int tap(device)
char *device;
{
	
	int fd;				/* File descriptor */
   	struct ifreq ifr;		/* Link-layer interface request structure */
					/* Ethernet code for IP 0x800==ETH_P_IP */
   	if((fd=socket(AF_INET,SOCK_PACKET,htons(ETH_P_IP)))<0){	/* Linux's way of */ 
      		perror("SOCK_PACKET allocation problems");	/* getting link-layer */
      		exit(1);					/* packets */
   	}
	strcpy(ifr.ifr_name,device);				
   	if((ioctl(fd,SIOCGIFFLAGS,&ifr))<0){			/* Get the device info */
      		perror("Can't get device flags");
      		close(fd);
      		exit(1);
   	}
   	ifr.ifr_flags|=IFF_PROMISC;				/* Set promiscuous mode */
   	if((ioctl(fd,SIOCSIFFLAGS,&ifr))<0){			/* Set flags */
		perror("Can't set promiscuous mode");
   		close(fd);
		exit(1);
	}
	return(fd);
}

/*
 *	Network byte order into IP address
 */

char *hostLookup(in)
unsigned long in;
{
 
   	char hostname[BUFSIZE];
   	struct in_addr addr;
   	struct hostent *hostEnt;
   
	bzero(&hostname,sizeof(hostname));
	addr.s_addr=in;
   	hostEnt=gethostbyaddr((char *)&addr, sizeof(struct in_addr),AF_INET);
   	if(!hostEnt)strcpy(hostname,inet_ntoa(addr));
   	else strcpy(hostname,hostEnt->h_name);
   	return(strdup(hostname));
}
 
/*
 *      Simple daemonizing procedure.
 */   

void shadow(void){

        int fd,fs;
        extern int errno;
     	char werd[]={"\n\n\n\nHades is a Guild Corporation Production.  c.1996\n\n"}; 

        signal(SIGTTOU,SIG_IGN);        /* Ignore these signals */
        signal(SIGTTIN,SIG_IGN);
        signal(SIGTSTP,SIG_IGN);
	printf(werd);

        switch(fork()){
               case 0:                 /* Child */
                        break;
                default:        
                        exit(0);        /* Parent */
                case -1:
                        fprintf(stderr,"Forking Error\n");
                        exit(1);
        }
        setpgrp();
        if((fd=open("/dev/tty",O_RDWR))>=0){
                ioctl(fd,TIOCNOTTY,(char *)NULL);
                close(fd);
        }
        /*for(fd=0;fd<NOFILE;fd++)close(fd);*/
        errno=0;
        chdir("/");
        umask(0);
}

/*
 *      Keeps processes from zombiing on us...
 */
        
static void reaper(signo)
int signo;
{
        pid_t pid;
        int sys;

        pid=wait(&sys); 
        signal(SIGCHLD,reaper);
        return;
}
