/*
 *  $Id$
 *
 *  Linux pingd sourcefile
 *  pingd.h - function prototypes, global data structures, and macros
 *  Copyright (c) 1998 by daemon9|route (route@infonexus.com)
 *
 *
 *
 */

#ifndef _PINGD_H
#define _PINGD_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <pwd.h>
#include <syslog.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <libnet.h>

#define VERSION         "0.5.1"
#define NOBODY          "nobody"        /* Nobody pwnam */
#define STRING_UNKNOWN  "unknown"       /* From tcpd.h */
#define HEADER_MATERIAL 28              /* ICMP == 8 bytes, IP == 20 bytes */
#define UNREACH_AMT     28              /* IP header + 8 bytes of data */
#define MAX_PAYLOAD     1472            /* This shouldn't be larger then
                                         * the smallest MTU on the machine
                                         * We arrive here from: (1500 - 20 - 8)
                                         */
#define MAX_PACKET      sizeof(struct icmp_packet)
#define MIN_PACKET      sizeof(struct ip) + sizeof(struct icmphdr)

struct icmp_packet
{
    struct ip iph;
    struct icmphdr icmph;
    u_char payload[MAX_PAYLOAD];
};

int u           = 0;                /* Should we send unreachables?  */
int d           = 0;                /* Debuging level (defaults off) */
int max_packet  = 1024;             /* Maximum packet size (default) */
#ifdef  SKEW_RTT
long skew_vector = 0;                /* deviation */
#endif  /* SKEW_RTT */

u_char *options[] =
    {
#ifdef  WRAP
    " Access-control enabled\n",
#endif
#ifdef  LOG
    " Syslog logging enabled\n",
#endif
#ifdef  VERIFY_CHECKSUM
    " ICMP header checksum verification\n",
#endif
#ifdef  SKEW_RTT
    " Packet RTT skewing available\n",
#endif
    0};


void
usage(
    char *                  /* pointer to argv[0] */
    );

int                         /* 1 if the packet is allowed, 0 if denied */
verify(
    struct icmp_packet *    /* pointer to the ICMP packet in question */
    );

void
icmp_reflect(
    int,                    /* ICMP packet type */
    struct icmp_packet *,   /* pointer to the ICMP packet in question */
    int                     /* socket file descriptor */
    );

int                         /* 1 if access is granted, 0 if denied */
hosts_ctl(
    char *,                 /* daemon name */
    char *,                 /* client name (canonical) */
    char *,                 /* client address (dots 'n' decimals) */
    char *                  /* client user (unused) */
    );

void
version_info(
    char *                  /* pointer to argv[0] */
    );

void
skew_rtt(
    struct icmp_packet *    /* pointer to the ICMP packet in question */
    );

int
is_local(
    struct icmp_packet *    /* pointer to the ICMP packet in question */
    );

#endif  /* _PINGD_H */

/* EOF */
