/*
  Cellular Call Control Program
  Copyright (C) 1994 by Network Wizards
*/

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <bios.h>
#include <ctype.h>
#include <math.h>
#include <string.h>

#define cursor(x,y)	gotoxy(y,x)
#define OUTPUT_WINDOW   window(1,4,80,24)
#define FULL_WINDOW     window(1,1,80,25)

#define FALSE		0
#define TRUE		1

#define VERSION	        "2.0(940210)"   /* major.minor(last-edit-date) */

typedef unsigned char bool;
typedef unsigned char byte;
typedef unsigned int  word;

#include "ctlib.h"

#define BUFLEN		128
#define ESC		0x1B

char buf[BUFLEN];

/* control channel scan mode storage */
char ps_system;
int  ps_cc;				/* control channel */
int  ps_cc_rss;				/* control channel last rss */

char ournum[32];			/* our telephone number */
unsigned long ouresn;			/* our esn */

byte testaddr = 0;
byte testpos = 0;

main(argc,argv)
  int argc;
  char *argv[];
{
  int i;
  
  /* initialize ct library using the specified COM port */
  if (argc > 1)
  {
    if (*argv[1] == '1')
      ct_lib_init(900,0x3f8,4);
    else if (*argv[1] == '2')
      ct_lib_init(900,0x2f8,3);
    else if (*argv[1] == '3')
      ct_lib_init(900,0x3e8,5);
    else
    {
      puts("Type 'TEL 2' to use COM2");
      exit(0);
    }
  }
  else
    ct_lib_init(900,0x3f8,4);		/* com1 by default */

  cprintf("Wait...");
  /* power up oki and tell it what mode to use */
  if (!ct_on(MODE_TEST))
  {
    cprintf("?No response from OKI\r\n");
    cprintf("  Make sure the phone is turned OFF and\r\n");
    cprintf("  all cables are properly attached.\r\n");
    cleanup();
    exit(1);
  }

  /* read in nam info to get our phone number */
  if (!ct_get_nams())
  {
    cprintf("?Can't read NAM info\r\n");
    cleanup();
    exit(1);
  }
  strcpy(ournum,nam_info[ct_state.namindex].number);	/* use current nam */
  clrscr(); cursor(1,1);
  cprintf("Tel# is %s, ",ournum);

  if (!ct_get_esn(&ouresn))
  {
    cprintf("?Can't get ESN\r\n");
    cleanup();
    exit(1);
  }
  cprintf("ESN is %08lx\r\n",ouresn);

  if (ournum[13] & 0x01)		/* even or odd min? */
    ct_stream(1);			/* watch odd stream */
  else
    ct_stream(0);			/* watch even stream */
  
  cursor(25,1);
  cputs("N: rescan     S: start call    R: receive call    ESC exit");
  OUTPUT_WINDOW;
  cursor(21,1);

  cmd_page_scan();			/* enter main program loop */

  FULL_WINDOW;
  cursor(25,1); clreol();
  cursor(24,1);
  cleanup();
  exit(0);
}

cleanup()
{
  ct_off();				/* turn off phone */
  ct_lib_done();			/* cleanup library stuff */
}

/*
  scan control channel and display received messages,
  while waiting for commands from pc keyboard.
 */
cmd_page_scan()
{
  byte cmd;
  word key;
  byte mems[16];
  bool get_msg_sent;
  byte *msg, *min;
  int scc,dcc,order,ordq,local,chan,vmac;

  dcc = 0;
  ct_set_rx_audio(FALSE);		/* mute audio */
  get_msg_sent = FALSE;
  ps_system = tolower(nam_info[ct_state.namindex].sys);
  find_cc();
  
  /* main command loop */ 
  for (;;)
  {
    if (bioskey(1) != 0)		/* if keypress waiting */
    {
      if (get_msg_sent)			/* and if we're waiting for a msg */
      {
	get_msg_sent = FALSE;
	ct_fcc_msg(MSG_ABORT,NULL);	/* then abort waiting for msg */
      }
      key = bioskey(0);			/* read keypress codes */
      cmd = key & 0x00ff;		/* get ascii code if any */
      if (cmd == ESC)
	break;
      if (isupper(cmd))
	cmd = tolower(cmd);
      switch (cmd)
      {
	case 'n': find_cc(); break;
	case 's': cmd_startcall(dcc); break;
	case 'r': cmd_receivecall(dcc); break;
	default:  break;
      }
    }
    if (!get_msg_sent)
    {
      ct_fcc_msg(MSG_SETUP,NULL);	/* get ready for a control chnl msg */
      get_msg_sent = TRUE;
    }
    if (!ct_fcc_msg(MSG_GET,&mems))	/* incoming msg received? */
      continue;				/* no, keep waiting */
    get_msg_sent = FALSE;

   if (!ct_decode_fcc_msg(mems,&scc,&dcc,&min,&order,&ordq,&local,&chan,&vmac))
      continue;				/* ignore invalid msgs */

    /* display decoded msg (order or channel allocation) */
    if (scc == 3)
    {
      cprintf("dcc %d: %s %s\r\n",dcc,min,ct_decode_order(order,ordq));
    }
    else
      cprintf("dcc %d: %s setup: chan=%d, vmac=%d, scc=%d\r\n",
	      dcc,min,chan,vmac,scc);

    /* if we are paged, notify user */
    if ((scc == 3) && (order == 0) && (!strncmp(min,ournum,14)))
      cprintf("incoming call request (type 'R' to answer)\007\r\n");

    /* if a voice channel is allocated for us, then go for it */
    if ((scc != 3) && (!strncmp(min,ournum,14)))
    {
      cprintf("  tune to channel %d\r\n",chan);
      ct_set_channel(chan);
      cprintf("  set power level to %d\r\n",vmac);
      ct_set_tx_power(vmac);
      cprintf("  carrier on\r\n");
      ct_set_carrier(TRUE);
      cprintf("  set sat to %d\r\n",scc);
      ct_set_sat(scc);
      cprintf("  audio on\r\n");
      ct_set_audio_path(AUDIO_EARPIECE);
      ct_set_volume(0);
      ct_set_rx_audio(TRUE);
      ct_set_tx_audio(TRUE);
      conversation_mode();		/* enter conversation mode */
      cprintf("  carrier off\r\n");
      ct_set_carrier(FALSE);
      cprintf("  audio off\r\n");
      ct_set_rx_audio(FALSE);
      ct_set_tx_audio(FALSE);
      find_cc();			/* find a control channel */
    }
  }
}

/* scan all control channels of a system for strongest one */
find_cc()
{
  int chnl, rss, tmp;
  int hi_chnl, hi_rss;
  int beg, end;
    
  cprintf("Scanning for control channel:  ");

  /* set lower and upper control channel numbers depending on system type */
  if (ps_system == 'a')
  {
    beg = 313;
    end = 333;
  }
  else
  {
    beg = 334;
    end = 354;
  }

  /* find the control channel with the strongest signal */
  hi_rss = 0;
  for (chnl = beg; chnl <= end; chnl++)
  {
    ct_set_channel(chnl);
    /* get rss a few times to let settle */
    rss = ct_get_rss();
    while ((tmp = ct_get_rss()) > rss)
      rss = tmp;
    if (rss > hi_rss)			/* if highest rss, remember it */
    {
      hi_rss = rss;
      hi_chnl = chnl;
    }
  }
  ps_cc = hi_chnl;			/* get channel with highest rss */
  ps_cc_rss = hi_rss;
  ct_set_channel(ps_cc);
  cprintf("%d\r\n",ps_cc);
  FULL_WINDOW;
  cursor(2,1);
  cprintf("Control Channel: %04d, ",ps_cc);
  cprintf("Received Signal Strength: %02d\r\n",ps_cc_rss);
  OUTPUT_WINDOW;
  cursor(21,1);
}

cmd_receivecall(dcc)
  int dcc;
{
  unsigned long min1, min2;
  
  cprintf("answering page request\r\n");
  ct_tel2min(ournum,&min1,&min2);
  send_callrequest(dcc,min1,min2,ouresn,NULL);
}

cmd_startcall(dcc)
  int dcc;
{
  unsigned long min1, min2;
  
  cprintf("Call tel#: ");
  buf[0] = 32;
  cgets(buf);
  cprintf("\r\nsending call request\r\n");
  ct_tel2min(ournum,&min1,&min2);
  send_callrequest(dcc,min1,min2,ouresn,buf+2);
}

/* returns the decimal value of the next ascii digit from a string */
char *nexttp;
int nextdigit()
{
  char x;
  
  while (*nexttp != '\0')
  {
    if (isdigit(*nexttp)) break;
    nexttp++;
  }
  if (*nexttp == '\0')
    return(0);
  x = *nexttp;
  nexttp++;
  if (x == '0')
    return(10);
  return(x - '0');
}

/* if telnum is NULL, send page reply; otherwise send call request */
send_callrequest(dcc,min1,min2,ouresn,telnum)
  int dcc;
  unsigned long min1, min2, ouresn;
  char *telnum;
{
  int i;
  byte msg[30];				/* 5 word message to send */

  for (i = 0; i < 30; i++)		/* clear message area */
    msg[i] = '\0';

  /* Word A:  Abbreviated Address Word */ 
  /* F=1, NAWC=4, T=1, S=1, E=1, RSVD=0 */
  if (telnum != NULL)
    msg[0] = 0xce;
  else
    msg[0] = 0xa6;
  /* SCM = 1010, MIN1 */
  msg[1] = 0xa0 | (min1 >> 20);
  msg[2] = (min1 & 0x0ff000) >> 12;
  msg[3] = (min1 & 0x000ff0) >> 4;
  msg[4] = (min1 & 0x00000f) << 4;
  ct_gen_bch(36,msg);

  /* Word B:  Extended Address Word */
  /* F=0, NAWC=3, LOCAL=0 */
  if (telnum != NULL)
    msg[6]  = 0x30;
  else
    msg[6]  = 0x10;
  /* LOCAL=0, ORDQ=0, ORDER=0 */
  msg[7]  = 0x00;
  msg[8]  = 0x00;
  msg[9]  = (min2 >> 4);
  msg[10] = (min2 & 0x000f) << 4;
  ct_gen_bch(36,msg+6);

  /* Word C:  Serial Number Word */
  if (telnum != NULL)
    msg[12] = 0x20 | (ouresn >> 28);
  else
    msg[12] = 0x00 | (ouresn >> 28);
  msg[13] = (ouresn & 0x0ff00000) >> 20;
  msg[14] = (ouresn & 0x000ff000) >> 12;
  msg[15] = (ouresn & 0x00000ff0) >> 4;
  msg[16] = (ouresn & 0x0000000f) << 4;
  ct_gen_bch(36,msg+12);

  /* Word D: telephone number to dial (digits 1-8) */
  if (telnum != NULL)
  {
    nexttp = telnum;
    msg[18] = 0x10 | nextdigit();
    msg[19] = nextdigit() << 4;
    msg[19] = msg[19] | nextdigit();
    msg[20] = nextdigit() << 4;
    msg[20] = msg[20] | nextdigit();
    msg[21] = nextdigit() << 4;
    msg[21] = msg[21] | nextdigit();
    msg[22] = nextdigit() << 4;
  }
  ct_gen_bch(36,msg+18);

  /* Word E: telephone number to dial (digits 9-16) */
  if (telnum != NULL)
  {
    msg[24] = nextdigit();
    msg[25] = nextdigit() << 4;
    msg[25] = msg[25] | nextdigit();
    msg[26] = nextdigit() << 4;
    msg[26] = msg[26] | nextdigit();
    msg[27] = nextdigit() << 4;
    msg[27] = msg[27] | nextdigit();
    msg[28] = nextdigit() << 4;
  }
  ct_gen_bch(36,msg+24);

  cprintf("tx rcc msg: ");
  for (i = 0; i < 30; i++)
  {
    cprintf("%02x",msg[i]);
    if (((i+1) % 6) == 0)
      cprintf(" ");
  }
  cprintf("\r\n");

  if (!ct_rcc_msg(dcc,msg))			/* send it */
    cprintf("Failed to send message!\r\n");
}

/* handle a call once the voice channel has been set up */
conversation_mode()
{
  bool alerted;
  byte word1[6];
  int scc,pscc,order,ordq,local,chan,vmac;
  
  alerted = FALSE;
  cprintf("hit any char to hangup\r\n");
  ct_fvc_msg(MSG_SETUP,NULL);
  for (;;)
  {
    if (kbhit())
      break;
    if (!ct_fvc_msg(MSG_GET,word1)) continue;

    /* got an order from base station, so decode it */
    if (!ct_decode_fvc_msg(word1,&scc,&pscc,&order,&ordq,&local,&chan,&vmac))
    {
      ct_fvc_msg(MSG_SETUP,NULL);	/* get ready for next msg */
      continue;				/* ignore bad messages */
    }

    if (scc == 3)			/* if order received */
    {
      cprintf("  order: %s\r\n",ct_decode_order(order,ordq));
      if (order == 1)			/* alert? */
      {
	if (!alerted)
	{
	  cprintf("  signalling tone on\r\n");
	  ct_set_signalling_tone(TRUE);	/* ST on */
	}
	alerted = TRUE;
	delay(1000);
	cprintf("  signalling tone off\r\n");
	ct_set_signalling_tone(FALSE);	/* ST off (answer call) */
      }
      if (order == 6)			/* stop alert? */
      {
	cprintf("  signalling tone off\r\n");
	ct_set_signalling_tone(FALSE);	/* ST off */
      }
      ct_fvc_msg(MSG_SETUP,NULL);	/* get ready for next msg */
      if (order == 3)			/* end of call if release order */
	break;
      continue;
    }

    /* otherwise its a handoff request */
    cprintf("  handoff msg: chan=%d, vmac=%d\r\n",chan,vmac);
    cprintf("  signalling tone flash (50ms)\r\n");
    ct_set_signalling_tone(TRUE);
    delay(50);
    ct_set_signalling_tone(FALSE);
    cprintf("  carrier off\r\n");
    ct_set_carrier(FALSE);
    cprintf("  tune to channel %d\r\n",chan);
    ct_set_channel(chan);
    cprintf("  set power level to %d\r\n",vmac);
    ct_set_tx_power(vmac);
    cprintf("  set sat to %d\r\n",scc);
    ct_set_sat(scc);
    cprintf("  carrier on\r\n");
    ct_set_carrier(TRUE);
    ct_fvc_msg(MSG_SETUP,NULL);		/* rcv next msg */
  }
  ct_fvc_msg(MSG_ABORT,NULL);
  /* hangup/release */
  cprintf("hanging up\r\n");
  cprintf("  signalling tone flash (2sec)\r\n");
  ct_set_signalling_tone(TRUE);
  sleep(2);
  ct_set_signalling_tone(FALSE);
}
