	title	Determine CPU processor type
	name	_proc_type

; This routine returns the processor type in the AX:
;	AX	CPU type
;	---	--------
;	30h	NEC V20/V30
;	86h	INTEL 8088/8086
;	186h	INTEL 80188/80186
;	286h	INTEL 80286
;	386h	INTEL 80386

_text	segment	byte public 'code'
	assume	cs:_text

	public	_proc_type

_proc_type	proc	near
	PUSH	BP		; Save BP
	MOV	BP,SP

	pushf			; Save FLAG registers
	xor	ax,ax		; Clear AX and push onto the stack.
	push	ax
	popf			;  Pop a zero into FLAGs register
	pushf			;  Attempt to set bit 12-15 to a zero
	pop	ax		;  Recover FLAG word
	and	ax, 0f000h	;  If Bits 12-15 are set then the processor
	cmp	ax, 0f000h	;  is an 8018x or an 808x
	jz	is_0_1		
 
	mov	ax, 07000h	;  Try to set FLAG bits 12-14 (NT, IOPL)
	push 	ax
	popf			;  put 07000H into flags
	pushf
	pop	ax

	and	ax,07000h	;  if bits 12-14 are cleared then the
	jz	is_80286	;	processor is an 286

is_80386:			;	Else it is a 386 
	mov	ax, 386h	;	return 386 in AX
	jmp	done
is_80286:
	mov	ax, 286h	;  return 286 in AX
	jmp	done
is_0_1:				;It is a 8086, a 80186, or a V20/V30
	push 	cx		;  Save CX the only other register used	
	mov	ax, 0ffffh	;  Set AX to all 1s
	mov	cl, 33		;  Will shift it 33 times if it is an
				;  808x, or 1 time if it is an 8018x.
	shl	ax, cl		;  If we shift 33 times all bits are
	jnz	is_80186	;  zero. If any bits are on it's an 18x 
is_8086:			;  Else we have an 8086 or V20/V30.
	pop	cx		;  restore cx
	xor	al,al		;  Sets ZF
	mov	al,40h		;  64 decimal
	mul	al		;  64**2 > 255
	jz	is_v30		;  V20/V30 MUL leaves ZF untouched
				;  8086 ZF==OF after MUL
	mov	ax,86h		;  Return 86 in AX
	jmp	done	
is_v30:
	mov	ax,30h		;  Return 30 in AX
	jmp	done	
	
is_80186:
	mov 	ax, 186h	;  Return 186 in AX
	pop	cx			

done:
	popf			; Recover original FLAG register
	POP	BP		; Restore BP
	ret

_proc_type	endp

_text	ends
	end
