*       Program to do problem 6.3
*       This interrupt service routine generates a 200 Hz signal.

TOC3    equ $101a
TCTL1   equ $1020
TMSK1   equ $1022
TFLG1   equ $1023

        org $4000       start of RAM
stack   rmb 31
stacktop  rmb 1

        ORG $5000       START OF CODE
start   lds #stacktop   load stack pointer
        ldaa #$10       make OC3 toggle
        staa TCTL1
        ldaa #$20       enable interrupts from OC3
        staa TMSK1
        cli             enable I level interrupts
next    bra next        do something

OC3_ISR ldaa #$20       reset OC3 flag
        staa TFLG1
        ldd TOC3        update timer value
        addd #2500*2    add 2.5 msec
        std TOC3        store back
        rti             return from interrupt

        org $ffe4       fill OC3 vector
        fdb OC3_ISR

        org $fffe       fill RESET vector
        fdb start
